/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.model.LogctlSpec;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public final class ApplicationContainer
extends Container
implements QrStartConfig.Producer,
ZookeeperServerConfig.Producer {
    private final boolean isHostedVespa;
    private List<LogctlSpec> logctlSpecs = List.of();

    public ApplicationContainer(TreeConfigProducer<?> parent, String name, int index, DeployState deployState) {
        this(parent, name, false, index, deployState);
    }

    public ApplicationContainer(TreeConfigProducer<?> parent, String name, boolean retired, int index, DeployState deployState) {
        super(parent, name, retired, index, deployState);
        this.isHostedVespa = deployState.isHosted();
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.NetworkMultiplexerHolder"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.NetworkMultiplexerProvider"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.SessionCache"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.SystemInfoProvider"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.ZoneInfoProvider"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.ClusterInfoProvider"));
    }

    void setLogctlSpecs(List<LogctlSpec> logctlSpecs) {
        this.logctlSpecs = logctlSpecs;
    }

    @Override
    public List<LogctlSpec> getLogctlSpecs() {
        return this.logctlSpecs;
    }

    public void getConfig(QrStartConfig.Builder builder) {
        NodeResources nodeResources;
        if (this.getHostResource() != null && !(nodeResources = this.getHostResource().realResources()).isUnspecified()) {
            builder.jvm.availableProcessors(Math.max(2, (int)Math.ceil(nodeResources.vcpu())));
        }
    }

    @Override
    protected ContainerServiceType myServiceType() {
        return ContainerServiceType.CONTAINER;
    }

    @Override
    public String getJvmOptions() {
        String jvmArgs;
        StringBuilder b = new StringBuilder();
        if (this.isHostedVespa) {
            b.append("-Djdk.tls.server.enableStatusRequestExtension=true ").append("-Djdk.tls.stapling.responseTimeout=2000 ").append("-Djdk.tls.stapling.cacheSize=256 ").append("-Djdk.tls.stapling.cacheLifetime=3600 ");
        }
        if (!(jvmArgs = super.getJvmOptions()).isBlank()) {
            b.append(jvmArgs.trim());
        }
        return b.toString().trim();
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        builder.myid(this.index());
    }

    @Override
    protected String jvmOmitStackTraceInFastThrowOption(ModelContext.FeatureFlags featureFlags) {
        return featureFlags.jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type.container);
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        return Optional.of(this.prepareStopCommand(Duration.ofMinutes(6L)));
    }
}

