/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.NumericDataType;
import com.yahoo.schema.Index;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashSet;
import java.util.Set;

public class IntegerIndex2Attribute
extends Processor {
    public IntegerIndex2Attribute(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            if (!field.doesIndexing() || !(field.getDataType().getPrimitiveType() instanceof NumericDataType) || field.getIndex(field.getName()) != null && !field.getIndex(field.getName()).getType().equals((Object)Index.Type.VESPA)) continue;
            ScriptExpression script = field.getIndexingScript();
            HashSet<String> attributeNames = new HashSet<String>();
            new MyVisitor(attributeNames).visit((Expression)script);
            field.setIndexingScript((ScriptExpression)new MyConverter(attributeNames).convert((Expression)script));
            this.warn(this.schema, field, "Changed to attribute because numerical indexes (field has type " + field.getDataType().getName() + ") is not currently supported. Index-only settings may fail. Ignore this warning for streaming search.");
        }
    }

    private static class MyVisitor
    extends ExpressionVisitor {
        final Set<String> attributeNames;

        public MyVisitor(Set<String> attributeNames) {
            this.attributeNames = attributeNames;
        }

        protected void doVisit(Expression exp) {
            if (exp instanceof AttributeExpression) {
                this.attributeNames.add(((AttributeExpression)exp).getFieldName());
            }
        }
    }

    private static class MyConverter
    extends ExpressionConverter {
        final Set<String> attributeNames;

        public MyConverter(Set<String> attributeNames) {
            this.attributeNames = attributeNames;
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof IndexExpression;
        }

        protected Expression doConvert(Expression exp) {
            String indexName = ((IndexExpression)exp).getFieldName();
            if (this.attributeNames.contains(indexName)) {
                return null;
            }
            return new AttributeExpression(indexName);
        }
    }
}

