/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.expressiontransforms;

import com.yahoo.schema.FeatureNames;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;

public class InputRecorder
extends ExpressionTransformer<RankProfileTransformContext> {
    private final Set<String> neededInputs;

    public InputRecorder(Set<String> target) {
        this.neededInputs = target;
    }

    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof ReferenceNode) {
            ReferenceNode r = (ReferenceNode)node;
            this.handle(r, context);
            return node;
        }
        if (node instanceof CompositeNode) {
            CompositeNode c = (CompositeNode)node;
            return this.transformChildren(c, context);
        }
        if (node instanceof ConstantNode) {
            return node;
        }
        throw new IllegalArgumentException("Cannot handle node type: " + node + " [" + node.getClass() + "]");
    }

    private void handle(ReferenceNode feature, RankProfileTransformContext context) {
        Reference ref = feature.reference();
        String name = ref.name();
        Arguments args = ref.arguments();
        if (args.size() == 0) {
            RankProfile.RankingExpressionFunction f = context.rankProfile().getFunctions().get(name);
            if (f != null && f.function().arguments().size() == 0) {
                this.transform(f.function().getBody().getRoot(), context);
                return;
            }
            this.neededInputs.add(feature.toString());
            return;
        }
        if (args.size() == 1) {
            if (FeatureNames.isAttributeFeature(ref)) {
                this.neededInputs.add(feature.toString());
                return;
            }
            if (FeatureNames.isQueryFeature(ref)) {
                this.neededInputs.add(feature.toString());
                return;
            }
            if (FeatureNames.isConstantFeature(ref)) {
                Map<Reference, RankProfile.Constant> allConstants = context.rankProfile().constants();
                if (allConstants.containsKey(ref)) {
                    return;
                }
                throw new IllegalArgumentException("unknown constant: " + feature);
            }
        }
        if ("onnx".equals(name)) {
            if (args.size() != 1) {
                throw new IllegalArgumentException("expected name of ONNX model as argument: " + feature);
            }
            ExpressionNode arg = (ExpressionNode)args.expressions().get(0);
            Map<String, OnnxModel> models = context.rankProfile().onnxModels();
            OnnxModel model = models.get(arg.toString());
            if (model == null) {
                throw new IllegalArgumentException("missing onnx model: " + arg);
            }
            for (String onnxInput : model.getInputMap().values()) {
                StringReader reader = new StringReader(onnxInput);
                try {
                    RankingExpression asExpression = new RankingExpression((Reader)reader);
                    this.transform(asExpression.getRoot(), context);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("illegal onnx input '" + onnxInput + "': " + e.getMessage());
                }
            }
            return;
        }
        throw new IllegalArgumentException("cannot handle feature: " + feature);
    }
}

