/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.provision;

import com.yahoo.collections.ListMap;
import com.yahoo.collections.Pair;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.provision.Host;
import com.yahoo.config.model.provision.Hosts;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.IntRange;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.ProvisionLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;

public class InMemoryProvisioner
implements HostProvisioner {
    public static final NodeResources defaultHostResources = new NodeResources(1.0, 3.0, 50.0, 1.0);
    private final NodeResources defaultNodeResources;
    private final boolean failOnOutOfCapacity;
    private final Set<String> retiredHostNames;
    private final boolean sharedHosts;
    private final ListMap<NodeResources, Host> freeNodes = new ListMap();
    private final Map<ClusterSpec, List<HostSpec>> allocations = new LinkedHashMap<ClusterSpec, List<HostSpec>>();
    private final Map<Pair<ClusterSpec.Type, ClusterSpec.Id>, Integer> nextIndexInCluster = new HashMap<Pair<ClusterSpec.Type, ClusterSpec.Id>, Integer>();
    private final int startIndexForClusters;
    private final boolean useMaxResources;
    private final boolean alwaysReturnOneNode;
    private Provisioned provisioned = new Provisioned();
    private final Set<ClusterSpec> clusters = new TreeSet<ClusterSpec>(Comparator.comparing(cluster -> cluster.id().value()));
    private Environment environment = Environment.prod;

    public InMemoryProvisioner(int nodeCount, boolean sharedHosts) {
        this(nodeCount, defaultHostResources, sharedHosts);
    }

    public InMemoryProvisioner(int nodeCount, NodeResources resources, boolean sharedHosts) {
        this(Map.of(resources, InMemoryProvisioner.createHostInstances(nodeCount)), true, false, false, sharedHosts, NodeResources.unspecified(), 0, new String[0]);
    }

    public InMemoryProvisioner(int nodeCount, NodeResources resources, boolean sharedHosts, NodeResources defaultResources) {
        this(Map.of(resources, InMemoryProvisioner.createHostInstances(nodeCount)), true, false, false, sharedHosts, defaultResources, 0, new String[0]);
    }

    public InMemoryProvisioner(boolean failOnOutOfCapacity, boolean sharedHosts, String ... hosts) {
        this(Map.of(defaultHostResources, InMemoryProvisioner.toHostInstances(hosts)), failOnOutOfCapacity, false, false, sharedHosts, defaultHostResources, 0, new String[0]);
    }

    public InMemoryProvisioner(boolean failOnOutOfCapacity, boolean sharedHosts, List<String> hosts) {
        this(Map.of(defaultHostResources, InMemoryProvisioner.toHostInstances(hosts.toArray(new String[0]))), failOnOutOfCapacity, false, false, sharedHosts, defaultHostResources, 0, new String[0]);
    }

    public InMemoryProvisioner(Hosts hosts, boolean failOnOutOfCapacity, boolean sharedHosts, String ... retiredHostNames) {
        this(Map.of(defaultHostResources, hosts.asCollection()), failOnOutOfCapacity, false, false, sharedHosts, defaultHostResources, 0, retiredHostNames);
    }

    public InMemoryProvisioner(Hosts hosts, boolean failOnOutOfCapacity, boolean sharedHosts, int startIndexForClusters, String ... retiredHostNames) {
        this(Map.of(defaultHostResources, hosts.asCollection()), failOnOutOfCapacity, false, false, sharedHosts, defaultHostResources, startIndexForClusters, retiredHostNames);
    }

    public InMemoryProvisioner(Map<NodeResources, Collection<Host>> hosts, boolean failOnOutOfCapacity, boolean useMaxResources, boolean alwaysReturnOneNode, boolean sharedHosts, NodeResources defaultResources, int startIndexForClusters, String ... retiredHostNames) {
        this.defaultNodeResources = defaultResources;
        this.failOnOutOfCapacity = failOnOutOfCapacity;
        this.useMaxResources = useMaxResources;
        this.alwaysReturnOneNode = alwaysReturnOneNode;
        for (Map.Entry<NodeResources, Collection<Host>> hostsWithResources : hosts.entrySet()) {
            for (Host host : hostsWithResources.getValue()) {
                this.freeNodes.put((Object)hostsWithResources.getKey(), (Object)host);
            }
        }
        this.sharedHosts = sharedHosts;
        this.startIndexForClusters = startIndexForClusters;
        this.retiredHostNames = Set.of(retiredHostNames);
    }

    public InMemoryProvisioner setEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    private static Collection<Host> toHostInstances(String[] hostnames) {
        return Arrays.stream(hostnames).map(Host::new).toList();
    }

    private static Collection<Host> createHostInstances(int hostCount) {
        return IntStream.range(1, hostCount + 1).mapToObj(i -> new Host("host" + i)).toList();
    }

    public Map<ClusterSpec, List<HostSpec>> allocations() {
        return this.allocations;
    }

    public HostSpec allocateHost(String alias) {
        List defaultHosts = this.freeNodes.get((Object)defaultHostResources);
        if (defaultHosts.isEmpty()) {
            throw new IllegalArgumentException("No more hosts with default resources available");
        }
        Host newHost = (Host)this.freeNodes.removeValue((Object)defaultHostResources, 0);
        return new HostSpec(newHost.hostname(), Optional.empty());
    }

    public List<HostSpec> prepare(ClusterSpec cluster, Capacity requested, ProvisionLogger logger) {
        this.provisioned.add(cluster.id(), requested);
        this.clusters.add(cluster);
        if (this.environment == Environment.dev) {
            requested = requested.withLimits(requested.minResources().withNodes(1), requested.maxResources().withNodes(1));
        }
        IntRange groupRange = IntRange.of((int)requested.minResources().groups(), (int)requested.maxResources().groups());
        if (this.useMaxResources) {
            int groups = groupRange.fit(requested.maxResources().nodes() / requested.groupSize().to().orElse(1));
            return this.prepare(cluster, requested.maxResources(), groups, requested.isRequired(), requested.canFail());
        }
        int groups = groupRange.fit(requested.minResources().nodes() / requested.groupSize().from().orElse(1));
        return this.prepare(cluster, requested.minResources(), groups, requested.isRequired(), requested.canFail());
    }

    public List<HostSpec> prepare(ClusterSpec cluster, ClusterResources requested, int groups, boolean required, boolean canFail) {
        int nodes;
        if (cluster.group().isPresent() && requested.groups() > 1) {
            throw new IllegalArgumentException("Cannot both be specifying a group and ask for groups to be created");
        }
        int n = nodes = this.failOnOutOfCapacity || required ? requested.nodes() : Math.min(requested.nodes(), this.freeNodes.get((Object)defaultHostResources).size() + this.totalAllocatedTo(cluster));
        if (this.alwaysReturnOneNode) {
            nodes = 1;
        }
        groups = Math.min(groups, nodes);
        ArrayList<HostSpec> allocation = new ArrayList<HostSpec>();
        if (groups == 1) {
            allocation.addAll(this.allocateHostGroup(cluster.with(Optional.of(ClusterSpec.Group.from((int)0))), requested.nodeResources(), nodes, this.startIndexForClusters, canFail));
        } else {
            for (int i = 0; i < groups; ++i) {
                allocation.addAll(this.allocateHostGroup(cluster.with(Optional.of(ClusterSpec.Group.from((int)i))), requested.nodeResources(), nodes / groups, allocation.size(), canFail));
            }
        }
        ListIterator<HostSpec> i = allocation.listIterator();
        while (i.hasNext()) {
            HostSpec host = (HostSpec)i.next();
            if (!this.retiredHostNames.contains(host.hostname())) continue;
            i.set(this.retire(host));
        }
        return allocation;
    }

    public Provisioned startProvisionedRecording() {
        this.provisioned = new Provisioned();
        this.clusters.clear();
        return this.provisioned;
    }

    private HostSpec retire(HostSpec host) {
        return new HostSpec(host.hostname(), host.realResources(), host.advertisedResources(), host.requestedResources().orElse(NodeResources.unspecified()), ((ClusterMembership)host.membership().get()).retire(), host.version(), Optional.empty(), host.dockerImageRepo());
    }

    private NodeResources decideResources(NodeResources requestedResources) {
        if (requestedResources.isUnspecified()) {
            return this.defaultNodeResources;
        }
        return requestedResources;
    }

    private List<HostSpec> allocateHostGroup(ClusterSpec clusterGroup, NodeResources requestedResourcesOrUnspecified, int nodesInGroup, int startIndex, boolean canFail) {
        NodeResources requestedResources = this.decideResources(requestedResourcesOrUnspecified);
        List allocation = this.allocations.getOrDefault(clusterGroup, new ArrayList());
        this.allocations.put(clusterGroup, allocation);
        for (int i = allocation.size() - 1; i >= 0; --i) {
            NodeResources currentResources = ((HostSpec)allocation.get(0)).advertisedResources();
            if (currentResources.isUnspecified() || requestedResources.isUnspecified() || (this.sharedHosts || currentResources.satisfies(requestedResources)) && (!this.sharedHosts || currentResources.compatibleWith(requestedResources))) continue;
            HostSpec removed = (HostSpec)allocation.remove(i);
            this.freeNodes.put((Object)currentResources, (Object)new Host(removed.hostname()));
        }
        int nextIndex = this.nextIndexInCluster.getOrDefault(new Pair((Object)clusterGroup.type(), (Object)clusterGroup.id()), startIndex);
        while (this.nonRetiredIn(allocation).size() < nodesInGroup) {
            Optional<NodeResources> hostResources = this.freeNodes.keySet().stream().sorted(new MemoryDiskCpu()).filter(resources -> requestedResources.isUnspecified() || resources.satisfies(requestedResources)).findFirst();
            if (hostResources.isEmpty()) {
                if (!canFail) break;
                throw new IllegalArgumentException("Insufficient capacity for " + requestedResources + " in cluster " + clusterGroup);
            }
            Host newHost = (Host)this.freeNodes.removeValue((Object)hostResources.get(), 0);
            if (this.freeNodes.get((Object)hostResources.get()).isEmpty()) {
                this.freeNodes.removeAll((Object)hostResources.get());
            }
            ClusterMembership membership = ClusterMembership.from((ClusterSpec)clusterGroup, (int)nextIndex++);
            NodeResources resources2 = this.sharedHosts ? requestedResources : hostResources.get();
            allocation.add(new HostSpec(newHost.hostname(), resources2, resources2, requestedResources, membership, newHost.version(), Optional.empty(), Optional.empty()));
        }
        this.nextIndexInCluster.put((Pair<ClusterSpec.Type, ClusterSpec.Id>)new Pair((Object)clusterGroup.type(), (Object)clusterGroup.id()), nextIndex);
        while (this.nonRetiredIn(allocation).size() > nodesInGroup) {
            allocation.remove(0);
        }
        return allocation;
    }

    private List<HostSpec> nonRetiredIn(List<HostSpec> hosts) {
        return hosts.stream().filter(host -> !this.retiredHostNames.contains(host.hostname())).toList();
    }

    private int totalAllocatedTo(ClusterSpec cluster) {
        int count = 0;
        for (Map.Entry<ClusterSpec, List<HostSpec>> allocation : this.allocations.entrySet()) {
            if (!allocation.getKey().type().equals((Object)cluster.type()) || !allocation.getKey().id().equals((Object)cluster.id())) continue;
            count += allocation.getValue().size();
        }
        return count;
    }

    public Set<ClusterSpec> provisionedClusters() {
        return this.clusters;
    }

    private static class MemoryDiskCpu
    implements Comparator<NodeResources> {
        private MemoryDiskCpu() {
        }

        @Override
        public int compare(NodeResources a, NodeResources b) {
            if (a.memoryGb() > b.memoryGb()) {
                return 1;
            }
            if (a.memoryGb() < b.memoryGb()) {
                return -1;
            }
            if (a.diskGb() > b.diskGb()) {
                return 1;
            }
            if (a.diskGb() < b.diskGb()) {
                return -1;
            }
            if (a.vcpu() > b.vcpu()) {
                return 1;
            }
            if (a.vcpu() < b.vcpu()) {
                return -1;
            }
            return 0;
        }
    }
}

