/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.vespa.config.content.core.StorCommunicationmanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.config.content.core.StorStatusConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.application.validation.RestartConfigs;

@RestartConfigs(value={StorCommunicationmanagerConfig.class, StorStatusConfig.class, StorServerConfig.class, MetricsmanagerConfig.class})
public abstract class ContentNode
extends AbstractService
implements StorCommunicationmanagerConfig.Producer,
StorStatusConfig.Producer,
StorServerConfig.Producer {
    private final int distributionKey;
    private final String rootDirectory;
    private final boolean dispatch_on_encode;
    private final boolean dispatch_on_decode;
    private final int mbus_threads;
    private final int mbus_network_threads;

    public ContentNode(ModelContext.FeatureFlags featureFlags, AbstractConfigProducer<?> parent, String clusterName, String rootDirectory, int distributionKey) {
        super(parent, "" + distributionKey);
        this.distributionKey = distributionKey;
        this.rootDirectory = rootDirectory;
        this.dispatch_on_decode = featureFlags.mbusDispatchOnDecode();
        this.dispatch_on_encode = featureFlags.mbusDispatchOnEncode();
        this.mbus_threads = featureFlags.mbusThreads();
        this.mbus_network_threads = featureFlags.mbusNetworkThreads();
        this.initialize();
        this.setProp("clustertype", "content");
        this.setProp("clustername", clusterName);
        this.setProp("index", distributionKey);
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    public void getConfig(StorServerConfig.Builder builder) {
        builder.root_folder(this.rootDirectory);
        builder.node_index(this.distributionKey);
    }

    private void initialize() {
        this.portsMeta.on(0).tag("messaging");
        this.portsMeta.on(1).tag("rpc").tag("status");
        this.portsMeta.on(2).tag("http").tag("status").tag("state");
    }

    @Override
    public int getPortCount() {
        return 3;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        if (start == 0) {
            from.allocatePort("messaging");
            from.allocatePort("rpc");
            from.allocatePort("http");
        } else {
            from.wantPort(start++, "messaging");
            from.wantPort(start++, "rpc");
            from.wantPort(start++, "http");
        }
    }

    public void getConfig(StorCommunicationmanagerConfig.Builder builder) {
        builder.mbusport(this.getRelativePort(0));
        builder.rpcport(this.getRelativePort(1));
        builder.mbus.dispatch_on_decode(this.dispatch_on_decode);
        builder.mbus.dispatch_on_encode(this.dispatch_on_encode);
        builder.mbus.num_threads(this.mbus_threads);
        builder.mbus.num_network_threads(this.mbus_network_threads);
    }

    public void getConfig(StorStatusConfig.Builder builder) {
        builder.httpport(this.getRelativePort(2));
    }

    @Override
    public int getHealthPort() {
        return this.getRelativePort(2);
    }
}

