/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml.embedder;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.container.xml.embedder.EmbedderConfig;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class EmbedderOption {
    public static final OptionTransformer defaultOptionTransformer = new OptionTransformer();
    private final String name;
    private final boolean required;
    private final String value;
    private final Map<String, String> attributes;
    private final OptionTransformer optionTransformer;
    private final boolean set;

    private EmbedderOption(Builder builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.value = builder.value;
        this.attributes = builder.attributes;
        this.optionTransformer = builder.optionTransformer;
        this.set = builder.set;
    }

    public void toElement(DeployState deployState, Element parent) {
        this.optionTransformer.transform(deployState, parent, this);
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean required() {
        return this.required;
    }

    public OptionTransformer optionTransformer() {
        return this.optionTransformer;
    }

    public boolean isSet() {
        return this.set;
    }

    public static class Builder {
        private String name = "";
        private boolean required = false;
        private String value = "";
        private Map<String, String> attributes = Map.of();
        private OptionTransformer optionTransformer = defaultOptionTransformer;
        private boolean set = false;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.set = true;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder attributes(Element element) {
            NamedNodeMap map = element.getAttributes();
            if (map.getLength() > 0) {
                this.attributes = new HashMap<String, String>(map.getLength());
                for (int i = 0; i < map.getLength(); ++i) {
                    String attr = map.item(i).getNodeName();
                    this.attributes.put(attr, element.getAttribute(attr));
                }
            }
            return this;
        }

        public Builder optionTransformer(OptionTransformer optionTransformer) {
            this.optionTransformer = optionTransformer;
            return this;
        }

        public EmbedderOption build() {
            return new EmbedderOption(this);
        }
    }

    public static class OptionTransformer {
        public void transform(DeployState deployState, Element parent, EmbedderOption option) {
            OptionTransformer.createElement(parent, option.name(), option.value());
        }

        public static Element createElement(Element parent, String name, String value) {
            Element element = parent.getOwnerDocument().createElement(name);
            element.setTextContent(value);
            parent.appendChild(element);
            return element;
        }
    }

    public static class ModelOptionTransformer
    extends OptionTransformer {
        private final String pathField;
        private final String urlField;

        public ModelOptionTransformer(String pathField, String urlField) {
            this.pathField = pathField;
            this.urlField = urlField;
        }

        @Override
        public void transform(DeployState deployState, Element parent, EmbedderOption option) {
            String id = option.attributes.get("id");
            String url = option.attributes.get("url");
            String path = option.attributes.get("path");
            if (path != null && path.length() > 0) {
                ModelOptionTransformer.createElement(parent, this.pathField, path);
                ModelOptionTransformer.createElement(parent, this.urlField, "");
                return;
            }
            if (deployState.isHosted() && id != null && id.length() > 0) {
                ModelOptionTransformer.createElement(parent, this.urlField, EmbedderConfig.modelIdToUrl(id));
                ModelOptionTransformer.createElement(parent, this.pathField, this.createDummyPath(deployState));
                return;
            }
            if (url != null && url.length() > 0) {
                ModelOptionTransformer.createElement(parent, this.urlField, url);
                ModelOptionTransformer.createElement(parent, this.pathField, this.createDummyPath(deployState));
                return;
            }
            if (!deployState.isHosted() && id != null && id.length() > 0) {
                throw new IllegalArgumentException("Model option 'id' is not valid here");
            }
            throw new IllegalArgumentException("Model option requires either a 'path' or a 'url' attribute");
        }

        private String createDummyPath(DeployState deployState) {
            return "services.xml";
        }
    }
}

