/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml.embedder;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.xml.embedder.EmbedderOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmbedderConfigTransformer {
    private final Document doc = XML.getDocumentBuilder().newDocument();
    private final String id;
    private final String className;
    private final String bundle;
    private final String def;
    private final Map<String, EmbedderOption> options = new HashMap<String, EmbedderOption>();

    public EmbedderConfigTransformer(Element spec, boolean hosted) {
        this(spec, hosted, null, null);
    }

    public EmbedderConfigTransformer(Element spec, boolean hosted, String defaultBundle, String defaultDef) {
        this.id = spec.getAttribute("id");
        this.className = spec.hasAttribute("class") ? spec.getAttribute("class") : this.id;
        this.bundle = spec.hasAttribute("bundle") ? spec.getAttribute("bundle") : defaultBundle;
        String string = this.def = spec.hasAttribute("def") ? spec.getAttribute("def") : defaultDef;
        if (this.className == null || this.className.length() == 0) {
            throw new IllegalArgumentException("Embedder class is empty");
        }
        if (this.bundle == null || this.bundle.length() == 0) {
            throw new IllegalArgumentException("Embedder configuration requires a bundle name");
        }
        if (this.def == null || this.def.length() == 0) {
            throw new IllegalArgumentException("Embedder configuration requires a config definition name");
        }
    }

    Element createComponentConfig(DeployState deployState) {
        this.checkRequiredOptions();
        Element component = this.doc.createElement("component");
        component.setAttribute("id", this.id);
        component.setAttribute("class", this.className);
        component.setAttribute("bundle", this.bundle);
        if (this.options.size() > 0) {
            Element config = this.doc.createElement("config");
            config.setAttribute("name", this.def);
            for (Map.Entry<String, EmbedderOption> entry : this.options.entrySet()) {
                entry.getValue().toElement(deployState, config);
            }
            component.appendChild(config);
        }
        return component;
    }

    void addOption(Element elem) {
        String name = elem.getTagName();
        EmbedderOption.Builder builder = new EmbedderOption.Builder();
        builder.name(name);
        builder.value(elem.getTextContent());
        builder.attributes(elem);
        if (this.options.containsKey(name)) {
            builder.required(this.options.get(name).required());
            builder.optionTransformer(this.options.get(name).optionTransformer());
        }
        this.options.put(name, builder.build());
    }

    void addOption(EmbedderOption option) {
        this.options.put(option.name(), option);
    }

    private void checkRequiredOptions() {
        ArrayList<String> missingOptions = new ArrayList<String>();
        for (EmbedderOption option : this.options.values()) {
            if (option.isSet()) continue;
            missingOptions.add(option.name());
        }
        if (missingOptions.size() > 0) {
            throw new IllegalArgumentException("Embedder '" + this.className + "' requires options for " + missingOptions);
        }
    }
}

