/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.docproc;

import com.yahoo.component.ComponentId;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.jdisc.config.SessionConfig;
import com.yahoo.docproc.jdisc.observability.DocprocsStatusExtension;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.chain.Chains;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.container.docproc.MbusClient;

public class DocprocChains
extends Chains<DocprocChain> {
    public static final String DOCUMENT_TYPE_MANAGER_CLASS = "com.yahoo.document.DocumentTypeManager";
    private final ProcessingHandler<DocprocChains> docprocHandler = new ProcessingHandler<DocprocChains>(this, "com.yahoo.docproc.jdisc.DocumentProcessingHandler");

    public DocprocChains(AbstractConfigProducer<?> parent, String subId) {
        super(parent, subId);
        this.addComponent(this.docprocHandler);
        this.addComponent(new SimpleComponent(new ComponentModel(BundleInstantiationSpecification.getInternalProcessingSpecificationFromStrings((String)DocprocsStatusExtension.class.getName(), null), null)));
        if (!(this.getParent() instanceof ApplicationContainerCluster)) {
            this.addComponent(new SimpleComponent(DOCUMENT_TYPE_MANAGER_CLASS));
        }
    }

    private void addComponent(Component<?, ?> component) {
        if (!(this.getParent() instanceof ContainerCluster)) {
            return;
        }
        ((ContainerCluster)this.getParent()).addComponent(component);
    }

    public void addServersAndClientsForChains() {
        if (this.getParent() instanceof ApplicationContainerCluster) {
            for (DocprocChain chain : this.getChainGroup().getComponents()) {
                this.addServerAndClientForChain((ApplicationContainerCluster)this.getParent(), chain);
            }
        }
    }

    private void addServerAndClientForChain(ApplicationContainerCluster cluster, DocprocChain docprocChain) {
        this.docprocHandler.addServerBindings(SystemBindingPattern.fromPattern("mbus://*/" + docprocChain.getSessionName()));
        cluster.addMbusServer(ComponentId.fromString((String)docprocChain.getSessionName()));
        MbusClient client = new MbusClient(docprocChain.getSessionName(), SessionConfig.Type.INTERMEDIATE);
        client.addClientBindings(SystemBindingPattern.fromPattern("mbus://*/" + client.getSessionName()));
        this.addComponent(client);
    }
}

