/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.Optional;

public final class ApplicationContainer
extends Container
implements QrStartConfig.Producer,
ZookeeperServerConfig.Producer {
    private static final String defaultHostedJVMArgs = "-XX:+SuppressFatalErrorMessage";
    private final boolean isHostedVespa;
    private final boolean enableServerOcspStapling;

    public ApplicationContainer(AbstractConfigProducer<?> parent, String name, int index, DeployState deployState) {
        this(parent, name, false, index, deployState);
    }

    public ApplicationContainer(AbstractConfigProducer<?> parent, String name, boolean retired, int index, DeployState deployState) {
        super(parent, name, retired, index, deployState);
        this.isHostedVespa = deployState.isHosted();
        this.enableServerOcspStapling = deployState.featureFlags().enableServerOcspStapling();
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.NetworkMultiplexerHolder"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.NetworkMultiplexerProvider"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.messagebus.SessionCache"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.SystemInfoProvider"));
        this.addComponent(new SimpleComponent("com.yahoo.container.jdisc.ZoneInfoProvider"));
    }

    public void getConfig(QrStartConfig.Builder builder) {
        NodeResources nodeResources;
        if (this.getHostResource() != null && !(nodeResources = this.getHostResource().realResources()).isUnspecified()) {
            builder.jvm.availableProcessors(Math.max(2, (int)Math.ceil(nodeResources.vcpu())));
        }
    }

    @Override
    protected ContainerServiceType myServiceType() {
        return ContainerServiceType.CONTAINER;
    }

    @Override
    public String getJvmOptions() {
        String jvmArgs;
        StringBuilder b = new StringBuilder();
        if (this.isHostedVespa) {
            if (this.hasDocproc()) {
                b.append(defaultHostedJVMArgs).append(' ');
            }
            if (this.enableServerOcspStapling) {
                b.append("-Djdk.tls.server.enableStatusRequestExtension=true ").append("-Djdk.tls.stapling.responseTimeout=2000 ").append("-Djdk.tls.stapling.cacheSize=256 ").append("-Djdk.tls.stapling.cacheLifetime=3600 ");
            }
        }
        if (!(jvmArgs = super.getJvmOptions()).isBlank()) {
            b.append(jvmArgs.trim());
        }
        return b.toString().trim();
    }

    private boolean hasDocproc() {
        return this.parent instanceof ContainerCluster && ((ContainerCluster)this.parent).getDocproc() != null;
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        builder.myid(this.index());
    }

    @Override
    protected String jvmOmitStackTraceInFastThrowOption(ModelContext.FeatureFlags featureFlags) {
        return featureFlags.jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type.container);
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        int preshutdownTimeoutSeconds = 360;
        int rpcTimeoutSeconds = preshutdownTimeoutSeconds + 10;
        String rpcParams = "-t " + rpcTimeoutSeconds + " tcp/localhost:" + this.getRpcPort() + " prepareStop d:" + preshutdownTimeoutSeconds;
        return Optional.of(Defaults.getDefaults().underVespaHome("bin/vespa-rpc-invoke") + " " + rpcParams);
    }
}

