/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.UserBindingPattern;
import java.util.Collection;
import java.util.Collections;

public class ContainerDocumentApi {
    public static final String DOCUMENT_V1_PREFIX = "/document/v1";

    public ContainerDocumentApi(ContainerCluster<?> cluster, Options options) {
        ContainerDocumentApi.addRestApiHandler(cluster, options);
        ContainerDocumentApi.addFeedHandler(cluster, options);
    }

    private static void addFeedHandler(ContainerCluster<?> cluster, Options options) {
        String bindingSuffix = "/reserved-for-internal-use/feedapi";
        Handler<AbstractConfigProducer<?>> handler = ContainerDocumentApi.newVespaClientHandler("com.yahoo.vespa.http.server.FeedHandler", bindingSuffix, options);
        cluster.addComponent(handler);
        Threadpool executor = new Threadpool("feedapi-handler", cluster, options.feedApiThreadpoolOptions);
        handler.inject(executor);
        handler.addComponent(executor);
    }

    private static void addRestApiHandler(ContainerCluster<?> cluster, Options options) {
        Handler<AbstractConfigProducer<?>> handler = ContainerDocumentApi.newVespaClientHandler("com.yahoo.document.restapi.resource.DocumentV1ApiHandler", "/document/v1/*", options);
        cluster.addComponent(handler);
        Handler<AbstractConfigProducer<?>> oldHandlerDummy = ContainerDocumentApi.handlerComponentSpecification("com.yahoo.document.restapi.resource.RestApi");
        cluster.addComponent(oldHandlerDummy);
    }

    private static Handler<AbstractConfigProducer<?>> newVespaClientHandler(String componentId, String bindingSuffix, Options options) {
        Handler<AbstractConfigProducer<?>> handler = ContainerDocumentApi.handlerComponentSpecification(componentId);
        if (options.bindings.isEmpty()) {
            handler.addServerBindings(SystemBindingPattern.fromHttpPath(bindingSuffix), SystemBindingPattern.fromHttpPath(bindingSuffix + "/"));
        } else {
            for (String rootBinding : options.bindings) {
                String pathWithoutLeadingSlash = bindingSuffix.substring(1);
                handler.addServerBindings(UserBindingPattern.fromPattern(rootBinding + pathWithoutLeadingSlash), UserBindingPattern.fromPattern(rootBinding + pathWithoutLeadingSlash + "/"));
            }
        }
        return handler;
    }

    private static Handler<AbstractConfigProducer<?>> handlerComponentSpecification(String className) {
        return new Handler(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)className, null, (String)"vespaclient-container-plugin"), ""));
    }

    public static final class Options {
        private final Collection<String> bindings;
        private final ContainerThreadpool.UserOptions feedApiThreadpoolOptions;

        public Options(Collection<String> bindings, ContainerThreadpool.UserOptions feedApiThreadpoolOptions) {
            this.bindings = Collections.unmodifiableCollection(bindings);
            this.feedApiThreadpoolOptions = feedApiThreadpoolOptions;
        }
    }

    private static class Threadpool
    extends ContainerThreadpool {
        private final ContainerCluster<?> cluster;

        Threadpool(String name, ContainerCluster<?> cluster, ContainerThreadpool.UserOptions threadpoolOptions) {
            super(name, threadpoolOptions);
            this.cluster = cluster;
        }

        @Override
        public void getConfig(ContainerThreadpoolConfig.Builder builder) {
            super.getConfig(builder);
            if (this.hasUserOptions()) {
                return;
            }
            builder.maxThreads(-4).minThreads(-4).queueSize(500);
        }
    }
}

