/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class NodeResourceChangeValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, ValidationOverrides overrides, Instant now) {
        ArrayList<ConfigChangeAction> restartActions = new ArrayList<ConfigChangeAction>();
        for (ClusterSpec.Id clusterId : current.allClusters()) {
            Optional<NodeResources> currentResources = this.resourcesOf(clusterId, current);
            Optional<NodeResources> nextResources = this.resourcesOf(clusterId, next);
            if (currentResources.isEmpty() || nextResources.isEmpty() || !this.changeRequiresRestart(currentResources.get(), nextResources.get())) continue;
            restartActions.addAll(this.createRestartActionsFor(clusterId, current));
        }
        return restartActions;
    }

    private boolean changeRequiresRestart(NodeResources currentResources, NodeResources nextResources) {
        return currentResources.memoryGb() != nextResources.memoryGb();
    }

    private Optional<NodeResources> resourcesOf(ClusterSpec.Id clusterId, VespaModel model) {
        return model.allocatedHosts().getHosts().stream().filter(host -> host.membership().isPresent()).filter(host -> ((ClusterMembership)host.membership().get()).cluster().id().equals((Object)clusterId)).findFirst().map(host -> host.advertisedResources());
    }

    private List<ConfigChangeAction> createRestartActionsFor(ClusterSpec.Id clusterId, VespaModel model) {
        ApplicationContainerCluster containerCluster = model.getContainerClusters().get(clusterId.value());
        if (containerCluster != null) {
            return this.createRestartActionsFor(containerCluster);
        }
        ContentCluster contentCluster = model.getContentClusters().get(clusterId.value());
        if (contentCluster != null) {
            return this.createRestartActionsFor(contentCluster);
        }
        return List.of();
    }

    private List<ConfigChangeAction> createRestartActionsFor(ApplicationContainerCluster cluster) {
        return cluster.getContainers().stream().map(container -> new VespaRestartAction(cluster.id(), "Node resource change", container.getServiceInfo(), false)).collect(Collectors.toList());
    }

    private List<ConfigChangeAction> createRestartActionsFor(ContentCluster cluster) {
        return cluster.getSearch().getSearchNodes().stream().map(node -> new VespaRestartAction(cluster.id(), "Node resource change", node.getServiceInfo(), false)).collect(Collectors.toList());
    }
}

