/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import com.yahoo.collections.Pair;
import com.yahoo.component.Version;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.codegen.ConfiggenUtil;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.ConfigModelRegistry;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.NullConfigModelRegistry;
import com.yahoo.config.model.api.ApplicationClusterInfo;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.container.QrConfig;
import com.yahoo.path.Path;
import com.yahoo.schema.LargeRankExpressions;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.derived.AttributeFields;
import com.yahoo.schema.derived.RankProfileList;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processing;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.config.GenericConfig;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.model.ConfigProducer;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.InstanceResolver;
import com.yahoo.vespa.model.VespaConfigModelRegistry;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.builder.VespaModelBuilder;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import com.yahoo.vespa.model.filedistribution.FileReferencesRepository;
import com.yahoo.vespa.model.ml.ConvertedModel;
import com.yahoo.vespa.model.ml.ModelName;
import com.yahoo.vespa.model.ml.OnnxModelInfo;
import com.yahoo.vespa.model.routing.Routing;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.utils.internal.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.xml.sax.SAXException;

public final class VespaModel
extends AbstractConfigProducerRoot
implements Serializable,
Model {
    private static final long serialVersionUID = 1L;
    public static final Logger log = Logger.getLogger(VespaModel.class.getName());
    private final Version version;
    private final Version wantedNodeVersion;
    private final ConfigModelRepo configModelRepo = new ConfigModelRepo();
    private final AllocatedHosts allocatedHosts;
    public static final String ROOT_CONFIGID = "";
    private final ApplicationConfigProducerRoot root;
    private final ApplicationPackage applicationPackage;
    private final RankProfileList rankProfileList;
    private final ValidationOverrides validationOverrides;
    private final FileReferencesRepository fileReferencesRepository;
    private final Provisioned provisioned;

    public VespaModel(ApplicationPackage app) throws IOException, SAXException {
        this(app, new NullConfigModelRegistry());
    }

    public VespaModel(DeployState deployState) throws IOException, SAXException {
        this(new NullConfigModelRegistry(), deployState);
    }

    public VespaModel(ApplicationPackage app, ConfigModelRegistry configModelRegistry) throws IOException, SAXException {
        this(configModelRegistry, new DeployState.Builder().applicationPackage(app).build());
    }

    public VespaModel(ConfigModelRegistry configModelRegistry, DeployState deployState) throws IOException, SAXException {
        this(configModelRegistry, deployState, true);
    }

    private VespaModel(ConfigModelRegistry configModelRegistry, DeployState deployState, boolean complete) throws IOException, SAXException {
        super("vespamodel");
        this.version = deployState.getVespaVersion();
        this.wantedNodeVersion = deployState.getWantedNodeVespaVersion();
        this.fileReferencesRepository = new FileReferencesRepository(deployState.getFileRegistry());
        this.validationOverrides = deployState.validationOverrides();
        this.applicationPackage = deployState.getApplicationPackage();
        this.provisioned = deployState.provisioned();
        VespaDomBuilder builder = new VespaDomBuilder();
        this.root = ((VespaModelBuilder)builder).getRoot(ROOT_CONFIGID, deployState, this);
        this.createGlobalRankProfiles(deployState);
        this.rankProfileList = new RankProfileList(null, new LargeRankExpressions(deployState.getFileRegistry()), AttributeFields.empty, deployState);
        HostSystem hostSystem = this.root.hostSystem();
        if (complete) {
            this.root.useFeatureFlags(deployState.getProperties().featureFlags());
            this.configModelRepo.readConfigModels(deployState, this, builder, this.root, (ConfigModelRegistry)new VespaConfigModelRegistry(configModelRegistry));
            this.setupRouting(deployState);
            this.getAdmin().addPerHostServices(hostSystem.getHosts(), deployState);
            this.freezeModelTopology();
            this.root.prepare(this.configModelRepo);
            this.configModelRepo.prepareConfigModels(deployState);
            this.validateWrapExceptions();
            hostSystem.dumpPortAllocations();
            this.propagateRestartOnDeploy();
        }
        this.allocatedHosts = AllocatedHosts.withHosts(hostSystem.getHostSpecs());
    }

    public Map<String, Set<String>> documentTypesByCluster() {
        return this.getContentClusters().entrySet().stream().collect(Collectors.toMap(cluster -> (String)cluster.getKey(), cluster -> ((ContentCluster)cluster.getValue()).getDocumentDefinitions().keySet()));
    }

    public Map<String, Set<String>> indexedDocumentTypesByCluster() {
        return this.getContentClusters().entrySet().stream().collect(Collectors.toUnmodifiableMap(cluster -> (String)cluster.getKey(), cluster -> VespaModel.documentTypesWithIndex((ContentCluster)cluster.getValue())));
    }

    private static Set<String> documentTypesWithIndex(ContentCluster content) {
        Set typesWithIndexMode = content.getSearch().getDocumentTypesWithIndexedCluster().stream().map(type -> type.getFullName().getName()).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        Set typesWithIndexedFields = content.getSearch().getIndexed() == null ? Set.of() : (Set)content.getSearch().getIndexed().getDocumentDbs().stream().filter(database -> database.getDerivedConfiguration().getSchema().allConcreteFields().stream().anyMatch(SDField::doesIndexing)).map(database -> database.getSchemaName()).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        return typesWithIndexMode.stream().filter(typesWithIndexedFields::contains).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    private void propagateRestartOnDeploy() {
        if (this.applicationPackage.getMetaData().isInternalRedeploy()) {
            return;
        }
        for (ApplicationContainerCluster containerCluster : this.getContainerClusters().values()) {
            QrConfig config = this.getConfig(QrConfig.class, containerCluster.getConfigId());
            if (!config.restartOnDeploy()) continue;
            containerCluster.setDeferChangesUntilRestart(true);
        }
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public static VespaModel createIncomplete(DeployState deployState) throws IOException, SAXException {
        return new VespaModel(new NullConfigModelRegistry(), deployState, false);
    }

    private void validateWrapExceptions() {
        try {
            this.validate();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while validating model:", e);
        }
    }

    private void createGlobalRankProfiles(DeployState deployState) {
        Collection importedModels = deployState.getImportedModels().all();
        DeployLogger deployLogger = deployState.getDeployLogger();
        RankProfileRegistry rankProfileRegistry = deployState.rankProfileRegistry();
        QueryProfiles queryProfiles = deployState.getQueryProfiles();
        ArrayList<Future<ConvertedModel>> futureModels = new ArrayList<Future<ConvertedModel>>();
        if (!importedModels.isEmpty()) {
            for (ImportedMlModel importedMlModel : importedModels) {
                RankProfile profile = new RankProfile(importedMlModel.name(), this.applicationPackage, deployLogger, rankProfileRegistry);
                this.addOnnxModelInfoFromSource(importedMlModel, profile);
                rankProfileRegistry.add(profile);
                futureModels.add(deployState.getExecutor().submit(() -> {
                    ConvertedModel convertedModel = ConvertedModel.fromSource(this.applicationPackage, new ModelName(model.name()), model.name(), profile, queryProfiles.getRegistry(), model);
                    convertedModel.expressions().values().forEach(f -> profile.addFunction((ExpressionFunction)f, false));
                    return convertedModel;
                }));
            }
        } else {
            ApplicationFile generatedModelsDir = this.applicationPackage.getFile(ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR);
            for (ApplicationFile generatedModelDir : generatedModelsDir.listFiles()) {
                String modelName = generatedModelDir.getPath().last();
                if (modelName.contains(".")) continue;
                RankProfile profile = new RankProfile(modelName, this.applicationPackage, deployLogger, rankProfileRegistry);
                this.addOnnxModelInfoFromStore(modelName, profile);
                rankProfileRegistry.add(profile);
                futureModels.add(deployState.getExecutor().submit(() -> {
                    ConvertedModel convertedModel = ConvertedModel.fromStore(this.applicationPackage, new ModelName(modelName), modelName, profile);
                    convertedModel.expressions().values().forEach(f -> profile.addFunction((ExpressionFunction)f, false));
                    return convertedModel;
                }));
            }
        }
        for (Future future : futureModels) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        new Processing().processRankProfiles(deployLogger, rankProfileRegistry, queryProfiles, true, false);
    }

    private void addOnnxModelInfoFromSource(ImportedMlModel model, RankProfile profile) {
        if (model.modelType() == ImportedMlModel.ModelType.ONNX) {
            String applicationPath;
            String path = model.source();
            if (path.startsWith(applicationPath = this.applicationPackage.getFileReference(Path.fromString((String)ROOT_CONFIGID)).toString())) {
                path = path.substring(applicationPath.length() + 1);
            }
            this.addOnnxModelInfo(model.name(), path, profile);
        }
    }

    private void addOnnxModelInfoFromStore(String modelName, RankProfile profile) {
        String path = ApplicationPackage.MODELS_DIR.append(modelName + ".onnx").toString();
        this.addOnnxModelInfo(modelName, path, profile);
    }

    private void addOnnxModelInfo(String name, String path, RankProfile profile) {
        OnnxModelInfo onnxModelInfo;
        boolean modelExists = OnnxModelInfo.modelExists(path, this.applicationPackage);
        if (!modelExists) {
            path = ApplicationPackage.MODELS_DIR.append(path).toString();
            modelExists = OnnxModelInfo.modelExists(path, this.applicationPackage);
        }
        if (modelExists && (onnxModelInfo = OnnxModelInfo.load(path, this.applicationPackage)).getModelPath() != null) {
            OnnxModel onnxModel = new OnnxModel(name, onnxModelInfo.getModelPath());
            onnxModel.setModelInfo(onnxModelInfo);
            profile.add(onnxModel);
        }
    }

    public RankProfileList rankProfileList() {
        return this.rankProfileList;
    }

    private void setupRouting(DeployState deployState) {
        this.root.setupRouting(deployState, this, this.configModelRepo);
    }

    @Override
    public HostSystem hostSystem() {
        return this.root.hostSystem();
    }

    public Set<HostInfo> getHosts() {
        return this.hostSystem().getHosts().stream().map(HostResource::getHostInfo).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<FileReference> fileReferences() {
        return this.fileReferencesRepository.allFileReferences();
    }

    public ApplicationConfigProducerRoot getVespa() {
        return this.root;
    }

    public boolean allowModelVersionMismatch(Instant now) {
        return this.validationOverrides.allows(ValidationId.configModelVersionMismatch, now) || this.validationOverrides.allows(ValidationId.skipOldConfigModels, now);
    }

    public boolean skipOldConfigModels(Instant now) {
        return this.validationOverrides.allows(ValidationId.skipOldConfigModels, now);
    }

    public Version version() {
        return this.version;
    }

    public Version wantedNodeVersion() {
        return this.wantedNodeVersion;
    }

    @Override
    public <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> clazz, String configId) {
        try {
            ConfigInstance.Builder builder = VespaModel.newBuilder(clazz);
            this.getConfig(builder, configId);
            return VespaModel.newConfigInstance(clazz, builder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> configClass, ConfigProducer configProducer) {
        try {
            ConfigInstance.Builder builder = VespaModel.newBuilder(configClass);
            VespaModel.populateConfigBuilder(builder, configProducer);
            return VespaModel.newConfigInstance(configClass, builder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting config for class " + configClass.getName(), e);
        }
    }

    private static <CONFIGTYPE extends ConfigInstance> CONFIGTYPE newConfigInstance(Class<CONFIGTYPE> configClass, ConfigInstance.Builder builder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<CONFIGTYPE> constructor = configClass.getConstructor(builder.getClass());
        return (CONFIGTYPE)((ConfigInstance)constructor.newInstance(builder));
    }

    private static ConfigInstance.Builder newBuilder(Class<? extends ConfigInstance> configClass) throws ReflectiveOperationException {
        Class<?> builderClazz = configClass.getClassLoader().loadClass(configClass.getName() + "$Builder");
        return (ConfigInstance.Builder)builderClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void checkId(String configId) {
        if (!this.id2producer.containsKey(configId)) {
            log.log(Level.FINE, () -> "Invalid config id: " + configId);
        }
    }

    @Override
    public ConfigInstance.Builder getConfig(ConfigInstance.Builder builder, String configId) {
        this.checkId(configId);
        Optional<ConfigProducer> configProducer = this.getConfigProducer(configId);
        if (configProducer.isEmpty()) {
            return null;
        }
        VespaModel.populateConfigBuilder(builder, configProducer.get());
        return builder;
    }

    private static void populateConfigBuilder(ConfigInstance.Builder builder, ConfigProducer configProducer) {
        boolean found = configProducer.cascadeConfig(builder);
        boolean foundOverride = configProducer.addUserConfig(builder);
        log.log(Level.FINE, () -> "Trying to get config for " + builder.getClass().getDeclaringClass().getName() + " for config id " + StringUtilities.quote((Object)configProducer.getConfigId()) + ", found=" + found + ", foundOverride=" + foundOverride);
    }

    public ConfigInstance.Builder getConfigInstance(ConfigKey<?> configKey, ConfigDefinition targetDef) {
        Objects.requireNonNull(targetDef, "config definition cannot be null");
        return this.resolveToBuilder(configKey);
    }

    private ConfigInstance.Builder resolveToBuilder(ConfigKey<?> key) {
        ConfigInstance.Builder builder = this.createBuilder(new ConfigDefinitionKey(key));
        this.getConfig(builder, key.getConfigId());
        return builder;
    }

    public Set<ConfigKey<?>> allConfigsProduced() {
        LinkedHashSet keySet = new LinkedHashSet();
        for (ConfigProducer producer : this.id2producer().values()) {
            keySet.addAll(VespaModel.configsProduced(producer));
        }
        return keySet;
    }

    private ConfigInstance.Builder createBuilder(ConfigDefinitionKey key) {
        Object i;
        Class<?> clazz;
        String className = ConfiggenUtil.createClassName((String)key.getName());
        Pair<String, ClassLoader> fullClassNameAndLoader = this.getClassLoaderForProducer(key, className);
        String fullClassName = (String)fullClassNameAndLoader.getFirst();
        ClassLoader classLoader = (ClassLoader)fullClassNameAndLoader.getSecond();
        String builderName = fullClassName + "$Builder";
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
            log.log(Level.FINE, () -> "No producer found to get classloader from for " + fullClassName + ". Using default");
        }
        try {
            clazz = classLoader.loadClass(builderName);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINE, () -> "Tried to load " + builderName + ", not found, trying with generic builder");
            return new GenericConfig.GenericConfigBuilder(key, new ConfigPayloadBuilder());
        }
        try {
            i = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigurationRuntimeException((Throwable)e);
        }
        if (!(i instanceof ConfigInstance.Builder)) {
            throw new ConfigurationRuntimeException(fullClassName + " is not a ConfigInstance.Builder, can not produce config for the name '" + key.getName() + "'.");
        }
        return (ConfigInstance.Builder)i;
    }

    private Pair<String, ClassLoader> getClassLoaderForProducer(ConfigDefinitionKey key, String shortClassName) {
        String producerSuffix;
        String fullClassNameWithComYahoo = InstanceResolver.packageName(key, InstanceResolver.PackagePrefix.COM_YAHOO) + "." + shortClassName;
        String fullClassNameWithoutPrefix = InstanceResolver.packageName(key, InstanceResolver.PackagePrefix.NONE) + "." + shortClassName;
        ClassLoader loader = this.getConfigClassLoader(fullClassNameWithoutPrefix + (producerSuffix = "$Producer"));
        if (loader != null) {
            return new Pair((Object)fullClassNameWithoutPrefix, (Object)loader);
        }
        return new Pair((Object)fullClassNameWithComYahoo, (Object)this.getConfigClassLoader(fullClassNameWithComYahoo + producerSuffix));
    }

    public Set<String> allConfigIds() {
        return this.id2producer.keySet();
    }

    public AllocatedHosts allocatedHosts() {
        return this.allocatedHosts;
    }

    private static Set<ConfigKey<?>> configsProduced(ConfigProducer cp) {
        Set<ConfigKey<?>> ret = ReflectionUtil.getAllConfigsProduced(cp.getClass(), cp.getConfigId());
        UserConfigRepo userConfigs = cp.getUserConfigs();
        for (ConfigDefinitionKey userKey : userConfigs.configsProduced()) {
            ret.add(new ConfigKey(userKey.getName(), cp.getConfigId(), userKey.getNamespace()));
        }
        return ret;
    }

    @Override
    public Set<String> getConfigIds() {
        return Collections.unmodifiableSet(this.id2producer.keySet());
    }

    @Override
    public Admin getAdmin() {
        return this.root.getAdmin();
    }

    @Override
    public void addDescendant(String configId, AbstractConfigProducer<?> descendant) {
        if (this.id2producer.containsKey(configId)) {
            throw new RuntimeException("Config ID '" + configId + "' cannot be reserved by an instance of class '" + descendant.getClass().getName() + "' since it is already used by an instance of class '" + ((ConfigProducer)this.id2producer.get(configId)).getClass().getName() + "'. (This is commonly caused by service/node index collisions in the config.)");
        }
        this.id2producer.put(configId, descendant);
    }

    public List<SearchCluster> getSearchClusters() {
        return Content.getSearchClusters(this.configModelRepo());
    }

    public Map<String, ContentCluster> getContentClusters() {
        LinkedHashMap<String, ContentCluster> clusters = new LinkedHashMap<String, ContentCluster>();
        for (Content model : this.configModelRepo.getModels(Content.class)) {
            clusters.put(model.getId(), model.getCluster());
        }
        return Collections.unmodifiableMap(clusters);
    }

    public Map<String, ApplicationContainerCluster> getContainerClusters() {
        LinkedHashMap<String, ApplicationContainerCluster> clusters = new LinkedHashMap<String, ApplicationContainerCluster>();
        for (ContainerModel model : this.configModelRepo.getModels(ContainerModel.class)) {
            if (!(model.getCluster() instanceof ApplicationContainerCluster)) continue;
            clusters.put(model.getId(), (ApplicationContainerCluster)model.getCluster());
        }
        return Collections.unmodifiableMap(clusters);
    }

    public Routing getRouting() {
        return this.configModelRepo.getRouting();
    }

    @Override
    public FileDistributionConfigProducer getFileDistributionConfigProducer() {
        return this.root.getFileDistributionConfigProducer();
    }

    public Map<String, ConfigProducer> id2producer() {
        return Collections.unmodifiableMap(this.id2producer);
    }

    @Override
    public ConfigModelRepo configModelRepo() {
        return this.configModelRepo;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public Set<ClusterSpec.Id> allClusters() {
        return this.hostSystem().getHosts().stream().map(HostResource::spec).filter(spec -> spec.membership().isPresent()).map(spec -> ((ClusterMembership)spec.membership().get()).cluster().id()).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    public Set<ApplicationClusterInfo> applicationClusterInfo() {
        return Set.copyOf(this.getContainerClusters().values());
    }
}

