/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.cloud.config.SentinelConfig;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.ConfigSentinel;
import com.yahoo.vespa.model.HostSystem;
import java.util.Objects;

public final class Host
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements SentinelConfig.Producer,
Comparable<Host> {
    private ConfigSentinel configSentinel = null;
    private final String hostname;
    private final boolean runsConfigServer;

    public Host(AbstractConfigProducer parent, String hostname) {
        this(parent, hostname, false);
    }

    private Host(AbstractConfigProducer parent, String hostname, boolean runsConfigServer) {
        super(parent, hostname);
        Objects.requireNonNull(hostname, "The host name of a host cannot be null");
        this.runsConfigServer = runsConfigServer;
        this.hostname = hostname;
        if (parent instanceof HostSystem) {
            ((HostSystem)parent).checkName(hostname);
        }
    }

    public static Host createConfigServerHost(AbstractConfigProducer parent, String hostname) {
        return new Host(parent, hostname, true);
    }

    public static Host createHost(AbstractConfigProducer parent, String hostname) {
        return new Host(parent, hostname, false);
    }

    Host(AbstractConfigProducer parent) {
        super(parent, "testhost");
        this.hostname = "testhost";
        this.configSentinel = null;
        this.runsConfigServer = false;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean runsConfigServer() {
        return this.runsConfigServer;
    }

    public String toString() {
        return "host '" + this.getHostname() + "'";
    }

    public void getConfig(SentinelConfig.Builder builder) {
        if (this.configSentinel != null) {
            this.configSentinel.getConfig(builder);
        }
    }

    public void setConfigSentinel(ConfigSentinel configSentinel) {
        this.configSentinel = configSentinel;
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Host)) {
            return false;
        }
        return ((Host)other).hostname.equals(this.hostname);
    }

    @Override
    public int compareTo(Host other) {
        return this.hostname.compareTo(other.hostname);
    }
}

