/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import java.util.ArrayList;
import java.util.List;

public class TokenizeAndDeQuote {
    private static final char ESCAPE = '\\';
    private final String delims;
    private final String quotes;

    public TokenizeAndDeQuote(String delims, String quotes) {
        this.delims = delims;
        this.quotes = quotes;
    }

    public List<String> tokenize(String string) {
        StringBuilder current = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        char quote = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i + 1 < string.length()) {
                current.append(string.charAt(++i));
                continue;
            }
            if (quote == '\u0000' && this.delims.indexOf(c) >= 0) {
                tokens.add(current.toString());
                current.setLength(0);
                continue;
            }
            if (quote == '\u0000' && this.quotes.indexOf(c) >= 0) {
                quote = c;
                continue;
            }
            if (quote == c) {
                quote = '\u0000';
                continue;
            }
            current.append(c);
        }
        if (!current.isEmpty()) {
            tokens.add(current.toString());
        }
        return tokens;
    }
}

