/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import ai.vespa.models.evaluation.ModelsEvaluator;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.schema.derived.RankProfileList;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.PlatformBundles;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import java.nio.file.Path;
import java.util.Objects;

public class ContainerModelEvaluation
implements RankProfilesConfig.Producer,
RankingConstantsConfig.Producer,
OnnxModelsConfig.Producer,
RankingExpressionsConfig.Producer {
    private static final String EVALUATION_BUNDLE_NAME = "model-evaluation";
    private static final String INTEGRATION_BUNDLE_NAME = "model-integration";
    private static final String ONNXRUNTIME_BUNDLE_NAME = "container-onnxruntime.jar";
    private static final String EVALUATOR_NAME = ModelsEvaluator.class.getName();
    private static final String REST_HANDLER_NAME = "ai.vespa.models.handler.ModelsEvaluationHandler";
    private static final String REST_BINDING_PATH = "/model-evaluation/v1";
    public static final Path MODEL_EVALUATION_BUNDLE_FILE = PlatformBundles.absoluteBundlePath("model-evaluation");
    public static final Path MODEL_INTEGRATION_BUNDLE_FILE = PlatformBundles.absoluteBundlePath("model-integration");
    public static final Path ONNXRUNTIME_BUNDLE_FILE = PlatformBundles.absoluteBundlePath("container-onnxruntime.jar");
    private final RankProfileList rankProfileList;

    public ContainerModelEvaluation(ApplicationContainerCluster cluster, RankProfileList rankProfileList) {
        this.rankProfileList = Objects.requireNonNull(rankProfileList, "rankProfileList cannot be null");
        cluster.addSimpleComponent(EVALUATOR_NAME, null, EVALUATION_BUNDLE_NAME);
        cluster.addComponent(ContainerModelEvaluation.getHandler());
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        this.rankProfileList.getConfig(builder);
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        this.rankProfileList.getConfig(builder);
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        this.rankProfileList.getConfig(builder);
    }

    public void getConfig(RankingExpressionsConfig.Builder builder) {
        this.rankProfileList.getConfig(builder);
    }

    public static Handler getHandler() {
        Handler handler = new Handler(new ComponentModel(REST_HANDLER_NAME, null, EVALUATION_BUNDLE_NAME));
        handler.addServerBindings(SystemBindingPattern.fromHttpPath(REST_BINDING_PATH), SystemBindingPattern.fromHttpPath("/model-evaluation/v1/*"));
        return handler;
    }
}

