/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.http.FilterBinding;
import com.yahoo.vespa.model.container.http.Http;
import java.util.logging.Level;

class UriBindingsValidator
extends Validator {
    UriBindingsValidator() {
    }

    @Override
    public void validate(VespaModel model, DeployState deployState) {
        for (ApplicationContainerCluster cluster : model.getContainerClusters().values()) {
            for (Handler handler : cluster.getHandlers()) {
                for (BindingPattern binding : handler.getServerBindings()) {
                    UriBindingsValidator.validateUserBinding(binding, model, deployState);
                }
            }
            Http http = cluster.getHttp();
            if (http == null) continue;
            for (FilterBinding binding : cluster.getHttp().getBindings()) {
                UriBindingsValidator.validateUserBinding(binding.binding(), model, deployState);
            }
        }
    }

    private static void validateUserBinding(BindingPattern binding, VespaModel model, DeployState deployState) {
        UriBindingsValidator.validateScheme(binding, deployState);
        if (UriBindingsValidator.isHostedApplication(model, deployState)) {
            UriBindingsValidator.validateHostedApplicationUserBinding(binding, deployState);
        }
    }

    private static void validateScheme(BindingPattern binding, DeployState deployState) {
        if (binding.scheme().equals("https")) {
            String message = UriBindingsValidator.createErrorMessage(binding, "'https' bindings are deprecated, use 'http' instead to bind to both http and https traffic.");
            deployState.getDeployLogger().logApplicationPackage(Level.WARNING, message);
        }
    }

    private static void validateHostedApplicationUserBinding(BindingPattern binding, DeployState deployState) {
        if (binding instanceof SystemBindingPattern) {
            return;
        }
        if (!binding.matchesAnyPort() && !deployState.featureFlags().useRestrictedDataPlaneBindings()) {
            throw new IllegalArgumentException(UriBindingsValidator.createErrorMessage(binding, "binding with port is not allowed"));
        }
        if (!binding.host().equals("*")) {
            throw new IllegalArgumentException(UriBindingsValidator.createErrorMessage(binding, "only binding with wildcard ('*') for hostname is allowed"));
        }
        if (!binding.scheme().equals("http") && !binding.scheme().equals("https")) {
            throw new IllegalArgumentException(UriBindingsValidator.createErrorMessage(binding, "only 'http' is allowed as scheme"));
        }
    }

    private static boolean isHostedApplication(VespaModel model, DeployState deployState) {
        return deployState.isHosted() && model.getAdmin().getApplicationType() != ConfigModelContext.ApplicationType.HOSTED_INFRASTRUCTURE;
    }

    private static String createErrorMessage(BindingPattern binding, String message) {
        return String.format("For binding '%s': %s", binding.patternString(), message);
    }
}

