/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.TuningDispatch;
import java.util.List;
import java.util.stream.Collectors;

public class IndexedHierarchicDistributionValidator {
    private final String clusterName;
    private final StorageGroup rootGroup;
    private final Redundancy redundancy;
    private final TuningDispatch.DispatchPolicy dispatchPolicy;

    public IndexedHierarchicDistributionValidator(String clusterName, StorageGroup rootGroup, Redundancy redundancy, TuningDispatch.DispatchPolicy dispatchPolicy) {
        this.clusterName = clusterName;
        this.rootGroup = rootGroup;
        this.redundancy = redundancy;
        this.dispatchPolicy = dispatchPolicy;
    }

    public void validate() throws Exception {
        this.validateThatWeHaveOneGroupLevel();
        this.validateThatLeafGroupsHasEqualNumberOfNodes();
        IndexedHierarchicDistributionValidator.validateThatLeafGroupsCountIsAFactorOfRedundancy(this.clusterName, this.redundancy.effectiveFinalRedundancy(), this.rootGroup.getSubgroups().size());
        this.validateThatRedundancyPerGroupIsEqual();
        IndexedHierarchicDistributionValidator.validateThatReadyCopiesIsCompatibleWithRedundancy(this.clusterName, this.redundancy.effectiveFinalRedundancy(), this.redundancy.effectiveReadyCopies(), this.rootGroup.getSubgroups().size());
    }

    private void validateThatWeHaveOneGroupLevel() {
        for (StorageGroup group : this.rootGroup.getSubgroups()) {
            if (group.getSubgroups().size() <= 0) continue;
            throw new IllegalArgumentException(IndexedHierarchicDistributionValidator.getErrorMsgPrefix(this.clusterName) + "Expected all groups under root group '" + this.rootGroup.getName() + "' to be leaf groups only containing nodes, but sub group '" + group.getName() + "' contains " + group.getSubgroups().size() + " sub groups.");
        }
    }

    private void validateThatLeafGroupsHasEqualNumberOfNodes() {
        if (this.dispatchPolicy != TuningDispatch.DispatchPolicy.ROUNDROBIN) {
            return;
        }
        StorageGroup previousGroup = null;
        for (StorageGroup group : this.rootGroup.getSubgroups()) {
            if (previousGroup == null) {
                previousGroup = group;
                continue;
            }
            if (group.getNodes().size() != previousGroup.getNodes().size()) {
                throw new IllegalArgumentException(IndexedHierarchicDistributionValidator.getErrorMsgPrefix(this.clusterName) + "Expected leaf groups to contain an equal number of nodes, but leaf group '" + previousGroup.getName() + "' contains " + previousGroup.getNodes().size() + " node(s) while leaf group '" + group.getName() + "' contains " + group.getNodes().size() + " node(s).");
            }
            previousGroup = group;
        }
    }

    public static void validateThatLeafGroupsCountIsAFactorOfRedundancy(String clusterName, int totalRedundancy, int subGroups) {
        if (totalRedundancy % subGroups != 0) {
            throw new IllegalArgumentException(IndexedHierarchicDistributionValidator.getErrorMsgPrefix(clusterName) + "Expected number of leaf groups (" + subGroups + ") to be a factor of redundancy (" + totalRedundancy + "), but it is not.");
        }
    }

    private void validateThatRedundancyPerGroupIsEqual() {
        int redundancyPerGroup = this.redundancy.effectiveFinalRedundancy() / this.rootGroup.getSubgroups().size();
        String expPartitions = this.createDistributionPartitions(redundancyPerGroup, this.rootGroup.getSubgroups().size());
        if (!this.rootGroup.getPartitions().get().equals(expPartitions)) {
            throw new IllegalArgumentException(IndexedHierarchicDistributionValidator.getErrorMsgPrefix(this.clusterName) + "Expected redundancy per leaf group to be " + redundancyPerGroup + ", but it is not according to distribution partitions '" + this.rootGroup.getPartitions().get() + "'. Expected distribution partitions should be '" + expPartitions + "'.");
        }
    }

    private List<StorageNode> nonRetired(List<StorageNode> nodes) {
        return nodes.stream().filter(node -> !node.isRetired()).collect(Collectors.toList());
    }

    private String createDistributionPartitions(int redundancyPerGroup, int numGroups) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numGroups - 1; ++i) {
            sb.append(redundancyPerGroup);
            sb.append("|");
        }
        sb.append("*");
        return sb.toString();
    }

    public static void validateThatReadyCopiesIsCompatibleWithRedundancy(String clusterName, int totalRedundancy, int totalReadyCopies, int groupCount) {
        if (totalRedundancy % groupCount != 0) {
            throw new IllegalArgumentException(IndexedHierarchicDistributionValidator.getErrorMsgPrefix(clusterName) + "Expected equal redundancy per group.");
        }
        if (totalReadyCopies % groupCount != 0) {
            throw new IllegalArgumentException(IndexedHierarchicDistributionValidator.getErrorMsgPrefix(clusterName) + "Expected equal amount of ready copies per group, but " + totalReadyCopies + " ready copies is specified with " + groupCount + " groups");
        }
        if (totalReadyCopies == 0) {
            System.err.println(IndexedHierarchicDistributionValidator.getErrorMsgPrefix(clusterName) + "Warning. No ready copies configured. At least one is recommended.");
        }
    }

    private static String getErrorMsgPrefix(String clusterName) {
        return "In indexed content cluster '" + clusterName + "' using hierarchic distribution: ";
    }
}

