/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.first;

import com.yahoo.collections.CollectionUtil;
import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.http.AccessControl;
import java.util.ArrayList;

public class AccessControlValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        if (!deployState.isHosted()) {
            return;
        }
        if (!deployState.zone().environment().isProduction()) {
            return;
        }
        if (deployState.zone().system().isPublic()) {
            return;
        }
        if (model.getAdmin().getApplicationType() != ConfigModelContext.ApplicationType.DEFAULT) {
            return;
        }
        ArrayList<String> offendingClusters = new ArrayList<String>();
        for (ContainerCluster containerCluster : model.getContainerClusters().values()) {
            ApplicationContainerCluster cluster;
            if (!(containerCluster instanceof ApplicationContainerCluster) || (cluster = (ApplicationContainerCluster)containerCluster).getHttp() != null && cluster.getHttp().getAccessControl().isPresent() && cluster.getHttp().getAccessControl().get().writeEnabled || !this.hasHandlerThatNeedsProtection(cluster) && cluster.getAllServlets().isEmpty()) continue;
            offendingClusters.add(cluster.getName());
        }
        if (!offendingClusters.isEmpty()) {
            deployState.validationOverrides().invalid(ValidationId.accessControl, "Access-control must be enabled for write operations to container clusters in production zones: " + CollectionUtil.mkString(offendingClusters, (String)"[", (String)", ", (String)"]."), deployState.now());
        }
    }

    private boolean hasHandlerThatNeedsProtection(ApplicationContainerCluster cluster) {
        return cluster.getHandlers().stream().anyMatch(this::handlerNeedsProtection);
    }

    private boolean handlerNeedsProtection(Handler<?> handler) {
        return !AccessControl.isBuiltinGetOnly(handler) && this.hasNonMbusBinding(handler);
    }

    private boolean hasNonMbusBinding(Handler<?> handler) {
        return handler.getServerBindings().stream().anyMatch(binding -> !binding.startsWith("mbus"));
    }
}

