/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.utils.internal;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Set<ConfigKey<?>> configsProducedByInterface(Class<?> iface, String configId) {
        LinkedHashSet ret = new LinkedHashSet();
        if (ReflectionUtil.isConcreteProducer(iface)) {
            ret.add(ReflectionUtil.createConfigKeyFromInstance(iface.getEnclosingClass(), configId));
        }
        for (Class<?> parentIface : iface.getInterfaces()) {
            ret.addAll(ReflectionUtil.configsProducedByInterface(parentIface, configId));
        }
        return ret;
    }

    public static boolean hasRestartMethods(Class<? extends ConfigInstance> configClass) {
        try {
            configClass.getDeclaredMethod("containsFieldsFlaggedWithRestart", new Class[0]);
            configClass.getDeclaredMethod("getChangesRequiringRestart", configClass);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean containsFieldsFlaggedWithRestart(Class<? extends ConfigInstance> configClass) {
        try {
            Method m = configClass.getDeclaredMethod("containsFieldsFlaggedWithRestart", new Class[0]);
            m.setAccessible(true);
            return (Boolean)m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ChangesRequiringRestart getChangesRequiringRestart(ConfigInstance from, ConfigInstance to) {
        Class<?> clazz = from.getClass();
        if (!clazz.equals(to.getClass())) {
            throw new IllegalArgumentException(String.format("%s != %s", clazz, to.getClass()));
        }
        try {
            Method m = clazz.getDeclaredMethod("getChangesRequiringRestart", clazz);
            m.setAccessible(true);
            return (ChangesRequiringRestart)m.invoke((Object)from, to);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static ConfigKey<?> createConfigKeyFromInstance(Class<?> configInstClass, String configId) {
        try {
            String defName = ConfigInstance.getDefName(configInstClass);
            String defNamespace = ConfigInstance.getDefNamespace(configInstClass);
            return new ConfigKey(defName, configId, defNamespace);
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean classIsConfigInstanceProducer(Class<?> clazz) {
        return clazz.getName().equals(ConfigInstance.Producer.class.getName());
    }

    private static boolean isConcreteProducer(Class<?> producerInterface) {
        boolean parentIsConfigInstance = false;
        for (Class<?> ifaceParent : producerInterface.getInterfaces()) {
            if (!ReflectionUtil.classIsConfigInstanceProducer(ifaceParent)) continue;
            parentIsConfigInstance = true;
        }
        return ConfigInstance.Producer.class.isAssignableFrom(producerInterface) && parentIsConfigInstance && !ReflectionUtil.classIsConfigInstanceProducer(producerInterface);
    }
}

