/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.provision.RotationName;
import com.yahoo.text.XML;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class Rotations {
    private static final Pattern pattern = Pattern.compile("^[a-z](?:-?[a-z0-9]+)*$");
    private static final int maxLength = 12;

    private Rotations() {
    }

    public static Set<RotationName> from(Element rotationsElement) {
        TreeSet<RotationName> rotations = new TreeSet<RotationName>();
        List children = XML.getChildren((Element)rotationsElement, (String)"rotation");
        for (Element el : children) {
            String name = el.getAttribute("id");
            if (name == null || name.length() > 12 || !pattern.matcher(name).matches()) {
                throw new IllegalArgumentException("Rotation ID '" + name + "' is missing or has invalid format");
            }
            RotationName rotation = RotationName.from((String)name);
            if (rotations.contains(rotation)) {
                throw new IllegalArgumentException("Rotation ID '" + name + "' is duplicated");
            }
            rotations.add(rotation);
        }
        return Collections.unmodifiableSet(rotations);
    }
}

