/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Rotation;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.admin.Configserver;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TestProperties
implements ModelContext.Properties {
    private boolean multitenant = false;
    private ApplicationId applicationId = ApplicationId.defaultId();
    private List<ConfigServerSpec> configServerSpecs = Collections.emptyList();
    private HostName loadBalancerName = null;
    private URI ztsUrl = null;
    private String athenzDnsSuffix = null;
    private boolean hostedVespa = false;
    private Zone zone;
    private Set<Rotation> rotations;
    private boolean isBootstrap = false;
    private boolean isFirstTimeDeployment = false;
    private boolean useDedicatedNodeForLogserver = false;
    private boolean useFdispatchByDefault = true;
    private boolean useAdaptiveDispatch = false;

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.configServerSpecs;
    }

    public HostName loadBalancerName() {
        return this.loadBalancerName;
    }

    public URI ztsUrl() {
        return this.ztsUrl;
    }

    public String athenzDnsSuffix() {
        return this.athenzDnsSuffix;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Zone zone() {
        return this.zone;
    }

    public Set<Rotation> rotations() {
        return this.rotations;
    }

    public boolean isBootstrap() {
        return this.isBootstrap;
    }

    public boolean isFirstTimeDeployment() {
        return this.isFirstTimeDeployment;
    }

    public boolean useAdaptiveDispatch() {
        return this.useAdaptiveDispatch;
    }

    public boolean useDedicatedNodeForLogserver() {
        return this.useDedicatedNodeForLogserver;
    }

    public boolean useFdispatchByDefault() {
        return this.useFdispatchByDefault;
    }

    public TestProperties setApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public TestProperties setHostedVespa(boolean hostedVespa) {
        this.hostedVespa = hostedVespa;
        return this;
    }

    public TestProperties setUseAdaptiveDispatch(boolean useAdaptiveDispatch) {
        this.useAdaptiveDispatch = useAdaptiveDispatch;
        return this;
    }

    public TestProperties setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
        return this;
    }

    public TestProperties setConfigServerSpecs(List<Configserver.Spec> configServerSpecs) {
        this.configServerSpecs = ImmutableList.copyOf(configServerSpecs);
        return this;
    }

    public TestProperties setUseDedicatedNodeForLogserver(boolean useDedicatedNodeForLogserver) {
        this.useDedicatedNodeForLogserver = useDedicatedNodeForLogserver;
        return this;
    }
}

