/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.Binding;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Http
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements ServerConfig.Producer {
    private FilterChains filterChains;
    private JettyHttpServer httpServer;
    public final List<Binding> bindings;
    private final Optional<AccessControl> accessControl;

    public Http(List<Binding> bindings) {
        this(bindings, null);
    }

    public Http(List<Binding> bindings, AccessControl accessControl) {
        super("http");
        this.bindings = Collections.unmodifiableList(bindings);
        this.accessControl = Optional.ofNullable(accessControl);
    }

    public void setFilterChains(FilterChains filterChains) {
        this.filterChains = filterChains;
    }

    public FilterChains getFilterChains() {
        return this.filterChains;
    }

    public JettyHttpServer getHttpServer() {
        return this.httpServer;
    }

    public void setHttpServer(JettyHttpServer newServer) {
        JettyHttpServer oldServer = this.httpServer;
        this.httpServer = newServer;
        if (oldServer == null && newServer != null) {
            this.addChild(newServer);
        } else if (newServer == null && oldServer != null) {
            this.removeChild(oldServer);
        } else if (newServer != null || oldServer != null) {
            this.removeChild(oldServer);
            this.addChild(newServer);
        }
    }

    public void removeAllServers() {
        this.setHttpServer(null);
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public Optional<AccessControl> getAccessControl() {
        return this.accessControl;
    }

    public void getConfig(ServerConfig.Builder builder) {
        for (Binding binding : this.bindings) {
            builder.filter(new ServerConfig.Filter.Builder().id(binding.filterId().stringValue()).binding(binding.binding()));
        }
    }

    @Override
    public void validate() {
        this.validate(this.bindings);
    }

    void validate(Collection<Binding> bindings) {
        if (!bindings.isEmpty()) {
            if (this.filterChains == null) {
                throw new IllegalArgumentException("Null FilterChains is not allowed when there are filter bindings!");
            }
            ComponentRegistry<ChainedComponent<?>> filters = this.filterChains.componentsRegistry();
            ComponentRegistry chains = this.filterChains.allChains();
            for (Binding binding : bindings) {
                if (filters.getComponent(binding.filterId()) != null || chains.getComponent(binding.filterId()) != null) continue;
                throw new RuntimeException("Can't find filter " + binding.filterId() + " for binding " + binding.binding());
            }
        }
    }
}

