/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PortsMeta
implements Serializable {
    private List<LinkedList<String>> ports = new ArrayList<LinkedList<String>>();
    private Integer rpcAdminOffset = null;
    private Integer rpcStatusOffset = null;
    private Integer httpAdminOffset = null;
    private Integer httpStatusOffset = null;
    private Integer currentOffset;

    public PortsMeta on(int offset) {
        this.currentOffset = offset;
        return this;
    }

    public PortsMeta tag(String meta) {
        if (this.currentOffset == null) {
            throw new NullPointerException("No current port offset to tag, use 'on#1'");
        }
        return this.register(this.currentOffset, meta);
    }

    private PortsMeta register(int offset, String meta) {
        for (int i = this.ports.size(); i <= offset; ++i) {
            this.ports.add(i, new LinkedList());
        }
        this.ports.get(offset).addFirst(meta);
        return this;
    }

    public boolean contains(int offset, String meta) {
        return offset < this.ports.size() && this.ports.get(offset).contains(meta);
    }

    public int getNumPorts() {
        return this.ports.size();
    }

    public List<String> getTagsAt(int offset) {
        try {
            return this.ports.get(offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Trying to get ports meta with offset " + offset + ", which is outside the range 0 to " + this.ports.size(), e);
        }
    }

    public Integer getRpcAdminOffset() {
        if (this.rpcAdminOffset == null) {
            for (int p = 0; p < this.getNumPorts(); ++p) {
                if (!this.contains(p, "rpc") || !this.contains(p, "admin") || this.contains(p, "nc")) continue;
                this.rpcAdminOffset = p;
                break;
            }
        }
        return this.rpcAdminOffset;
    }

    public Integer getRpcStatusOffset() {
        if (this.rpcStatusOffset == null) {
            for (int p = 0; p < this.getNumPorts(); ++p) {
                if (!this.contains(p, "rpc") || !this.contains(p, "status") || this.contains(p, "nc")) continue;
                this.rpcStatusOffset = p;
                break;
            }
        }
        return this.rpcStatusOffset;
    }

    public Integer getHttpAdminOffset() {
        if (this.httpAdminOffset == null) {
            for (int p = 0; p < this.getNumPorts(); ++p) {
                if (!this.contains(p, "http") || !this.contains(p, "admin")) continue;
                this.httpAdminOffset = p;
                break;
            }
        }
        return this.httpAdminOffset;
    }

    public Integer getHttpStatusOffset() {
        if (this.httpStatusOffset == null) {
            for (int p = 0; p < this.getNumPorts(); ++p) {
                if (!this.contains(p, "http") || !this.contains(p, "status")) continue;
                this.httpStatusOffset = p;
                break;
            }
        }
        return this.httpStatusOffset;
    }
}

