/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.provision.Flavor;
import com.yahoo.vespa.config.search.core.ProtonConfig;

public class NodeFlavorTuning
implements ProtonConfig.Producer {
    static long MB = 0x100000L;
    static long GB = MB * 1024L;
    private final Flavor nodeFlavor;
    private final int redundancy;
    private final int searchableCopies;

    public NodeFlavorTuning(Flavor nodeFlavor, int redundancy, int searchableCopies) {
        this.nodeFlavor = nodeFlavor;
        this.redundancy = redundancy;
        this.searchableCopies = searchableCopies;
    }

    public void getConfig(ProtonConfig.Builder builder) {
        this.setHwInfo(builder);
        this.tuneDiskWriteSpeed(builder);
        this.tuneDocumentStoreMaxFileSize(builder.summary.log);
        this.tuneFlushStrategyMemoryLimits(builder.flush.memory);
        this.tuneFlushStrategyTlsSize(builder.flush.memory);
        this.tuneSummaryReadIo(builder.summary.read);
        this.tuneSummaryCache(builder.summary.cache);
        this.tuneSearchReadIo(builder.search.mmap);
        for (ProtonConfig.Documentdb.Builder dbb : builder.documentdb) {
            this.getConfig(dbb);
        }
    }

    private void getConfig(ProtonConfig.Documentdb.Builder builder) {
        ProtonConfig.Documentdb dbCfg = builder.build();
        if (dbCfg.mode() != ProtonConfig.Documentdb.Mode.Enum.INDEX) {
            long numDocs = (long)this.nodeFlavor.getMinMainMemoryAvailableGb() * GB / 64L;
            builder.allocation.initialnumdocs(numDocs / (long)Math.max(this.searchableCopies, this.redundancy));
        }
    }

    private void tuneSummaryCache(ProtonConfig.Summary.Cache.Builder builder) {
        long memoryLimitBytes = (long)(this.nodeFlavor.getMinMainMemoryAvailableGb() * 0.05 * (double)GB);
        builder.maxbytes(memoryLimitBytes);
    }

    private void setHwInfo(ProtonConfig.Builder builder) {
        builder.hwinfo.disk.size((long)this.nodeFlavor.getMinDiskAvailableGb() * GB);
        builder.hwinfo.disk.shared(this.nodeFlavor.getType().equals((Object)Flavor.Type.DOCKER_CONTAINER));
        builder.hwinfo.memory.size((long)this.nodeFlavor.getMinMainMemoryAvailableGb() * GB);
        builder.hwinfo.cpu.cores((int)this.nodeFlavor.getMinCpuCores());
    }

    private void tuneDiskWriteSpeed(ProtonConfig.Builder builder) {
        if (!this.nodeFlavor.hasFastDisk()) {
            builder.hwinfo.disk.writespeed(40.0);
        }
    }

    private void tuneDocumentStoreMaxFileSize(ProtonConfig.Summary.Log.Builder builder) {
        double memoryGb = this.nodeFlavor.getMinMainMemoryAvailableGb();
        long fileSizeBytes = 4L * GB;
        if (memoryGb <= 12.0) {
            fileSizeBytes = 256L * MB;
        } else if (memoryGb < 24.0) {
            fileSizeBytes = 512L * MB;
        } else if (memoryGb <= 64.0) {
            fileSizeBytes = 1L * GB;
        }
        builder.maxfilesize(fileSizeBytes);
    }

    private void tuneFlushStrategyMemoryLimits(ProtonConfig.Flush.Memory.Builder builder) {
        long memoryLimitBytes = (long)(this.nodeFlavor.getMinMainMemoryAvailableGb() / 8.0 * (double)GB);
        builder.maxmemory(memoryLimitBytes);
        builder.each.maxmemory(memoryLimitBytes);
    }

    private void tuneFlushStrategyTlsSize(ProtonConfig.Flush.Memory.Builder builder) {
        long tlsSizeBytes = (long)(this.nodeFlavor.getMinDiskAvailableGb() * 0.07 * (double)GB);
        tlsSizeBytes = Long.min(tlsSizeBytes, 100L * GB);
        builder.maxtlssize(tlsSizeBytes);
    }

    private void tuneSummaryReadIo(ProtonConfig.Summary.Read.Builder builder) {
        if (this.nodeFlavor.hasFastDisk()) {
            builder.io(ProtonConfig.Summary.Read.Io.DIRECTIO);
        }
    }

    private void tuneSearchReadIo(ProtonConfig.Search.Mmap.Builder builder) {
        if (this.nodeFlavor.hasFastDisk()) {
            builder.advise(ProtonConfig.Search.Mmap.Advise.RANDOM);
        }
    }
}

