/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.docproc;

import com.yahoo.collections.Pair;
import com.yahoo.config.docproc.DocprocConfig;
import com.yahoo.config.docproc.SchemamappingConfig;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.config.SessionConfig;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.ContainerSubsystem;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.container.docproc.DocumentProcessor;
import com.yahoo.vespa.model.container.docproc.MbusClient;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;

public class ContainerDocproc
extends ContainerSubsystem<DocprocChains>
implements ContainerMbusConfig.Producer,
SchemamappingConfig.Producer,
DocprocConfig.Producer {
    public final Options options;
    private boolean preferLocalNode = false;
    private int numNodesPerClient = 0;
    private Map<Pair<String, String>, String> fieldNameSchemaMap = new HashMap<Pair<String, String>, String>();

    public ContainerDocproc(ContainerCluster cluster, DocprocChains chains) {
        this(cluster, chains, new Options(false, null, null, null, null, null, null));
    }

    public ContainerDocproc(ContainerCluster cluster, DocprocChains chains, Options options) {
        this(cluster, chains, options, true);
    }

    private void addSource(ContainerCluster cluster, String name, SessionConfig.Type.Enum type) {
        MbusClient mbusClient = new MbusClient(name, type);
        mbusClient.addClientBindings("mbus://*/" + mbusClient.getSessionName());
        cluster.addComponent(mbusClient);
    }

    public ContainerDocproc(ContainerCluster cluster, DocprocChains chains, Options options, boolean addSourceClientProvider) {
        super(chains);
        assert (options != null) : "Null Options for " + this + " under cluster " + cluster.getName();
        this.options = options;
        if (addSourceClientProvider) {
            this.addSource(cluster, "source", SessionConfig.Type.SOURCE);
            this.addSource(cluster, "internalNoThrottledSource", SessionConfig.Type.INTERNAL);
        }
    }

    public boolean isCompressDocuments() {
        return this.options.compressDocuments;
    }

    public boolean isPreferLocalNode() {
        return this.preferLocalNode;
    }

    public int getNumNodesPerClient() {
        return this.numNodesPerClient;
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        builder.maxpendingcount(this.getMaxMessagesInQueue());
        if (this.getMaxQueueMbSize() != null) {
            builder.maxpendingsize(this.getMaxQueueMbSize().intValue());
        }
    }

    private int getMaxMessagesInQueue() {
        if (this.options.maxMessagesInQueue != null) {
            return this.options.maxMessagesInQueue;
        }
        return 2048 * ((DocprocChains)this.getChains()).allChains().allComponents().size();
    }

    @Nullable
    private Integer getMaxQueueMbSize() {
        return this.options.maxQueueMbSize;
    }

    private Integer getMaxQueueTimeMs() {
        return this.options.maxQueueTimeMs;
    }

    public void getConfig(DocprocConfig.Builder builder) {
        if (this.getMaxQueueTimeMs() != null) {
            builder.maxqueuetimems(this.getMaxQueueTimeMs().intValue());
        }
    }

    public void getConfig(SchemamappingConfig.Builder builder) {
        HashMap<Pair<String, String>, String> allMappings = new HashMap<Pair<String, String>, String>();
        for (DocprocChain chain : ((DocprocChains)this.getChains()).allChains().allComponents()) {
            for (DocumentProcessor processor : chain.getInnerComponents()) {
                allMappings.putAll(this.fieldNameSchemaMap());
                allMappings.putAll(chain.fieldNameSchemaMap());
                allMappings.putAll(processor.fieldNameSchemaMap());
                for (Map.Entry e : allMappings.entrySet()) {
                    String doctype = (String)((Pair)e.getKey()).getFirst();
                    String from = (String)((Pair)e.getKey()).getSecond();
                    String to = (String)e.getValue();
                    builder.fieldmapping(new SchemamappingConfig.Fieldmapping.Builder().chain(chain.getId().stringValue()).docproc(processor.getGlobalComponentId().stringValue()).indocument(from).inprocessor(to).doctype(doctype != null ? doctype : ""));
                }
                allMappings.clear();
            }
        }
    }

    public Map<Pair<String, String>, String> fieldNameSchemaMap() {
        return this.fieldNameSchemaMap;
    }

    public static class Options {
        public final boolean compressDocuments;
        public final Integer maxMessagesInQueue;
        public final Integer maxQueueMbSize;
        public final Integer maxQueueTimeMs;
        public final Double maxConcurrentFactor;
        public final Double documentExpansionFactor;
        public final Integer containerCoreMemory;

        public Options(boolean compressDocuments, Integer maxMessagesInQueue, Integer maxQueueMbSize, Integer maxQueueTimeMs, Double maxConcurrentFactor, Double documentExpansionFactor, Integer containerCoreMemory) {
            this.compressDocuments = compressDocuments;
            this.maxMessagesInQueue = maxMessagesInQueue;
            this.maxQueueMbSize = maxQueueMbSize;
            this.maxQueueTimeMs = maxQueueTimeMs;
            this.maxConcurrentFactor = maxConcurrentFactor;
            this.documentExpansionFactor = documentExpansionFactor;
            this.containerCoreMemory = containerCoreMemory;
        }
    }
}

