/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search;

import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.semantics.SemanticRulesConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.pagetemplates.PageTemplatesConfig;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ContainerSubsystem;
import com.yahoo.vespa.model.container.search.PageTemplates;
import com.yahoo.vespa.model.container.search.QrsCache;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.container.search.SemanticRules;
import com.yahoo.vespa.model.container.search.searchchain.LocalProvider;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.Dispatch;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.StreamingSearchCluster;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ContainerSearch
extends ContainerSubsystem<SearchChains>
implements IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
QrSearchersConfig.Producer,
QueryProfilesConfig.Producer,
SemanticRulesConfig.Producer,
PageTemplatesConfig.Producer {
    private final List<AbstractSearchCluster> systems = new LinkedList<AbstractSearchCluster>();
    private final Options options;
    private final boolean enableGroupingSessionCache;
    private QueryProfiles queryProfiles;
    private SemanticRules semanticRules;
    private PageTemplates pageTemplates;

    public ContainerSearch(ApplicationContainerCluster cluster, SearchChains chains, Options options) {
        super(chains);
        this.options = options;
        cluster.addComponent(ContainerSearch.getFS4ResourcePool());
        this.enableGroupingSessionCache = cluster.enableGroupingSessionCache();
    }

    private static Component<?, ComponentModel> getFS4ResourcePool() {
        BundleInstantiationSpecification spec = BundleInstantiationSpecification.getInternalSearcherSpecificationFromStrings((String)FS4ResourcePool.class.getName(), null);
        return new Component(new ComponentModel(spec));
    }

    public void connectSearchClusters(Map<String, AbstractSearchCluster> searchClusters) {
        this.systems.addAll(searchClusters.values());
        this.initializeSearchChains(searchClusters);
    }

    public void initializeSearchChains(Map<String, ? extends AbstractSearchCluster> searchClusters) {
        ((SearchChains)this.getChains()).initialize(searchClusters);
        QrsCache defaultCacheOptions = this.getOptions().cacheSettings.get("");
        if (defaultCacheOptions != null) {
            for (LocalProvider localProvider : ((SearchChains)this.getChains()).localProviders()) {
                localProvider.setCacheSize(defaultCacheOptions.size);
            }
        }
        for (LocalProvider localProvider : ((SearchChains)this.getChains()).localProviders()) {
            QrsCache cacheOptions = this.getOptions().cacheSettings.get(localProvider.getClusterName());
            if (cacheOptions == null) continue;
            localProvider.setCacheSize(cacheOptions.size);
        }
    }

    public void setQueryProfiles(QueryProfiles queryProfiles) {
        this.queryProfiles = queryProfiles;
    }

    public void setSemanticRules(SemanticRules semanticRules) {
        this.semanticRules = semanticRules;
    }

    public void setPageTemplates(PageTemplates pageTemplates) {
        this.pageTemplates = pageTemplates;
    }

    public void getConfig(QueryProfilesConfig.Builder builder) {
        if (this.queryProfiles != null) {
            this.queryProfiles.getConfig(builder);
            builder.enableGroupingSessionCache(this.enableGroupingSessionCache);
        }
    }

    public void getConfig(SemanticRulesConfig.Builder builder) {
        if (this.semanticRules != null) {
            this.semanticRules.getConfig(builder);
        }
    }

    public void getConfig(PageTemplatesConfig.Builder builder) {
        if (this.pageTemplates != null) {
            this.pageTemplates.getConfig(builder);
        }
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        for (AbstractSearchCluster sc : this.systems) {
            sc.getConfig(builder);
        }
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        for (AbstractSearchCluster sc : this.systems) {
            sc.getConfig(builder);
        }
    }

    public void getConfig(QrSearchersConfig.Builder builder) {
        for (int i = 0; i < this.systems.size(); ++i) {
            AbstractSearchCluster sys = ContainerSearch.findClusterWithId(this.systems, i);
            QrSearchersConfig.Searchcluster.Builder scB = new QrSearchersConfig.Searchcluster.Builder().name(sys.getClusterName());
            for (AbstractSearchCluster.SearchDefinitionSpec spec : sys.getLocalSDS()) {
                scB.searchdef(spec.getSearchDefinition().getName());
            }
            scB.rankprofiles(new QrSearchersConfig.Searchcluster.Rankprofiles.Builder().configid(sys.getConfigId()));
            scB.indexingmode(QrSearchersConfig.Searchcluster.Indexingmode.Enum.valueOf((String)sys.getIndexingModeName()));
            if (sys instanceof IndexedSearchCluster) {
                for (Dispatch tld : ((IndexedSearchCluster)sys).getTLDs()) {
                    scB.dispatcher(new QrSearchersConfig.Searchcluster.Dispatcher.Builder().host(tld.getHostname()).port(tld.getDispatchPort()));
                }
            } else {
                scB.storagecluster(new QrSearchersConfig.Searchcluster.Storagecluster.Builder().routespec(((StreamingSearchCluster)sys).getStorageRouteSpec()));
            }
            builder.searchcluster(scB);
        }
    }

    private static AbstractSearchCluster findClusterWithId(List<AbstractSearchCluster> clusters, int index) {
        for (AbstractSearchCluster sys : clusters) {
            if (sys.getClusterIndex() != index) continue;
            return sys;
        }
        throw new IllegalArgumentException("No search cluster with index " + index + " exists");
    }

    public Options getOptions() {
        return this.options;
    }

    public static class Options {
        Map<String, QrsCache> cacheSettings = new LinkedHashMap<String, QrsCache>();
    }
}

