/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GlobalDocumentChangeValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel currentModel, VespaModel nextModel, ValidationOverrides overrides, Instant now) {
        if (!overrides.allows(ValidationId.globalDocumentChange.value(), now)) {
            for (Map.Entry<String, ContentCluster> currentEntry : currentModel.getContentClusters().entrySet()) {
                ContentCluster nextCluster = nextModel.getContentClusters().get(currentEntry.getKey());
                if (nextCluster == null) continue;
                this.validateContentCluster(currentEntry.getValue(), nextCluster);
            }
        }
        return Collections.emptyList();
    }

    private void validateContentCluster(ContentCluster currentCluster, ContentCluster nextCluster) {
        String clusterName = currentCluster.getName();
        currentCluster.getDocumentDefinitions().forEach((documentTypeName, currentDocumentType) -> {
            boolean nextIsGlobal;
            boolean currentIsGlobal;
            NewDocumentType nextDocumentType = nextCluster.getDocumentDefinitions().get(documentTypeName);
            if (nextDocumentType != null && (currentIsGlobal = currentCluster.isGloballyDistributed((NewDocumentType)currentDocumentType)) != (nextIsGlobal = nextCluster.isGloballyDistributed(nextDocumentType))) {
                throw new IllegalStateException(String.format("Document type %s in cluster %s changed global from %s to %s. Add validation override '%s' to force this change through. First, stop services on all content nodes. Then, deploy with validation override. Finally, start services on all content nodes.", documentTypeName, clusterName, currentIsGlobal, nextIsGlobal, ValidationId.globalDocumentChange.value()));
            }
        });
    }
}

