/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.metricsproxy;

import ai.vespa.metricsproxy.core.ConsumersConfig;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import com.yahoo.vespa.model.admin.monitoring.VespaMetricsConsumer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class ConsumersConfigGenerator {
    ConsumersConfigGenerator() {
    }

    static List<ConsumersConfig.Consumer.Builder> generateConsumers(MetricsConsumer defaultConsumer, Map<String, MetricsConsumer> userConsumers) {
        LinkedHashMap<String, MetricsConsumer> allConsumers = new LinkedHashMap<String, MetricsConsumer>(userConsumers);
        allConsumers.put(VespaMetricsConsumer.VESPA_CONSUMER_ID, ConsumersConfigGenerator.combineConsumers(defaultConsumer, allConsumers.get(VespaMetricsConsumer.VESPA_CONSUMER_ID)));
        return allConsumers.values().stream().map(ConsumersConfigGenerator::toConsumerBuilder).collect(Collectors.toList());
    }

    private static MetricsConsumer combineConsumers(MetricsConsumer original, MetricsConsumer overriding) {
        if (overriding == null) {
            return original;
        }
        return ConsumersConfigGenerator.addMetrics(original, overriding.getMetrics());
    }

    static MetricsConsumer addMetrics(MetricsConsumer original, Map<String, Metric> metrics) {
        if (metrics == null) {
            return original;
        }
        LinkedHashMap<String, Metric> combinedMetrics = new LinkedHashMap<String, Metric>(original.getMetrics());
        metrics.forEach((name, newMetric) -> combinedMetrics.put((String)name, ConsumersConfigGenerator.combineMetrics(original.getMetrics().get(name), newMetric)));
        return new MetricsConsumer(original.getId(), new MetricSet(original.getMetricSet().getId(), combinedMetrics.values()));
    }

    private static Metric combineMetrics(@Nullable Metric original, Metric newMetric) {
        return original != null ? newMetric.addDimensionsFrom(original) : newMetric;
    }

    static ConsumersConfig.Consumer.Builder toConsumerBuilder(MetricsConsumer consumer) {
        ConsumersConfig.Consumer.Builder builder = new ConsumersConfig.Consumer.Builder().name(consumer.getId());
        consumer.getMetrics().values().forEach(metric -> builder.metric(ConsumersConfigGenerator.toConsumerMetricBuilder(metric)));
        return builder;
    }

    private static ConsumersConfig.Consumer.Metric.Builder toConsumerMetricBuilder(Metric metric) {
        ConsumersConfig.Consumer.Metric.Builder builder = new ConsumersConfig.Consumer.Metric.Builder().name(metric.name).outputname(metric.outputName).description(metric.description);
        metric.dimensions.forEach((name, value) -> builder.dimension(ConsumersConfigGenerator.toMetricDimensionBuilder(name, value)));
        return builder;
    }

    private static ConsumersConfig.Consumer.Metric.Dimension.Builder toMetricDimensionBuilder(String name, String value) {
        return new ConsumersConfig.Consumer.Metric.Dimension.Builder().key(name).value(value);
    }
}

