/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.config.search.core.ProtonConfig;
import java.util.Optional;

public class ResourceLimits
implements ProtonConfig.Producer {
    private final Optional<Double> diskLimit;
    private final Optional<Double> memoryLimit;

    private ResourceLimits(Builder builder) {
        this.diskLimit = builder.diskLimit;
        this.memoryLimit = builder.memoryLimit;
    }

    public void getConfig(ProtonConfig.Builder builder) {
        ProtonConfig.Writefilter.Builder writeFilterBuilder = new ProtonConfig.Writefilter.Builder();
        if (this.diskLimit.isPresent()) {
            writeFilterBuilder.disklimit(this.diskLimit.get().doubleValue());
        }
        if (this.memoryLimit.isPresent()) {
            writeFilterBuilder.memorylimit(this.memoryLimit.get().doubleValue());
        }
        builder.writefilter(writeFilterBuilder);
    }

    public static class Builder {
        private Optional<Double> diskLimit = Optional.empty();
        private Optional<Double> memoryLimit = Optional.empty();

        public ResourceLimits build() {
            return new ResourceLimits(this);
        }

        public Builder setDiskLimit(double diskLimit) {
            this.diskLimit = Optional.of(diskLimit);
            return this;
        }

        public Builder setMemoryLimit(double memoryLimit) {
            this.memoryLimit = Optional.of(memoryLimit);
            return this;
        }
    }
}

