/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import ai.vespa.rankingexpression.importer.configmodelview.MlModelImporter;
import com.google.inject.Inject;
import com.yahoo.component.Version;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.ConfigModelRegistry;
import com.yahoo.config.model.MapConfigModelRegistry;
import com.yahoo.config.model.NullConfigModelRegistry;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ConfigModelPlugin;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ModelCreateResult;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.application.provider.ApplicationPackageXmlFilesValidator;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.TransientException;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class VespaModelFactory
implements ModelFactory {
    private static final Logger log = Logger.getLogger(VespaModelFactory.class.getName());
    private final ConfigModelRegistry configModelRegistry;
    private final Collection<MlModelImporter> modelImporters;
    private final Zone zone;
    private final Clock clock;
    private final Version version;

    @Inject
    public VespaModelFactory(ComponentRegistry<ConfigModelPlugin> pluginRegistry, ComponentRegistry<MlModelImporter> modelImporters, Zone zone) {
        this.version = new Version(7, 74, 17);
        ArrayList<ConfigModelBuilder> modelBuilders = new ArrayList<ConfigModelBuilder>();
        for (ConfigModelPlugin plugin : pluginRegistry.allComponents()) {
            if (!(plugin instanceof ConfigModelBuilder)) continue;
            modelBuilders.add((ConfigModelBuilder)plugin);
        }
        this.configModelRegistry = new MapConfigModelRegistry(modelBuilders);
        this.modelImporters = modelImporters.allComponents();
        this.zone = zone;
        this.clock = Clock.systemUTC();
    }

    public VespaModelFactory(ConfigModelRegistry configModelRegistry) {
        this(configModelRegistry, Clock.systemUTC());
    }

    public VespaModelFactory(ConfigModelRegistry configModelRegistry, Clock clock) {
        this(new Version(7, 74, 17), configModelRegistry, clock);
    }

    public VespaModelFactory(Version version, ConfigModelRegistry configModelRegistry, Clock clock) {
        this.version = version;
        if (configModelRegistry == null) {
            this.configModelRegistry = new NullConfigModelRegistry();
            log.info("Will not load config models from plugins, as no registry is available");
        } else {
            this.configModelRegistry = configModelRegistry;
        }
        this.modelImporters = Collections.emptyList();
        this.zone = Zone.defaultZone();
        this.clock = clock;
    }

    public Version version() {
        return this.version;
    }

    public Model createModel(ModelContext modelContext) {
        return this.buildModel(this.createDeployState(modelContext, new ValidationParameters(ValidationParameters.IgnoreValidationErrors.TRUE)));
    }

    public ModelCreateResult createAndValidateModel(ModelContext modelContext, ValidationParameters validationParameters) {
        this.validateXml(modelContext, validationParameters.ignoreValidationErrors());
        DeployState deployState = this.createDeployState(modelContext, validationParameters);
        VespaModel model = this.buildModel(deployState);
        List<ConfigChangeAction> changeActions = this.validateModel(model, deployState, validationParameters);
        return new ModelCreateResult((Model)model, changeActions);
    }

    private void validateXml(ModelContext modelContext, boolean ignoreValidationErrors) {
        if (modelContext.appDir().isPresent()) {
            ApplicationPackageXmlFilesValidator validator = ApplicationPackageXmlFilesValidator.create((File)((File)modelContext.appDir().get()), (Version)modelContext.modelVespaVersion());
            try {
                validator.checkApplication();
                validator.checkIncludedDirs(modelContext.applicationPackage());
            }
            catch (IllegalArgumentException e) {
                VespaModelFactory.rethrowUnlessIgnoreErrors(e, ignoreValidationErrors);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.validateXML(modelContext.applicationPackage(), ignoreValidationErrors);
        }
    }

    private VespaModel buildModel(DeployState deployState) {
        try {
            return new VespaModel(this.configModelRegistry, deployState);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private DeployState createDeployState(ModelContext modelContext, ValidationParameters validationParameters) {
        DeployState.Builder builder = new DeployState.Builder().applicationPackage(modelContext.applicationPackage()).deployLogger(modelContext.deployLogger()).configDefinitionRepo(modelContext.configDefinitionRepo()).fileRegistry(modelContext.getFileRegistry()).permanentApplicationPackage(modelContext.permanentApplicationPackage()).properties(modelContext.properties()).vespaVersion(this.version()).modelHostProvisioner(VespaModelFactory.createHostProvisioner(modelContext)).rotations(modelContext.properties().rotations()).endpoints(modelContext.properties().endpoints()).modelImporters(this.modelImporters).zone(this.zone).now(this.clock.instant()).wantedNodeVespaVersion(modelContext.wantedNodeVespaVersion());
        modelContext.previousModel().ifPresent(builder::previousModel);
        return builder.build(validationParameters);
    }

    private static HostProvisioner createHostProvisioner(ModelContext modelContext) {
        return modelContext.hostProvisioner().orElse(DeployState.getDefaultModelHostProvisioner(modelContext.applicationPackage()));
    }

    private void validateXML(ApplicationPackage applicationPackage, boolean ignoreValidationErrors) {
        try {
            applicationPackage.validateXML();
        }
        catch (IllegalArgumentException e) {
            VespaModelFactory.rethrowUnlessIgnoreErrors(e, ignoreValidationErrors);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<ConfigChangeAction> validateModel(VespaModel model, DeployState deployState, ValidationParameters validationParameters) {
        try {
            return Validation.validate(model, validationParameters, deployState);
        }
        catch (TransientException | IllegalArgumentException e) {
            VespaModelFactory.rethrowUnlessIgnoreErrors((RuntimeException)e, validationParameters.ignoreValidationErrors());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<ConfigChangeAction>();
    }

    private static void rethrowUnlessIgnoreErrors(RuntimeException e, boolean ignoreValidationErrors) {
        if (!ignoreValidationErrors) {
            throw e;
        }
    }
}

