/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import java.util.Map;
import java.util.Optional;

public class NodesSpecification {
    private final boolean dedicated;
    private final int count;
    private final int groups;
    private Version version;
    private final boolean required;
    private final boolean canFail;
    private final boolean exclusive;
    private final Optional<NodeResources> resources;
    private final Optional<String> dockerImage;

    private NodesSpecification(boolean dedicated, int count, int groups, Version version, boolean required, boolean canFail, boolean exclusive, Optional<NodeResources> resources, Optional<String> dockerImage) {
        this.dedicated = dedicated;
        this.count = count;
        this.groups = groups;
        this.version = version;
        this.required = required;
        this.canFail = canFail;
        this.exclusive = exclusive;
        this.resources = resources;
        this.dockerImage = dockerImage;
    }

    private NodesSpecification(boolean dedicated, boolean canFail, Version version, ModelElement nodesElement) {
        this(dedicated, nodesElement.requiredIntegerAttribute("count"), nodesElement.integerAttribute("groups", 1), version, nodesElement.booleanAttribute("required", false), canFail, nodesElement.booleanAttribute("exclusive", false), NodesSpecification.getFlavor(nodesElement), Optional.ofNullable(nodesElement.stringAttribute("docker-image")));
    }

    public static NodesSpecification from(ModelElement nodesElement, ConfigModelContext context) {
        return new NodesSpecification(true, !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement);
    }

    public static Optional<NodesSpecification> fromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.child("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(NodesSpecification.from(nodesElement, context));
    }

    public static Optional<NodesSpecification> optionalDedicatedFromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.child("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(new NodesSpecification(nodesElement.booleanAttribute("dedicated", false), !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement));
    }

    public static NodesSpecification nonDedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(false, count, 1, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, Optional.empty(), Optional.empty());
    }

    public static NodesSpecification dedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(true, count, 1, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, Optional.empty(), Optional.empty());
    }

    public boolean isDedicated() {
        return this.dedicated;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int count() {
        return this.count;
    }

    public int groups() {
        return this.groups;
    }

    public Map<HostResource, ClusterMembership> provision(HostSystem hostSystem, ClusterSpec.Type clusterType, ClusterSpec.Id clusterId, DeployLogger logger) {
        ClusterSpec cluster = ClusterSpec.request((ClusterSpec.Type)clusterType, (ClusterSpec.Id)clusterId, (Version)this.version, (boolean)this.exclusive);
        return hostSystem.allocateHosts(cluster, Capacity.fromCount((int)this.count, this.resources, (boolean)this.required, (boolean)this.canFail), this.groups, logger);
    }

    private static Optional<NodeResources> getFlavor(ModelElement nodesElement) {
        ModelElement resources = nodesElement.child("resources");
        if (resources != null) {
            return Optional.of(new NodeResources(resources.requiredDoubleAttribute("vcpu"), NodesSpecification.parseGbAmount(resources.requiredStringAttribute("memory")), NodesSpecification.parseGbAmount(resources.requiredStringAttribute("disk")), NodesSpecification.parseOptionalDiskSpeed(resources.stringAttribute("disk-speed"))));
        }
        if (nodesElement.stringAttribute("flavor") != null) {
            return Optional.of(NodeResources.fromLegacyName((String)nodesElement.stringAttribute("flavor")));
        }
        return Optional.empty();
    }

    private static double parseGbAmount(String byteAmount) {
        byteAmount = byteAmount.strip();
        if ((byteAmount = byteAmount.toUpperCase()).endsWith("B")) {
            byteAmount = byteAmount.substring(0, byteAmount.length() - 1);
        }
        double multiplier = 1.0 / Math.pow(1000.0, 3.0);
        if (byteAmount.endsWith("K")) {
            multiplier = 1.0 / Math.pow(1000.0, 2.0);
        } else if (byteAmount.endsWith("M")) {
            multiplier = 0.0;
        } else if (byteAmount.endsWith("G")) {
            multiplier = 1.0;
        } else if (byteAmount.endsWith("T")) {
            multiplier = 1000.0;
        } else if (byteAmount.endsWith("P")) {
            multiplier = Math.pow(1000.0, 2.0);
        } else if (byteAmount.endsWith("E")) {
            multiplier = Math.pow(1000.0, 3.0);
        } else if (byteAmount.endsWith("Z")) {
            multiplier = Math.pow(1000.0, 4.0);
        } else if (byteAmount.endsWith("Y")) {
            multiplier = Math.pow(1000.0, 5.0);
        }
        byteAmount = byteAmount.substring(0, byteAmount.length() - 1).strip();
        try {
            return Double.parseDouble(byteAmount) * multiplier;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid byte amount '" + byteAmount + "': Must be a floating point number optionally followed by k, M, G, T, P, E, Z or Y");
        }
    }

    private static NodeResources.DiskSpeed parseOptionalDiskSpeed(String diskSpeedString) {
        if (diskSpeedString == null) {
            return NodeResources.DiskSpeed.fast;
        }
        switch (diskSpeedString) {
            case "fast": {
                return NodeResources.DiskSpeed.fast;
            }
            case "slow": {
                return NodeResources.DiskSpeed.slow;
            }
            case "any": {
                return NodeResources.DiskSpeed.any;
            }
        }
        throw new IllegalArgumentException("Illegal disk-speed value '" + diskSpeedString + "': Legal values are 'fast', 'slow' and 'any')");
    }

    public String toString() {
        return "specification of " + this.count + (this.dedicated ? " dedicated " : " ") + "nodes" + (String)(this.resources.isPresent() ? " with resources " + this.resources.get() : "") + (String)(this.groups > 1 ? " in " + this.groups + " groups" : "");
    }
}

