/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

public class TuningDispatch {
    private final Integer maxHitsPerPartition;
    private final DispatchPolicy dispatchPolicy;
    private final Boolean useLocalNode;
    private final Double minGroupCoverage;
    private final Double minActiveDocsCoverage;

    private TuningDispatch(Builder builder) {
        this.maxHitsPerPartition = builder.maxHitsPerPartition;
        this.dispatchPolicy = builder.dispatchPolicy;
        this.useLocalNode = builder.useLocalNode;
        this.minGroupCoverage = builder.minGroupCoverage;
        this.minActiveDocsCoverage = builder.minActiveDocsCoverage;
    }

    public Integer getMaxHitsPerPartition() {
        return this.maxHitsPerPartition;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public Boolean getUseLocalNode() {
        return this.useLocalNode;
    }

    public Double getMinGroupCoverage() {
        return this.minGroupCoverage;
    }

    public Double getMinActiveDocsCoverage() {
        return this.minActiveDocsCoverage;
    }

    public static class Builder {
        private Integer maxHitsPerPartition;
        private DispatchPolicy dispatchPolicy;
        private Boolean useLocalNode;
        private Double minGroupCoverage;
        private Double minActiveDocsCoverage;

        public TuningDispatch build() {
            return new TuningDispatch(this);
        }

        public Builder setMaxHitsPerPartition(Integer maxHitsPerPartition) {
            this.maxHitsPerPartition = maxHitsPerPartition;
            return this;
        }

        public Builder setDispatchPolicy(String policy) {
            if (policy != null) {
                this.dispatchPolicy = "random".equals(policy.toLowerCase()) ? DispatchPolicy.ADAPTIVE : ("round-robin".equals(policy.toLowerCase()) ? DispatchPolicy.ROUNDROBIN : DispatchPolicy.valueOf(policy.toUpperCase()));
            }
            return this;
        }

        public Builder setUseLocalNode(Boolean useLocalNode) {
            this.useLocalNode = useLocalNode;
            return this;
        }

        public Builder setMinGroupCoverage(Double minGroupCoverage) {
            this.minGroupCoverage = minGroupCoverage;
            return this;
        }

        public Builder setMinActiveDocsCoverage(Double minCoverage) {
            this.minActiveDocsCoverage = minCoverage;
            return this;
        }
    }

    public static enum DispatchPolicy {
        ROUNDROBIN,
        ADAPTIVE;

    }
}

