/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.BinaryUnit;
import com.yahoo.vespa.model.utils.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class ModelElement {
    private final Element xml;

    public ModelElement(Element xml) {
        this.xml = xml;
        if (xml == null) {
            throw new NullPointerException("Can not create ModelElement with null element");
        }
        if (xml.getNodeName() == null) {
            throw new NullPointerException("Can not create ModelElement with unnamed element");
        }
    }

    public Element getXml() {
        return this.xml;
    }

    public ModelElement getChild(String name) {
        Element e = XML.getChild((Element)this.xml, (String)name);
        if (e != null) {
            return new ModelElement(e);
        }
        return null;
    }

    public List<ModelElement> getChildren(String name) {
        List e = XML.getChildren((Element)this.xml, (String)name);
        ArrayList<ModelElement> list = new ArrayList<ModelElement>();
        e.forEach(element -> list.add(new ModelElement((Element)element)));
        return list;
    }

    public ModelElement getChildByPath(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        ModelElement curElem = this;
        while (tokenizer.hasMoreTokens() && curElem != null) {
            String pathElem = tokenizer.nextToken();
            ModelElement child = curElem.getChild(pathElem);
            if (!tokenizer.hasMoreTokens() && child != null) {
                return child;
            }
            curElem = child;
        }
        return null;
    }

    public String childAsString(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        ModelElement curElem = this;
        while (tokenizer.hasMoreTokens() && curElem != null) {
            String pathElem = tokenizer.nextToken();
            ModelElement child = curElem.getChild(pathElem);
            if (!tokenizer.hasMoreTokens()) {
                String attr = curElem.getStringAttribute(pathElem);
                if (attr != null) {
                    return attr;
                }
                if (child != null) {
                    return child.asString();
                }
            }
            curElem = child;
        }
        return null;
    }

    public String asString() {
        return this.xml.getFirstChild().getTextContent();
    }

    public double asDouble() {
        return Double.parseDouble(this.asString());
    }

    public long asLong() {
        return (long)BinaryUnit.valueOf(this.asString());
    }

    public Duration asDuration() {
        return new Duration(this.asString());
    }

    public Long childAsLong(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return Long.parseLong(child.trim());
    }

    public Integer childAsInteger(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return Integer.parseInt(child.trim());
    }

    public Double childAsDouble(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return Double.parseDouble(child.trim());
    }

    public Boolean childAsBoolean(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return Boolean.parseBoolean(child.trim());
    }

    public Duration childAsDuration(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return new Duration(child);
    }

    public int requiredIntegerAttribute(String name) {
        if (this.getStringAttribute(name) == null) {
            throw new IllegalArgumentException("Required attribute '" + name + "' is missing");
        }
        return this.getIntegerAttribute(name, null);
    }

    public Integer getIntegerAttribute(String name) {
        return this.getIntegerAttribute(name, null);
    }

    public Integer getIntegerAttribute(String name, Integer defaultValue) {
        String value = this.getStringAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return (int)BinaryUnit.valueOf(value);
    }

    public boolean getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, false);
    }

    public boolean getBooleanAttribute(String name, boolean defaultValue) {
        String value = this.getStringAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public Long getLongAttribute(String name) {
        String value = this.getStringAttribute(name);
        if (value == null) {
            return null;
        }
        return (long)BinaryUnit.valueOf(value);
    }

    public Double getDoubleAttribute(String name) {
        String value = this.getStringAttribute(name);
        if (value == null) {
            return null;
        }
        return Double.parseDouble(value);
    }

    public String getStringAttribute(String name) {
        if (!this.xml.hasAttribute(name)) {
            return null;
        }
        return this.xml.getAttribute(name);
    }

    public List<ModelElement> subElements(String name) {
        List elements = XML.getChildren((Element)this.xml, (String)name);
        ArrayList<ModelElement> helpers = new ArrayList<ModelElement>();
        for (Element e : elements) {
            helpers.add(new ModelElement(e));
        }
        return helpers;
    }

    public String toString() {
        return this.xml.getNodeName();
    }
}

