/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring;

import com.google.common.collect.ImmutableSet;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultPublicMetrics {
    public static MetricSet defaultPublicMetricSet = DefaultPublicMetrics.createMetricSet();

    private static MetricSet createMetricSet() {
        return new MetricSet("public", DefaultPublicMetrics.getAllMetrics(), Collections.emptyList());
    }

    private static Set<Metric> getAllMetrics() {
        return ImmutableSet.builder().addAll(DefaultPublicMetrics.getContainerMetrics()).addAll(DefaultPublicMetrics.getQrserverMetrics()).build();
    }

    private static Set<Metric> getContainerMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        metrics.add(new Metric("http.status.1xx.rate"));
        metrics.add(new Metric("http.status.2xx.rate"));
        metrics.add(new Metric("http.status.3xx.rate"));
        metrics.add(new Metric("http.status.4xx.rate"));
        metrics.add(new Metric("http.status.5xx.rate"));
        metrics.add(new Metric("jdisc.gc.ms.average"));
        metrics.add(new Metric("mem.heap.free.average"));
        return metrics;
    }

    private static Set<Metric> getQrserverMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        metrics.add(new Metric("queries.rate"));
        metrics.add(new Metric("query_latency.average"));
        metrics.add(new Metric("query_latency.95percentile"));
        metrics.add(new Metric("query_latency.99percentile"));
        metrics.add(new Metric("hits_per_query.average"));
        metrics.add(new Metric("totalhits_per_query.average"));
        metrics.add(new Metric("degraded_queries.rate"));
        metrics.add(new Metric("failed_queries.rate"));
        metrics.add(new Metric("serverActiveThreads.average"));
        return metrics;
    }

    private DefaultPublicMetrics() {
    }
}

