/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.ClearStateExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.GuardExpression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.PassthroughExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ZCurveExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class IndexingScript
extends Derived
implements IlscriptsConfig.Producer {
    private final List<String> docFields = new ArrayList<String>();
    private final List<Expression> expressions = new ArrayList<Expression>();

    public IndexingScript(Search search) {
        this.derive(search);
    }

    @Override
    protected void derive(ImmutableSDField field, Search search) {
        if (field.isImportedField()) {
            return;
        }
        if (field.hasFullIndexingDocprocRights()) {
            this.docFields.add(field.getName());
        }
        if (field.usesStructOrMap() && !field.getDataType().equals((Object)PositionDataType.INSTANCE) && !field.getDataType().equals((Object)DataType.getArray((DataType)PositionDataType.INSTANCE))) {
            return;
        }
        ScriptExpression script = field.getIndexingScript();
        if (!script.isEmpty()) {
            this.expressions.add((Expression)new StatementExpression(new Expression[]{new ClearStateExpression(), new GuardExpression((Expression)script)}));
        }
    }

    public Iterable<Expression> expressions() {
        return Collections.unmodifiableCollection(this.expressions);
    }

    @Override
    public String getDerivedName() {
        return "ilscripts";
    }

    public void getConfig(IlscriptsConfig.Builder configBuilder) {
        IlscriptsConfig.Ilscript.Builder ilscriptBuilder = new IlscriptsConfig.Ilscript.Builder();
        ilscriptBuilder.doctype(this.getName());
        ilscriptBuilder.docfield(this.docFields);
        this.addContentInOrder(ilscriptBuilder);
        configBuilder.ilscript(ilscriptBuilder);
    }

    private void addContentInOrder(IlscriptsConfig.Ilscript.Builder ilscriptBuilder) {
        ArrayList<Expression> later = new ArrayList<Expression>();
        HashSet<String> touchedFields = new HashSet<String>();
        for (Expression exp : this.expressions) {
            FieldScanVisitor fieldFetcher = new FieldScanVisitor();
            if (this.modifiesSelf(exp)) {
                later.add(exp);
            } else {
                ilscriptBuilder.content(exp.toString());
            }
            fieldFetcher.visit(exp);
            touchedFields.addAll(fieldFetcher.touchedFields());
        }
        for (Expression exp : later) {
            ilscriptBuilder.content(exp.toString());
        }
        this.generateSyntheticStatementsForUntouchedFields(ilscriptBuilder, touchedFields);
    }

    private void generateSyntheticStatementsForUntouchedFields(IlscriptsConfig.Ilscript.Builder ilscriptBuilder, Set<String> touchedFields) {
        HashSet<String> fieldsWithSyntheticStatements = new HashSet<String>(this.docFields);
        fieldsWithSyntheticStatements.removeAll(touchedFields);
        ArrayList<String> orderedFields = new ArrayList<String>(fieldsWithSyntheticStatements);
        Collections.sort(orderedFields);
        for (String fieldName : orderedFields) {
            StatementExpression copyField = new StatementExpression(new Expression[]{new InputExpression(fieldName), new PassthroughExpression(fieldName)});
            ilscriptBuilder.content(copyField.toString());
        }
    }

    private boolean modifiesSelf(Expression exp) {
        MyExpVisitor visitor = new MyExpVisitor();
        visitor.visit(exp);
        return visitor.modifiesSelf();
    }

    private static class FieldScanVisitor
    extends ExpressionVisitor {
        List<String> touchedFields = new ArrayList<String>();
        List<String> candidates = new ArrayList<String>();

        private FieldScanVisitor() {
        }

        protected void doVisit(Expression exp) {
            if (exp instanceof OutputExpression) {
                this.touchedFields.add(((OutputExpression)exp).getFieldName());
            }
            if (exp instanceof InputExpression) {
                this.candidates.add(((InputExpression)exp).getFieldName());
            }
            if (exp instanceof ZCurveExpression) {
                this.touchedFields.addAll(this.candidates);
            }
        }

        Collection<String> touchedFields() {
            List<String> output = this.touchedFields;
            this.touchedFields = null;
            return output;
        }
    }

    private class MyExpVisitor
    extends ExpressionVisitor {
        private String inputField = null;
        private String outputField = null;

        private MyExpVisitor() {
        }

        public boolean modifiesSelf() {
            return this.outputField != null && this.outputField.equals(this.inputField);
        }

        protected void doVisit(Expression expression) {
            if (this.modifiesSelf()) {
                return;
            }
            if (expression instanceof InputExpression) {
                this.inputField = ((InputExpression)expression).getFieldName();
            }
            if (expression instanceof OutputExpression) {
                this.outputField = ((OutputExpression)expression).getFieldName();
            }
        }
    }
}

