/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import java.util.Optional;
import java.util.regex.Pattern;

public class FeatureNames {
    private static final Pattern identifierRegexp = Pattern.compile("[A-Za-z0-9_][A-Za-z0-9_-]*");

    public static Reference asConstantFeature(String constantName) {
        return Reference.simple((String)"constant", (String)FeatureNames.quoteIfNecessary(constantName));
    }

    public static Reference asAttributeFeature(String attributeName) {
        return Reference.simple((String)"attribute", (String)FeatureNames.quoteIfNecessary(attributeName));
    }

    public static Reference asQueryFeature(String propertyName) {
        return Reference.simple((String)"query", (String)FeatureNames.quoteIfNecessary(propertyName));
    }

    public static boolean isSimpleFeature(Reference reference) {
        if (!reference.isSimple()) {
            return false;
        }
        String name = reference.name();
        return name.equals("attribute") || name.equals("constant") || name.equals("query");
    }

    public static boolean isConstantFeature(Reference reference) {
        if (!FeatureNames.isSimpleFeature(reference)) {
            return false;
        }
        return reference.name().equals("constant");
    }

    public static Optional<String> argumentOf(String feature) {
        Optional reference = Reference.simple((String)feature);
        if (!reference.isPresent()) {
            return Optional.empty();
        }
        if (!(((Reference)reference.get()).name().equals("attribute") || ((Reference)reference.get()).name().equals("constant") || ((Reference)reference.get()).name().equals("query"))) {
            return Optional.empty();
        }
        return Optional.of(((ExpressionNode)((Reference)reference.get()).arguments().expressions().get(0)).toString());
    }

    private static String quoteIfNecessary(String s) {
        if (identifierRegexp.matcher(s).matches()) {
            return s;
        }
        return "\"" + s + "\"";
    }
}

