/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.metricsproxy;

import ai.vespa.metricsproxy.core.ConsumersConfig;
import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.core.MonitoringConfig;
import ai.vespa.metricsproxy.core.VespaMetrics;
import ai.vespa.metricsproxy.http.GenericMetricsHandler;
import ai.vespa.metricsproxy.metric.ExternalMetrics;
import ai.vespa.metricsproxy.metric.dimensions.ApplicationDimensions;
import ai.vespa.metricsproxy.metric.dimensions.ApplicationDimensionsConfig;
import ai.vespa.metricsproxy.rpc.RpcServer;
import ai.vespa.metricsproxy.service.ConfigSentinelClient;
import ai.vespa.metricsproxy.service.SystemPollerProvider;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.metricsproxy.ConsumersConfigGenerator;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsProxyContainer;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.admin.monitoring.VespaMetricsConsumer;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.xml.BundleMapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class MetricsProxyContainerCluster
extends ContainerCluster<MetricsProxyContainer>
implements ApplicationDimensionsConfig.Producer,
ConsumersConfig.Producer,
MonitoringConfig.Producer,
QrStartConfig.Producer {
    public static final Logger log = Logger.getLogger(MetricsProxyContainerCluster.class.getName());
    private static final String METRICS_PROXY_NAME = "metrics-proxy";
    static final Path METRICS_PROXY_BUNDLE_FILE = BundleMapper.absoluteBundlePath(Paths.get("metrics-proxy" + BundleMapper.JarSuffix.JAR_WITH_DEPS.suffix, new String[0]));
    static final String METRICS_PROXY_BUNDLE_NAME = "com.yahoo.vespa.metrics-proxy";
    private static final String METRICS_HANDLER_BINDING = "/metrics/v1/values";
    private final AbstractConfigProducer<?> parent;
    private final ApplicationId applicationId;

    public MetricsProxyContainerCluster(AbstractConfigProducer<?> parent, String name, DeployState deployState) {
        super(parent, name, name, deployState);
        this.parent = parent;
        this.applicationId = deployState.getProperties().applicationId();
        this.setMessageBusEnabled(false);
        this.setRpcServerEnabled(true);
        this.addDefaultHandlersExceptStatus();
        this.addPlatformBundle(METRICS_PROXY_BUNDLE_FILE);
        this.addClusterComponents();
        this.addGenericMetricsHandler();
    }

    private void addClusterComponents() {
        this.addMetricsProxyComponent(ApplicationDimensions.class);
        this.addMetricsProxyComponent(ConfigSentinelClient.class);
        this.addMetricsProxyComponent(ExternalMetrics.class);
        this.addMetricsProxyComponent(MetricsConsumers.class);
        this.addMetricsProxyComponent(MetricsManager.class);
        this.addMetricsProxyComponent(RpcServer.class);
        this.addMetricsProxyComponent(SystemPollerProvider.class);
        this.addMetricsProxyComponent(VespaMetrics.class);
    }

    private void addGenericMetricsHandler() {
        Handler metricsHandler = new Handler(new ComponentModel(GenericMetricsHandler.class.getName(), null, METRICS_PROXY_BUNDLE_NAME, null));
        metricsHandler.addServerBindings("http://*/metrics/v1/values", "http://*/metrics/v1/values/*");
        this.addComponent(metricsHandler);
    }

    @Override
    protected void doPrepare(DeployState deployState) {
    }

    public void getConfig(MonitoringConfig.Builder builder) {
        this.getSystemName().ifPresent(arg_0 -> ((MonitoringConfig.Builder)builder).systemName(arg_0));
        this.getIntervalMinutes().ifPresent(arg_0 -> ((MonitoringConfig.Builder)builder).intervalMinutes(arg_0));
    }

    public void getConfig(ConsumersConfig.Builder builder) {
        MetricsConsumer amendedDefaultConsumer = ConsumersConfigGenerator.addMetrics(VespaMetricsConsumer.getVespaMetricsConsumer(), this.getAdditionalDefaultMetrics().getMetrics());
        builder.consumer.addAll(ConsumersConfigGenerator.generateConsumers(amendedDefaultConsumer, this.getUserMetricsConsumers()));
    }

    public void getConfig(ApplicationDimensionsConfig.Builder builder) {
        if (this.isHostedVespa()) {
            builder.dimensions(this.applicationDimensions());
        }
    }

    @Override
    public void getConfig(QrStartConfig.Builder builder) {
        super.getConfig(builder);
        builder.jvm.verbosegc(false);
    }

    private MetricSet getAdditionalDefaultMetrics() {
        return this.getAdmin().map(Admin::getAdditionalDefaultMetrics).orElse(MetricSet.emptyMetricSet());
    }

    private Map<String, MetricsConsumer> getUserMetricsConsumers() {
        return this.getAdmin().map(admin -> admin.getUserMetrics().getConsumers()).orElse(Collections.emptyMap());
    }

    private Optional<Admin> getAdmin() {
        AbstractConfigProducerRoot r;
        if (this.parent != null && (r = this.parent.getRoot()) instanceof VespaModel) {
            VespaModel model = (VespaModel)r;
            return Optional.ofNullable(model.getAdmin());
        }
        return Optional.empty();
    }

    private Optional<String> getSystemName() {
        Monitoring monitoring = this.getMonitoringService();
        return monitoring != null && !monitoring.getClustername().equals("") ? Optional.of(monitoring.getClustername()) : Optional.empty();
    }

    private Optional<Integer> getIntervalMinutes() {
        Monitoring monitoring = this.getMonitoringService();
        return monitoring != null ? Optional.of(monitoring.getInterval()) : Optional.empty();
    }

    private void addMetricsProxyComponent(Class<?> componentClass) {
        this.addSimpleComponent(componentClass.getName(), null, METRICS_PROXY_BUNDLE_NAME);
    }

    private Map<String, String> applicationDimensions() {
        LinkedHashMap<String, String> dimensions = new LinkedHashMap<String, String>();
        dimensions.put("zone", MetricsProxyContainerCluster.zoneString(this.getZone()));
        dimensions.put("applicationId", MetricsProxyContainerCluster.serializeWithDots(this.applicationId));
        dimensions.put("tenantName", this.applicationId.tenant().value());
        dimensions.put("applicationName", this.applicationId.application().value());
        dimensions.put("instanceName", this.applicationId.instance().value());
        dimensions.put("app", this.applicationId.application().value() + "." + this.applicationId.instance().value());
        return dimensions;
    }

    private static String serializeWithDots(ApplicationId applicationId) {
        return applicationId.serializedForm().replace(':', '.');
    }

    static String zoneString(Zone zone) {
        return zone.environment().value() + "." + zone.region().value();
    }

    static final class AppDimensionNames {
        static final String ZONE = "zone";
        static final String APPLICATION_ID = "applicationId";
        static final String TENANT = "tenantName";
        static final String APPLICATION = "applicationName";
        static final String INSTANCE = "instanceName";
        static final String LEGACY_APPLICATION = "app";

        AppDimensionNames() {
        }
    }
}

