/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.google.common.collect.ImmutableList;
import com.yahoo.component.Version;
import com.yahoo.config.application.Xml;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.NodeType;
import com.yahoo.config.provision.Rotation;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.Zone;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.rendering.RendererRegistry;
import com.yahoo.searchdefinition.derived.RankProfileList;
import com.yahoo.text.XML;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.DomClientProviderBuilder;
import com.yahoo.vespa.model.builder.xml.dom.DomComponentBuilder;
import com.yahoo.vespa.model.builder.xml.dom.DomHandlerBuilder;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.builder.xml.dom.ServletBuilder;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.docproc.DomDocprocChainsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.processing.DomProcessingBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.DomSearchChainsBuilder;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.ContainerModelEvaluation;
import com.yahoo.vespa.model.container.IdentityProvider;
import com.yahoo.vespa.model.container.SecretStore;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.FileStatusHandlerComponent;
import com.yahoo.vespa.model.container.component.Servlet;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.xml.HttpBuilder;
import com.yahoo.vespa.model.container.jersey.RestApi;
import com.yahoo.vespa.model.container.jersey.xml.RestApiBuilder;
import com.yahoo.vespa.model.container.processing.ProcessingChains;
import com.yahoo.vespa.model.container.search.ContainerSearch;
import com.yahoo.vespa.model.container.search.GUIHandler;
import com.yahoo.vespa.model.container.search.PageTemplates;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.container.xml.AccessLogBuilder;
import com.yahoo.vespa.model.container.xml.BundleMapper;
import com.yahoo.vespa.model.container.xml.ContainerServiceBuilder;
import com.yahoo.vespa.model.container.xml.DocprocOptionsBuilder;
import com.yahoo.vespa.model.container.xml.DocumentApiOptionsBuilder;
import com.yahoo.vespa.model.container.xml.document.DocumentFactoryBuilder;
import com.yahoo.vespa.model.content.StorageGroup;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContainerModelBuilder
extends ConfigModelBuilder<ContainerModel> {
    static final String HOSTED_VESPA_STATUS_FILE = Defaults.getDefaults().underVespaHome("var/vespa/load-balancer/status.html");
    private static final String HOSTED_VESPA_STATUS_FILE_SETTING = "VESPA_LB_STATUS_FILE";
    private static final String ENVIRONMENT_VARIABLES_ELEMENT = "environment-variables";
    private ApplicationPackage app;
    private final boolean standaloneBuilder;
    private final Networking networking;
    private final boolean rpcServerEnabled;
    private final boolean httpServerEnabled;
    protected DeployLogger log;
    public static final List<ConfigModelId> configModelIds = ImmutableList.of((Object)ConfigModelId.fromName("container"), (Object)ConfigModelId.fromName("jdisc"));
    private static final String xmlRendererId = RendererRegistry.xmlRendererId.getName();
    private static final String jsonRendererId = RendererRegistry.jsonRendererId.getName();

    public ContainerModelBuilder(boolean standaloneBuilder, Networking networking) {
        super(ContainerModel.class);
        this.standaloneBuilder = standaloneBuilder;
        this.networking = networking;
        this.rpcServerEnabled = !standaloneBuilder;
        this.httpServerEnabled = networking == Networking.enable;
    }

    @Override
    public List<ConfigModelId> handlesElements() {
        return configModelIds;
    }

    @Override
    public void doBuild(ContainerModel model, Element spec, ConfigModelContext modelContext) {
        this.app = modelContext.getApplicationPackage();
        this.checkVersion(spec);
        this.log = modelContext.getDeployLogger();
        ApplicationContainerCluster cluster = this.createContainerCluster(spec, modelContext);
        this.addClusterContent(cluster, spec, modelContext);
        this.addBundlesForPlatformComponents(cluster);
        cluster.setMessageBusEnabled(this.rpcServerEnabled);
        cluster.setRpcServerEnabled(this.rpcServerEnabled);
        cluster.setHttpServerEnabled(this.httpServerEnabled);
        model.setCluster(cluster);
    }

    private void addBundlesForPlatformComponents(ApplicationContainerCluster cluster) {
        for (Component<?, ?> component : cluster.getAllComponents()) {
            String componentClass = ((ComponentModel)component.model).bundleInstantiationSpec.getClassName();
            BundleMapper.getBundlePath(componentClass).ifPresent(cluster::addPlatformBundle);
        }
    }

    private ApplicationContainerCluster createContainerCluster(Element spec, final ConfigModelContext modelContext) {
        return (ApplicationContainerCluster)new VespaDomBuilder.DomConfigProducerBuilder<ApplicationContainerCluster>(){

            @Override
            protected ApplicationContainerCluster doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element producerSpec) {
                return new ApplicationContainerCluster(ancestor, modelContext.getProducerId(), modelContext.getProducerId(), deployState);
            }
        }.build(modelContext.getDeployState(), modelContext.getParentProducer(), spec);
    }

    private void addClusterContent(ApplicationContainerCluster cluster, Element spec, ConfigModelContext context) {
        DeployState deployState = context.getDeployState();
        DocumentFactoryBuilder.buildDocumentFactories(cluster, spec);
        this.addConfiguredComponents(deployState, cluster, spec);
        this.addSecretStore(cluster, spec);
        this.addHandlers(deployState, cluster, spec);
        this.addRestApis(deployState, spec, cluster);
        this.addServlets(deployState, spec, cluster);
        this.addModelEvaluation(spec, cluster, context);
        this.addProcessing(deployState, spec, cluster);
        this.addSearch(deployState, spec, cluster);
        this.addDocproc(deployState, spec, cluster);
        this.addDocumentApi(spec, cluster);
        cluster.addDefaultHandlersExceptStatus();
        this.addStatusHandlers(cluster, context.getDeployState().isHosted());
        this.addHttp(deployState, spec, cluster);
        this.addAccessLogs(deployState, cluster, spec);
        this.addRoutingAliases(cluster, spec, deployState.zone().environment());
        this.addNodes(cluster, spec, context);
        this.addClientProviders(deployState, spec, cluster);
        this.addServerProviders(deployState, spec, cluster);
        this.addAthensCopperArgos(cluster, context);
    }

    private void addSecretStore(ApplicationContainerCluster cluster, Element spec) {
        Element secretStoreElement = XML.getChild((Element)spec, (String)"secret-store");
        if (secretStoreElement != null) {
            SecretStore secretStore = new SecretStore();
            for (Element group : XML.getChildren((Element)secretStoreElement, (String)"group")) {
                secretStore.addGroup(group.getAttribute("name"), group.getAttribute("environment"));
            }
            cluster.setSecretStore(secretStore);
        }
    }

    private void addAthensCopperArgos(ApplicationContainerCluster cluster, ConfigModelContext context) {
        if (!context.getDeployState().isHosted()) {
            return;
        }
        this.app.getDeployment().map(DeploymentSpec::fromXml).ifPresent(deploymentSpec -> {
            this.addIdentityProvider(cluster, context.getDeployState().getProperties().configServerSpecs(), context.getDeployState().getProperties().loadBalancerName(), context.getDeployState().getProperties().ztsUrl(), context.getDeployState().getProperties().athenzDnsSuffix(), context.getDeployState().zone(), (DeploymentSpec)deploymentSpec);
            this.addRotationProperties(cluster, context.getDeployState().zone(), context.getDeployState().getRotations(), (DeploymentSpec)deploymentSpec);
        });
    }

    private void addRotationProperties(ApplicationContainerCluster cluster, Zone zone, Set<Rotation> rotations, DeploymentSpec spec) {
        cluster.getContainers().forEach(container -> {
            this.setRotations((Container)container, rotations, spec.globalServiceId(), cluster.getName());
            container.setProp("activeRotation", Boolean.toString(this.zoneHasActiveRotation(zone, spec)));
        });
    }

    private boolean zoneHasActiveRotation(Zone zone, DeploymentSpec spec) {
        return spec.zones().stream().anyMatch(declaredZone -> declaredZone.deploysTo(zone.environment(), Optional.of(zone.region())) && declaredZone.active());
    }

    private void setRotations(Container container, Set<Rotation> rotations, Optional<String> globalServiceId, String containerClusterName) {
        if (!rotations.isEmpty() && globalServiceId.isPresent() && containerClusterName.equals(globalServiceId.get())) {
            container.setProp("rotations", rotations.stream().map(Rotation::getId).collect(Collectors.joining(",")));
        }
    }

    private void addRoutingAliases(ApplicationContainerCluster cluster, Element spec, Environment environment) {
        if (environment != Environment.prod) {
            return;
        }
        Element aliases = XML.getChild((Element)spec, (String)"aliases");
        for (Element alias : XML.getChildren((Element)aliases, (String)"service-alias")) {
            cluster.serviceAliases().add(XML.getValue((Element)alias));
        }
        for (Element alias : XML.getChildren((Element)aliases, (String)"endpoint-alias")) {
            cluster.endpointAliases().add(XML.getValue((Element)alias));
        }
    }

    private void addConfiguredComponents(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        for (Element components : XML.getChildren((Element)spec, (String)"components")) {
            this.addIncludes(components);
            ContainerModelBuilder.addConfiguredComponents(deployState, cluster, components, "component");
        }
        ContainerModelBuilder.addConfiguredComponents(deployState, cluster, spec, "component");
    }

    protected void addStatusHandlers(ApplicationContainerCluster cluster, boolean isHostedVespa) {
        if (isHostedVespa) {
            String name = "status.html";
            Optional<String> statusFile = Optional.ofNullable(System.getenv(HOSTED_VESPA_STATUS_FILE_SETTING));
            cluster.addComponent(new FileStatusHandlerComponent(name + "-status-handler", statusFile.orElse(HOSTED_VESPA_STATUS_FILE), "http://*/" + name));
        } else {
            cluster.addVipHandler();
        }
    }

    private void addClientProviders(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        for (Element clientSpec : XML.getChildren((Element)spec, (String)"client")) {
            cluster.addComponent((Component)new DomClientProviderBuilder().build(deployState, cluster, clientSpec));
        }
    }

    private void addServerProviders(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        ContainerModelBuilder.addConfiguredComponents(deployState, cluster, spec, "server");
    }

    private void addAccessLogs(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        List<Element> accessLogElements = this.getAccessLogElements(spec);
        for (Element accessLog : accessLogElements) {
            AccessLogBuilder.buildIfNotDisabled(deployState, cluster, accessLog).ifPresent(cluster::addComponent);
        }
        if (accessLogElements.isEmpty() && cluster.getSearch() != null) {
            cluster.addDefaultSearchAccessLog();
        }
    }

    private List<Element> getAccessLogElements(Element spec) {
        return XML.getChildren((Element)spec, (String)"accesslog");
    }

    private void addHttp(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        Element httpElement = XML.getChild((Element)spec, (String)"http");
        if (httpElement != null) {
            cluster.setHttp(this.buildHttp(deployState, cluster, httpElement));
        }
    }

    private Http buildHttp(DeployState deployState, ApplicationContainerCluster cluster, Element httpElement) {
        Http http = (Http)new HttpBuilder().build(deployState, cluster, httpElement);
        if (this.networking == Networking.disable) {
            http.removeAllServers();
        }
        return http;
    }

    private void addRestApis(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        for (Element restApiElem : XML.getChildren((Element)spec, (String)"rest-api")) {
            cluster.addRestApi((RestApi)new RestApiBuilder().build(deployState, cluster, restApiElem));
        }
    }

    private void addServlets(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        for (Element servletElem : XML.getChildren((Element)spec, (String)"servlet")) {
            cluster.addServlet((Servlet)new ServletBuilder().build(deployState, cluster, servletElem));
        }
    }

    private void addDocumentApi(Element spec, ApplicationContainerCluster cluster) {
        ContainerDocumentApi containerDocumentApi = this.buildDocumentApi(cluster, spec);
        if (containerDocumentApi == null) {
            return;
        }
        cluster.setDocumentApi(containerDocumentApi);
    }

    private void addDocproc(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        ContainerDocproc containerDocproc = this.buildDocproc(deployState, cluster, spec);
        if (containerDocproc == null) {
            return;
        }
        cluster.setDocproc(containerDocproc);
        ContainerDocproc.Options docprocOptions = containerDocproc.options;
        cluster.setMbusParams(new ContainerCluster.MbusParams(docprocOptions.maxConcurrentFactor, docprocOptions.documentExpansionFactor, docprocOptions.containerCoreMemory));
    }

    private void addSearch(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        Element searchElement = XML.getChild((Element)spec, (String)"search");
        if (searchElement == null) {
            return;
        }
        this.addIncludes(searchElement);
        cluster.setSearch(this.buildSearch(deployState, cluster, searchElement));
        this.addSearchHandler(cluster, searchElement);
        this.addGUIHandler(cluster);
        ContainerModelBuilder.validateAndAddConfiguredComponents(deployState, cluster, searchElement, "renderer", ContainerModelBuilder::validateRendererElement);
    }

    private void addModelEvaluation(Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        Element modelEvaluationElement = XML.getChild((Element)spec, (String)"model-evaluation");
        if (modelEvaluationElement == null) {
            return;
        }
        RankProfileList profiles = context.vespaModel() != null ? context.vespaModel().rankProfileList() : RankProfileList.empty;
        cluster.setModelEvaluation(new ContainerModelEvaluation(cluster, profiles));
    }

    private void addProcessing(DeployState deployState, Element spec, ApplicationContainerCluster cluster) {
        Element processingElement = XML.getChild((Element)spec, (String)"processing");
        if (processingElement == null) {
            return;
        }
        this.addIncludes(processingElement);
        cluster.setProcessingChains((ProcessingChains)new DomProcessingBuilder(null).build(deployState, cluster, processingElement), this.serverBindings(processingElement, ProcessingChains.defaultBindings));
        ContainerModelBuilder.validateAndAddConfiguredComponents(deployState, cluster, processingElement, "renderer", ContainerModelBuilder::validateRendererElement);
    }

    private ContainerSearch buildSearch(DeployState deployState, ApplicationContainerCluster containerCluster, Element producerSpec) {
        SearchChains searchChains = (SearchChains)new DomSearchChainsBuilder(null, false).build(deployState, containerCluster, producerSpec);
        ContainerSearch containerSearch = new ContainerSearch(containerCluster, searchChains, new ContainerSearch.Options());
        this.applyApplicationPackageDirectoryConfigs(deployState.getApplicationPackage(), containerSearch);
        containerSearch.setQueryProfiles(deployState.getQueryProfiles());
        containerSearch.setSemanticRules(deployState.getSemanticRules());
        return containerSearch;
    }

    private void applyApplicationPackageDirectoryConfigs(ApplicationPackage applicationPackage, ContainerSearch containerSearch) {
        PageTemplates.validate(applicationPackage);
        containerSearch.setPageTemplates(PageTemplates.create(applicationPackage));
    }

    private void addHandlers(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        for (Element component : XML.getChildren((Element)spec, (String)"handler")) {
            cluster.addComponent((Component)new DomHandlerBuilder().build(deployState, cluster, component));
        }
    }

    private void checkVersion(Element spec) {
        String version = spec.getAttribute("version");
        if (!Version.fromString((String)version).equals((Object)new Version(1))) {
            throw new RuntimeException("Expected container version to be 1.0, but got " + version);
        }
    }

    private void addNodes(ApplicationContainerCluster cluster, Element spec, ConfigModelContext context) {
        if (this.standaloneBuilder) {
            this.addStandaloneNode(cluster);
        } else {
            this.addNodesFromXml(cluster, spec, context);
        }
    }

    private void addStandaloneNode(ApplicationContainerCluster cluster) {
        ApplicationContainer container = new ApplicationContainer((AbstractConfigProducer)cluster, "standalone", cluster.getContainers().size(), cluster.isHostedVespa());
        cluster.addContainers(Collections.singleton(container));
    }

    static boolean incompatibleGCOptions(String jvmargs) {
        Pattern gcAlgorithm = Pattern.compile("-XX:[-+]Use.+GC");
        Pattern cmsArgs = Pattern.compile("-XX:[-+]*CMS");
        return gcAlgorithm.matcher(jvmargs).find() || cmsArgs.matcher(jvmargs).find();
    }

    private static String buildJvmGCOptions(Zone zone, String jvmGCOPtions, boolean isHostedVespa) {
        if (jvmGCOPtions != null) {
            return jvmGCOPtions;
        }
        if (zone.system() == SystemName.dev || isHostedVespa) {
            return null;
        }
        return "-XX:+UseG1GC -XX:MaxTenuringThreshold=15";
    }

    private static String getJvmOptions(ApplicationContainerCluster cluster, Element nodesElement, DeployLogger deployLogger) {
        String jvmOptions = "";
        if (nodesElement.hasAttribute("jvm-options")) {
            jvmOptions = nodesElement.getAttribute("jvm-options");
            if (nodesElement.hasAttribute("jvmargs")) {
                String jvmArgs = nodesElement.getAttribute("jvmargs");
                throw new IllegalArgumentException("You have specified both jvm-options='" + jvmOptions + "' and deprecated jvmargs='" + jvmArgs + "'. Merge jvmargs into jvm-options.");
            }
        } else {
            jvmOptions = nodesElement.getAttribute("jvmargs");
            if (ContainerModelBuilder.incompatibleGCOptions(jvmOptions)) {
                deployLogger.log(Level.WARNING, "You need to move out your GC related options from 'jvmargs' to 'jvm-gc-options'");
                cluster.setJvmGCOptions("-XX:+UseG1GC -XX:MaxTenuringThreshold=15");
            }
        }
        return jvmOptions;
    }

    void extractJvmFromLegacyNodesTag(List<ApplicationContainer> nodes, ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        ContainerModelBuilder.applyNodesTagJvmArgs(nodes, ContainerModelBuilder.getJvmOptions(cluster, nodesElement, context.getDeployLogger()));
        if (!cluster.getJvmGCOptions().isPresent()) {
            String jvmGCOptions = nodesElement.hasAttribute("jvm-gc-options") ? nodesElement.getAttribute("jvm-gc-options") : null;
            cluster.setJvmGCOptions(ContainerModelBuilder.buildJvmGCOptions(context.getDeployState().zone(), jvmGCOptions, context.getDeployState().isHosted()));
        }
        ContainerModelBuilder.applyMemoryPercentage(cluster, nodesElement.getAttribute("allocated-memory"));
    }

    void extractJvmTag(List<ApplicationContainer> nodes, ApplicationContainerCluster cluster, Element jvmElement, ConfigModelContext context) {
        ContainerModelBuilder.applyNodesTagJvmArgs(nodes, jvmElement.getAttribute("options"));
        ContainerModelBuilder.applyMemoryPercentage(cluster, jvmElement.getAttribute("allocated-memory"));
        String jvmGCOptions = jvmElement.hasAttribute("gc-options") ? jvmElement.getAttribute("gc-options") : null;
        cluster.setJvmGCOptions(ContainerModelBuilder.buildJvmGCOptions(context.getDeployState().zone(), jvmGCOptions, context.getDeployState().isHosted()));
    }

    private void addNodesFromXml(ApplicationContainerCluster cluster, Element containerElement, ConfigModelContext context) {
        Element nodesElement = XML.getChild((Element)containerElement, (String)"nodes");
        Element rotationsElement = XML.getChild((Element)containerElement, (String)"rotations");
        if (nodesElement == null) {
            ApplicationContainer node = new ApplicationContainer((AbstractConfigProducer)cluster, "container.0", 0, cluster.isHostedVespa());
            HostResource host = this.allocateSingleNodeHost(cluster, this.log, containerElement, context);
            node.setHostResource(host);
            node.initService(context.getDeployLogger());
            cluster.addContainers(Collections.singleton(node));
        } else {
            List<ApplicationContainer> nodes = this.createNodes(cluster, nodesElement, context);
            Element jvmElement = XML.getChild((Element)nodesElement, (String)"jvm");
            if (jvmElement == null) {
                this.extractJvmFromLegacyNodesTag(nodes, cluster, nodesElement, context);
            } else {
                this.extractJvmTag(nodes, cluster, jvmElement, context);
            }
            ContainerModelBuilder.applyRoutingAliasProperties(nodes, cluster);
            ContainerModelBuilder.applyDefaultPreload(nodes, nodesElement);
            String environmentVars = ContainerModelBuilder.getEnvironmentVariables(XML.getChild((Element)nodesElement, (String)ENVIRONMENT_VARIABLES_ELEMENT));
            if (environmentVars != null && !environmentVars.isEmpty()) {
                cluster.setEnvironmentVars(environmentVars);
            }
            if (ContainerModelBuilder.useCpuSocketAffinity(nodesElement)) {
                AbstractService.distributeCpuSocketAffinity(nodes);
            }
            cluster.addContainers(nodes);
        }
    }

    private static String getEnvironmentVariables(Element environmentVariables) {
        StringBuilder sb = new StringBuilder();
        if (environmentVariables != null) {
            for (Element var : XML.getChildren((Element)environmentVariables)) {
                sb.append(var.getNodeName()).append('=').append(var.getTextContent()).append(' ');
            }
        }
        return sb.toString();
    }

    private List<ApplicationContainer> createNodes(ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        if (nodesElement.hasAttribute("count")) {
            return this.createNodesFromNodeCount(cluster, nodesElement, context);
        }
        if (nodesElement.hasAttribute("type")) {
            return this.createNodesFromNodeType(cluster, nodesElement, context);
        }
        if (nodesElement.hasAttribute("of")) {
            return this.createNodesFromContentServiceReference(cluster, nodesElement, context);
        }
        return this.createNodesFromNodeList(context.getDeployState(), cluster, nodesElement);
    }

    private static void applyRoutingAliasProperties(List<ApplicationContainer> result, ApplicationContainerCluster cluster) {
        if (!cluster.serviceAliases().isEmpty()) {
            result.forEach(container -> container.setProp("servicealiases", cluster.serviceAliases().stream().collect(Collectors.joining(","))));
        }
        if (!cluster.endpointAliases().isEmpty()) {
            result.forEach(container -> container.setProp("endpointaliases", cluster.endpointAliases().stream().collect(Collectors.joining(","))));
        }
    }

    private static void applyMemoryPercentage(ApplicationContainerCluster cluster, String memoryPercentage) {
        if (memoryPercentage == null || memoryPercentage.isEmpty()) {
            return;
        }
        if (!(memoryPercentage = memoryPercentage.trim()).endsWith("%")) {
            throw new IllegalArgumentException("The memory percentage given for nodes in " + cluster + " must be an integer percentage ending by the '%' sign");
        }
        memoryPercentage = memoryPercentage.substring(0, memoryPercentage.length() - 1).trim();
        try {
            cluster.setMemoryPercentage(Integer.parseInt(memoryPercentage));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The memory percentage given for nodes in " + cluster + " must be an integer percentage ending by the '%' sign");
        }
    }

    private HostResource allocateSingleNodeHost(ApplicationContainerCluster cluster, DeployLogger logger, Element containerElement, ConfigModelContext context) {
        DeployState deployState = context.getDeployState();
        HostSystem hostSystem = cluster.getHostSystem();
        if (deployState.isHosted()) {
            Optional<HostResource> singleContentHost = this.getHostResourceFromContentClusters(cluster, containerElement, context);
            if (singleContentHost.isPresent()) {
                return singleContentHost.get();
            }
            ClusterSpec clusterSpec = ClusterSpec.request((ClusterSpec.Type)ClusterSpec.Type.container, (ClusterSpec.Id)ClusterSpec.Id.from((String)cluster.getName()), (Version)deployState.getWantedNodeVespaVersion(), (boolean)false);
            Capacity capacity = Capacity.fromNodeCount((int)1, Optional.empty(), (boolean)false, (!deployState.getProperties().isBootstrap() ? 1 : 0) != 0);
            return hostSystem.allocateHosts(clusterSpec, capacity, 1, logger).keySet().iterator().next();
        }
        return hostSystem.getHost("default_singlenode_container");
    }

    private List<ApplicationContainer> createNodesFromNodeCount(ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        NodesSpecification nodesSpecification = NodesSpecification.from(new ModelElement(nodesElement), context);
        Map<HostResource, ClusterMembership> hosts = nodesSpecification.provision(cluster.getRoot().getHostSystem(), ClusterSpec.Type.container, ClusterSpec.Id.from((String)cluster.getName()), this.log);
        return this.createNodesFromHosts(context.getDeployLogger(), hosts, cluster);
    }

    private List<ApplicationContainer> createNodesFromNodeType(ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        NodeType type = NodeType.valueOf((String)nodesElement.getAttribute("type"));
        ClusterSpec clusterSpec = ClusterSpec.request((ClusterSpec.Type)ClusterSpec.Type.container, (ClusterSpec.Id)ClusterSpec.Id.from((String)cluster.getName()), (Version)context.getDeployState().getWantedNodeVespaVersion(), (boolean)false);
        Map<HostResource, ClusterMembership> hosts = cluster.getRoot().getHostSystem().allocateHosts(clusterSpec, Capacity.fromRequiredNodeType((NodeType)type), 1, this.log);
        return this.createNodesFromHosts(context.getDeployLogger(), hosts, cluster);
    }

    private List<ApplicationContainer> createNodesFromContentServiceReference(ApplicationContainerCluster cluster, Element nodesElement, ConfigModelContext context) {
        String referenceId = nodesElement.getAttribute("of");
        Element services = this.servicesRootOf(nodesElement).orElseThrow(() -> this.clusterReferenceNotFoundException(cluster, referenceId));
        Element referencedService = this.findChildById(services, referenceId).orElseThrow(() -> this.clusterReferenceNotFoundException(cluster, referenceId));
        if (!referencedService.getTagName().equals("content")) {
            throw new IllegalArgumentException(cluster + " references service '" + referenceId + "', but that is not a content service");
        }
        Element referencedNodesElement = XML.getChild((Element)referencedService, (String)"nodes");
        if (referencedNodesElement == null) {
            throw new IllegalArgumentException(cluster + " references service '" + referenceId + "' to supply nodes, but that service has no <nodes> element");
        }
        cluster.setHostClusterId(referenceId);
        Map<HostResource, ClusterMembership> hosts = StorageGroup.provisionHosts(NodesSpecification.from(new ModelElement(referencedNodesElement), context), referenceId, cluster.getRoot().getHostSystem(), context.getDeployLogger());
        return this.createNodesFromHosts(context.getDeployLogger(), hosts, cluster);
    }

    private Optional<HostResource> getHostResourceFromContentClusters(ApplicationContainerCluster cluster, Element containersElement, ConfigModelContext context) {
        Optional<Element> services = this.servicesRootOf(containersElement);
        if (!services.isPresent()) {
            return Optional.empty();
        }
        List contentServices = XML.getChildren((Element)services.get(), (String)"content");
        if (contentServices.isEmpty()) {
            return Optional.empty();
        }
        Element contentNodesElementOrNull = XML.getChild((Element)((Element)contentServices.get(0)), (String)"nodes");
        NodesSpecification nodesSpec = contentNodesElementOrNull == null ? NodesSpecification.nonDedicated(1, context) : NodesSpecification.from(new ModelElement(contentNodesElementOrNull), context);
        Map<HostResource, ClusterMembership> hosts = StorageGroup.provisionHosts(nodesSpec, ((Element)contentServices.get(0)).getAttribute("id"), cluster.getRoot().getHostSystem(), context.getDeployLogger());
        return Optional.of(hosts.keySet().iterator().next());
    }

    private Optional<Element> servicesRootOf(Element element) {
        Node parent = element.getParentNode();
        if (parent == null) {
            return Optional.empty();
        }
        if (!(parent instanceof Element)) {
            return Optional.empty();
        }
        Element parentElement = (Element)parent;
        if (parentElement.getTagName().equals("services")) {
            return Optional.of(parentElement);
        }
        return this.servicesRootOf(parentElement);
    }

    private List<ApplicationContainer> createNodesFromHosts(DeployLogger deployLogger, Map<HostResource, ClusterMembership> hosts, ApplicationContainerCluster cluster) {
        ArrayList<ApplicationContainer> nodes = new ArrayList<ApplicationContainer>();
        for (Map.Entry<HostResource, ClusterMembership> entry : hosts.entrySet()) {
            String id = "container." + entry.getValue().index();
            ApplicationContainer container = new ApplicationContainer(cluster, id, entry.getValue().retired(), entry.getValue().index(), cluster.isHostedVespa());
            container.setHostResource(entry.getKey());
            container.initService(deployLogger);
            nodes.add(container);
        }
        return nodes;
    }

    private List<ApplicationContainer> createNodesFromNodeList(DeployState deployState, ApplicationContainerCluster cluster, Element nodesElement) {
        ArrayList<ApplicationContainer> nodes = new ArrayList<ApplicationContainer>();
        int nodeIndex = 0;
        for (Element nodeElem : XML.getChildren((Element)nodesElement, (String)"node")) {
            nodes.add((ApplicationContainer)new ContainerServiceBuilder("container." + nodeIndex, nodeIndex).build(deployState, cluster, nodeElem));
            ++nodeIndex;
        }
        return nodes;
    }

    private IllegalArgumentException clusterReferenceNotFoundException(ApplicationContainerCluster cluster, String referenceId) {
        return new IllegalArgumentException(cluster + " references service '" + referenceId + "' but this service is not defined");
    }

    private Optional<Element> findChildById(Element parent, String id) {
        for (Element child : XML.getChildren((Element)parent)) {
            if (!id.equals(child.getAttribute("id"))) continue;
            return Optional.of(child);
        }
        return Optional.empty();
    }

    private static boolean useCpuSocketAffinity(Element nodesElement) {
        if (nodesElement.hasAttribute("cpu-socket-affinity")) {
            return Boolean.parseBoolean(nodesElement.getAttribute("cpu-socket-affinity"));
        }
        return false;
    }

    private static void applyNodesTagJvmArgs(List<ApplicationContainer> containers, String jvmArgs) {
        for (Container container : containers) {
            if (!container.getAssignedJvmOptions().isEmpty()) continue;
            container.prependJvmOptions(jvmArgs);
        }
    }

    private static void applyDefaultPreload(List<ApplicationContainer> containers, Element nodesElement) {
        if (!nodesElement.hasAttribute("preload")) {
            return;
        }
        for (Container container : containers) {
            container.setPreLoad(nodesElement.getAttribute("preload"));
        }
    }

    private void addSearchHandler(ApplicationContainerCluster cluster, Element searchElement) {
        cluster.addComponent(new ProcessingHandler<SearchChains>((SearchChains)cluster.getSearch().getChains(), "com.yahoo.search.searchchain.ExecutionFactory"));
        ProcessingHandler<SearchChains> searchHandler = new ProcessingHandler<SearchChains>((SearchChains)cluster.getSearch().getChains(), "com.yahoo.search.handler.SearchHandler");
        String[] defaultBindings = new String[]{"http://*/search/*"};
        for (String binding : this.serverBindings(searchElement, defaultBindings)) {
            searchHandler.addServerBindings(binding);
        }
        cluster.addComponent(searchHandler);
    }

    private void addGUIHandler(ApplicationContainerCluster cluster) {
        GUIHandler guiHandler = new GUIHandler();
        guiHandler.addServerBindings("http://*/querybuilder/*");
        cluster.addComponent(guiHandler);
    }

    private String[] serverBindings(Element searchElement, String ... defaultBindings) {
        List bindings = XML.getChildren((Element)searchElement, (String)"binding");
        if (bindings.isEmpty()) {
            return defaultBindings;
        }
        return this.toBindingList(bindings);
    }

    private String[] toBindingList(List<Element> bindingElements) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : bindingElements) {
            String text = element.getTextContent().trim();
            if (text.isEmpty()) continue;
            result.add(text);
        }
        return result.toArray(new String[result.size()]);
    }

    private ContainerDocumentApi buildDocumentApi(ApplicationContainerCluster cluster, Element spec) {
        Element documentApiElement = XML.getChild((Element)spec, (String)"document-api");
        if (documentApiElement == null) {
            return null;
        }
        ContainerDocumentApi.Options documentApiOptions = DocumentApiOptionsBuilder.build(documentApiElement);
        return new ContainerDocumentApi(cluster, documentApiOptions);
    }

    private ContainerDocproc buildDocproc(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        Element docprocElement = XML.getChild((Element)spec, (String)"document-processing");
        if (docprocElement == null) {
            return null;
        }
        this.addIncludes(docprocElement);
        DocprocChains chains = (DocprocChains)new DomDocprocChainsBuilder(null, false).build(deployState, cluster, docprocElement);
        ContainerDocproc.Options docprocOptions = DocprocOptionsBuilder.build(docprocElement);
        return new ContainerDocproc(cluster, chains, docprocOptions, !this.standaloneBuilder);
    }

    private void addIncludes(Element parentElement) {
        List includes = XML.getChildren((Element)parentElement, (String)"include");
        if (includes == null || includes.isEmpty()) {
            return;
        }
        if (this.app == null) {
            throw new IllegalArgumentException("Element <include> given in XML config, but no application package given.");
        }
        for (Element include : includes) {
            this.addInclude(parentElement, include);
        }
    }

    private void addInclude(Element parentElement, Element include) {
        String dirName = include.getAttribute("dir");
        this.app.validateIncludeDir(dirName);
        List includedFiles = Xml.allElemsFromPath((ApplicationPackage)this.app, (String)dirName);
        for (Element includedFile : includedFiles) {
            List includedSubElements = XML.getChildren((Element)includedFile);
            for (Element includedSubElement : includedSubElements) {
                Node copiedNode = parentElement.getOwnerDocument().importNode(includedSubElement, true);
                parentElement.appendChild(copiedNode);
            }
        }
    }

    private static void addConfiguredComponents(DeployState deployState, ContainerCluster<? extends Container> cluster, Element spec, String componentName) {
        for (Element node : XML.getChildren((Element)spec, (String)componentName)) {
            cluster.addComponent((Component)new DomComponentBuilder().build(deployState, cluster, node));
        }
    }

    private static void validateAndAddConfiguredComponents(DeployState deployState, ContainerCluster<? extends Container> cluster, Element spec, String componentName, Consumer<Element> elementValidator) {
        for (Element node : XML.getChildren((Element)spec, (String)componentName)) {
            elementValidator.accept(node);
            cluster.addComponent((Component)new DomComponentBuilder().build(deployState, cluster, node));
        }
    }

    private void addIdentityProvider(ApplicationContainerCluster cluster, List<ConfigServerSpec> configServerSpecs, HostName loadBalancerName, URI ztsUrl, String athenzDnsSuffix, Zone zone, DeploymentSpec spec) {
        spec.athenzDomain().ifPresent(domain -> {
            AthenzService service = (AthenzService)spec.athenzService(zone.environment(), zone.region()).orElseThrow(() -> new RuntimeException("Missing Athenz service configuration"));
            String zoneDnsSuffix = zone.environment().value() + "-" + zone.region().value() + "." + athenzDnsSuffix;
            IdentityProvider identityProvider = new IdentityProvider((AthenzDomain)domain, service, this.getLoadBalancerName(loadBalancerName, configServerSpecs), ztsUrl, zoneDnsSuffix, zone);
            cluster.addComponent(identityProvider);
            cluster.getContainers().forEach(container -> {
                container.setProp("identity.domain", domain.value());
                container.setProp("identity.service", service.value());
            });
        });
    }

    private HostName getLoadBalancerName(HostName loadbalancerName, List<ConfigServerSpec> configServerSpecs) {
        return Optional.ofNullable(loadbalancerName).orElseGet(() -> HostName.from((String)configServerSpecs.stream().findFirst().map(ConfigServerSpec::getHostName).orElse("unknown")));
    }

    private static void validateRendererElement(Element element) {
        String idAttr = element.getAttribute("id");
        if (idAttr.equals(xmlRendererId) || idAttr.equals(jsonRendererId)) {
            throw new IllegalArgumentException(String.format("Renderer id %s is reserved for internal use", idAttr));
        }
    }

    public static enum Networking {
        disable,
        enable;

    }
}

