/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.component.ComponentId;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.BundlesConfig;
import com.yahoo.jdisc.http.ServletPathsConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModelEvaluation;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ConfigProducerGroup;
import com.yahoo.vespa.model.container.component.Servlet;
import com.yahoo.vespa.model.container.jersey.Jersey2Servlet;
import com.yahoo.vespa.model.container.jersey.RestApi;
import com.yahoo.vespa.model.utils.FileSender;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ApplicationContainerCluster
extends ContainerCluster<ApplicationContainer>
implements BundlesConfig.Producer,
RankProfilesConfig.Producer,
RankingConstantsConfig.Producer,
ServletPathsConfig.Producer {
    private final Set<FileReference> applicationBundles = new LinkedHashSet<FileReference>();
    private final ConfigProducerGroup<Servlet> servletGroup;
    private final ConfigProducerGroup<RestApi> restApiGroup = new ConfigProducerGroup(this, "rest-api");
    private ContainerModelEvaluation modelEvaluation;

    public ApplicationContainerCluster(AbstractConfigProducer<?> parent, String subId, String name, DeployState deployState) {
        super(parent, subId, name, deployState);
        this.servletGroup = new ConfigProducerGroup(this, "servlet");
        this.addSimpleComponent("com.yahoo.language.provider.DefaultLinguisticsProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.SecretStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.CertificateStoreProvider");
    }

    @Override
    protected void doPrepare(DeployState deployState) {
        this.addAndSendApplicationBundles(deployState);
        if (this.modelEvaluation != null) {
            this.modelEvaluation.prepare(this.containers);
        }
        this.sendUserConfiguredFiles(deployState);
        for (RestApi restApi : this.restApiGroup.getComponents()) {
            restApi.prepare();
        }
    }

    private void addAndSendApplicationBundles(DeployState deployState) {
        for (ComponentInfo component : deployState.getApplicationPackage().getComponentsInfo(deployState.getVespaVersion())) {
            FileReference reference = FileSender.sendFileToServices(component.getPathRelativeToAppDir(), this.containers);
            this.applicationBundles.add(reference);
        }
    }

    private void sendUserConfiguredFiles(DeployState deployState) {
        for (Component<?, ?> component : this.getAllComponents()) {
            FileSender.sendUserConfiguredFiles(component, this.containers, deployState.getDeployLogger());
        }
    }

    public void setModelEvaluation(ContainerModelEvaluation modelEvaluation) {
        this.modelEvaluation = modelEvaluation;
    }

    public final void addRestApi(@NonNull RestApi restApi) {
        this.restApiGroup.addComponent(ComponentId.fromString((String)restApi.getBindingPath()), restApi);
    }

    public Map<ComponentId, RestApi> getRestApiMap() {
        return this.restApiGroup.getComponentMap();
    }

    public Map<ComponentId, Servlet> getServletMap() {
        return this.servletGroup.getComponentMap();
    }

    public final void addServlet(@NonNull Servlet servlet) {
        this.servletGroup.addComponent(servlet.getGlobalComponentId(), servlet);
    }

    public Collection<Servlet> getAllServlets() {
        return this.allServlets().collect(Collectors.toCollection(ArrayList::new));
    }

    private Stream<Servlet> allServlets() {
        return Stream.concat(this.allJersey2Servlets(), this.servletGroup.getComponents().stream());
    }

    private Stream<Jersey2Servlet> allJersey2Servlets() {
        return this.restApiGroup.getComponents().stream().map(RestApi::getJersey2Servlet);
    }

    @Override
    public void getConfig(BundlesConfig.Builder builder) {
        this.applicationBundles.stream().map(FileReference::value).forEach(arg_0 -> ((BundlesConfig.Builder)builder).bundle(arg_0));
        super.getConfig(builder);
    }

    public void getConfig(ServletPathsConfig.Builder builder) {
        this.allServlets().forEach(servlet -> builder.servlets(servlet.getComponentId().stringValue(), servlet.toConfigBuilder()));
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }
}

