/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class Processor {
    protected final Search search;
    protected DeployLogger deployLogger;
    protected final RankProfileRegistry rankProfileRegistry;
    protected final QueryProfiles queryProfiles;

    public Processor(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        this.search = search;
        this.deployLogger = deployLogger;
        this.rankProfileRegistry = rankProfileRegistry;
        this.queryProfiles = queryProfiles;
    }

    public abstract void process(boolean var1, boolean var2);

    protected SDField addField(Search search, SDField field, String suffix, String indexing, String queryCommand) {
        SDField implementationField = search.getConcreteField(field.getName() + "_" + suffix);
        if (implementationField != null) {
            this.deployLogger.log(Level.WARNING, "Implementation field " + implementationField + " added twice");
        } else {
            implementationField = new SDField(search.getDocument(), field.getName() + "_" + suffix, (DataType)DataType.STRING);
        }
        implementationField.setRankType(RankType.EMPTY);
        implementationField.setStemming(Stemming.NONE);
        implementationField.getNormalizing().inferCodepoint();
        implementationField.parseIndexingScript(indexing);
        Iterator<String> i = field.getFieldNameAsIterator();
        while (i.hasNext()) {
            String indexName = i.next();
            String implementationIndexName = indexName + "_" + suffix;
            Index implementationIndex = new Index(implementationIndexName);
            search.addIndex(implementationIndex);
        }
        if (queryCommand != null) {
            field.addQueryCommand(queryCommand);
        }
        search.addExtraField(implementationField);
        search.fieldSets().addBuiltInFieldSetItem("[internal]", implementationField.getName());
        return implementationField;
    }

    protected Iterator<RankProfile.RankSetting> matchingRankSettingsIterator(Search search, RankProfile.RankSetting.Type type) {
        ArrayList<RankProfile.RankSetting> someRankSettings = new ArrayList<RankProfile.RankSetting>();
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(search)) {
            Iterator<RankProfile.RankSetting> j = profile.declaredRankSettingIterator();
            while (j.hasNext()) {
                RankProfile.RankSetting setting = j.next();
                if (!setting.getType().equals((Object)type)) continue;
                someRankSettings.add(setting);
            }
        }
        return someRankSettings.iterator();
    }

    protected String formatError(String searchName, String fieldName, String msg) {
        return "For search '" + searchName + "', field '" + fieldName + "': " + msg;
    }

    protected RuntimeException newProcessException(String searchName, String fieldName, String msg) {
        return new IllegalArgumentException(this.formatError(searchName, fieldName, msg));
    }

    protected RuntimeException newProcessException(Search search, Field field, String msg) {
        return this.newProcessException(search.getName(), field.getName(), msg);
    }

    public void fail(Search search, Field field, String msg) {
        throw this.newProcessException(search, field, msg);
    }

    protected void warn(String searchName, String fieldName, String msg) {
        String fullMsg = this.formatError(searchName, fieldName, msg);
        this.deployLogger.log(Level.WARNING, fullMsg);
    }

    protected void warn(Search search, Field field, String msg) {
        this.warn(search.getName(), field.getName(), msg);
    }
}

