/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.producer;

import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class UserConfigRepo {
    private final Map<ConfigDefinitionKey, ConfigPayloadBuilder> userConfigsMap;

    public UserConfigRepo() {
        this.userConfigsMap = new LinkedHashMap<ConfigDefinitionKey, ConfigPayloadBuilder>();
    }

    public UserConfigRepo clone() {
        return new UserConfigRepo(this.copyBuilders(this.userConfigsMap));
    }

    private Map<ConfigDefinitionKey, ConfigPayloadBuilder> copyBuilders(Map<ConfigDefinitionKey, ConfigPayloadBuilder> source) {
        LinkedHashMap<ConfigDefinitionKey, ConfigPayloadBuilder> ret = new LinkedHashMap<ConfigDefinitionKey, ConfigPayloadBuilder>();
        for (Map.Entry<ConfigDefinitionKey, ConfigPayloadBuilder> e : source.entrySet()) {
            ConfigDefinitionKey key = e.getKey();
            ConfigPayloadBuilder sourceVal = e.getValue();
            ConfigPayloadBuilder destVal = new ConfigPayloadBuilder(ConfigPayload.fromBuilder((ConfigPayloadBuilder)sourceVal));
            ret.put(key, destVal);
        }
        return ret;
    }

    public UserConfigRepo(Map<ConfigDefinitionKey, ConfigPayloadBuilder> map) {
        this.userConfigsMap = map;
    }

    public UserConfigRepo(UserConfigRepo userConfigRepo) {
        this.userConfigsMap = userConfigRepo.userConfigsMap;
    }

    public ConfigPayloadBuilder get(ConfigDefinitionKey key) {
        return this.userConfigsMap.get(key);
    }

    public void merge(UserConfigRepo newRepo) {
        for (Map.Entry<ConfigDefinitionKey, ConfigPayloadBuilder> entry : newRepo.userConfigsMap.entrySet()) {
            if (entry.getValue() == null) continue;
            ConfigDefinitionKey key = entry.getKey();
            if (this.userConfigsMap.containsKey(key)) {
                ConfigPayloadBuilder lhsBuilder = this.userConfigsMap.get(key);
                ConfigPayloadBuilder rhsBuilder = entry.getValue();
                lhsBuilder.override(rhsBuilder);
                continue;
            }
            this.userConfigsMap.put(key, entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.userConfigsMap.isEmpty();
    }

    public int size() {
        return this.userConfigsMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ConfigDefinitionKey key : this.userConfigsMap.keySet()) {
            sb.append(key.toString());
        }
        return sb.toString();
    }

    public Set<ConfigDefinitionKey> configsProduced() {
        return this.userConfigsMap.keySet();
    }
}

