/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import ai.vespa.rankingexpression.importer.configmodelview.MlModelImporter;
import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.model.deploy.ConfigDefinitionStore;
import com.yahoo.config.model.deploy.SearchDocumentModel;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.model.provision.HostsXmlProvisioner;
import com.yahoo.config.model.provision.SingleNodeProvisioner;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.config.provision.Rotation;
import com.yahoo.config.provision.Zone;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.SearchBuilder;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.container.search.QueryProfilesBuilder;
import com.yahoo.vespa.model.container.search.SemanticRuleBuilder;
import com.yahoo.vespa.model.container.search.SemanticRules;
import com.yahoo.vespa.model.search.SearchDefinition;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DeployState
implements ConfigDefinitionStore {
    private final DeployLogger logger;
    private final FileRegistry fileRegistry;
    private final DocumentModel documentModel;
    private final List<SearchDefinition> searchDefinitions;
    private final ApplicationPackage applicationPackage;
    private final Optional<ConfigDefinitionRepo> configDefinitionRepo;
    private final Optional<ApplicationPackage> permanentApplicationPackage;
    private final Optional<Model> previousModel;
    private final ModelContext.Properties properties;
    private final Version vespaVersion;
    private final Set<Rotation> rotations;
    private final Zone zone;
    private final QueryProfiles queryProfiles;
    private final SemanticRules semanticRules;
    private final ImportedMlModels importedModels;
    private final ValidationOverrides validationOverrides;
    private final Version wantedNodeVespaVersion;
    private final Instant now;
    private final HostProvisioner provisioner;
    private final RankProfileRegistry rankProfileRegistry;
    private Map<ConfigDefinitionKey, UnparsedConfigDefinition> existingConfigDefs = null;
    private final Map<ConfigDefinitionKey, com.yahoo.vespa.config.ConfigDefinition> defArchive = new LinkedHashMap<ConfigDefinitionKey, com.yahoo.vespa.config.ConfigDefinition>();

    public static DeployState createTestState() {
        return new Builder().build();
    }

    public static DeployState createTestState(ApplicationPackage applicationPackage) {
        return new Builder().applicationPackage(applicationPackage).build();
    }

    private DeployState(ApplicationPackage applicationPackage, SearchDocumentModel searchDocumentModel, RankProfileRegistry rankProfileRegistry, FileRegistry fileRegistry, DeployLogger deployLogger, Optional<HostProvisioner> hostProvisioner, ModelContext.Properties properties, Version vespaVersion, Optional<ApplicationPackage> permanentApplicationPackage, Optional<ConfigDefinitionRepo> configDefinitionRepo, Optional<Model> previousModel, Set<Rotation> rotations, Collection<MlModelImporter> modelImporters, Zone zone, QueryProfiles queryProfiles, SemanticRules semanticRules, Instant now, Version wantedNodeVespaVersion) {
        this.logger = deployLogger;
        this.fileRegistry = fileRegistry;
        this.rankProfileRegistry = rankProfileRegistry;
        this.applicationPackage = applicationPackage;
        this.properties = properties;
        this.vespaVersion = vespaVersion;
        this.previousModel = previousModel;
        this.provisioner = hostProvisioner.orElse(DeployState.getDefaultModelHostProvisioner(applicationPackage));
        this.searchDefinitions = searchDocumentModel.getSearchDefinitions();
        this.documentModel = searchDocumentModel.getDocumentModel();
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.configDefinitionRepo = configDefinitionRepo;
        this.rotations = rotations;
        this.zone = zone;
        this.queryProfiles = queryProfiles;
        this.semanticRules = semanticRules;
        this.importedModels = new ImportedMlModels(applicationPackage.getFileReference(ApplicationPackage.MODELS_DIR), modelImporters);
        ValidationOverrides suppliedValidationOverrides = applicationPackage.getValidationOverrides().map(ValidationOverrides::fromXml).orElse(ValidationOverrides.empty);
        this.validationOverrides = zone.environment().isManuallyDeployed() ? new ValidationOverrides.AllowAllValidationOverrides(suppliedValidationOverrides, deployLogger) : suppliedValidationOverrides;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
        this.now = now;
    }

    public static HostProvisioner getDefaultModelHostProvisioner(ApplicationPackage applicationPackage) {
        if (applicationPackage.getHosts() == null) {
            return new SingleNodeProvisioner();
        }
        return new HostsXmlProvisioner(applicationPackage.getHosts());
    }

    public final RankProfileRegistry rankProfileRegistry() {
        return this.rankProfileRegistry;
    }

    public ValidationOverrides validationOverrides() {
        return this.validationOverrides;
    }

    @Override
    public final Optional<com.yahoo.vespa.config.ConfigDefinition> getConfigDefinition(ConfigDefinitionKey defKey) {
        if (this.existingConfigDefs == null) {
            this.existingConfigDefs = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
            if (this.configDefinitionRepo.isPresent()) {
                this.existingConfigDefs.putAll(DeployState.createLazyMapping(this.configDefinitionRepo.get()));
            }
            this.existingConfigDefs.putAll(this.applicationPackage.getAllExistingConfigDefs());
        }
        if (!this.existingConfigDefs.containsKey(defKey)) {
            return Optional.empty();
        }
        if (this.defArchive.get(defKey) != null) {
            return Optional.of(this.defArchive.get(defKey));
        }
        com.yahoo.vespa.config.ConfigDefinition def = this.existingConfigDefs.get(defKey).parse();
        this.defArchive.put(defKey, def);
        return Optional.of(def);
    }

    private static Map<ConfigDefinitionKey, UnparsedConfigDefinition> createLazyMapping(final ConfigDefinitionRepo configDefinitionRepo) {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> keyToRepo = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        for (final Map.Entry defEntry : configDefinitionRepo.getConfigDefinitions().entrySet()) {
            keyToRepo.put((ConfigDefinitionKey)defEntry.getKey(), new UnparsedConfigDefinition(){

                public com.yahoo.vespa.config.ConfigDefinition parse() {
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)((ConfigDefinition)configDefinitionRepo.getConfigDefinitions().get(defEntry.getKey())).getCNode());
                }

                public String getUnparsedContent() {
                    throw new UnsupportedOperationException("Cannot get unparsed content from " + defEntry.getKey());
                }
            });
        }
        return keyToRepo;
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage;
    }

    public List<SearchDefinition> getSearchDefinitions() {
        return this.searchDefinitions;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public DeployLogger getDeployLogger() {
        return this.logger;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public HostProvisioner getProvisioner() {
        return this.provisioner;
    }

    public Optional<ApplicationPackage> getPermanentApplicationPackage() {
        return this.permanentApplicationPackage;
    }

    public ModelContext.Properties getProperties() {
        return this.properties;
    }

    public Version getVespaVersion() {
        return this.vespaVersion;
    }

    public Optional<Model> getPreviousModel() {
        return this.previousModel;
    }

    public boolean isHosted() {
        return this.properties.hostedVespa();
    }

    public Set<Rotation> getRotations() {
        return this.rotations;
    }

    public Zone zone() {
        return this.zone;
    }

    public QueryProfiles getQueryProfiles() {
        return this.queryProfiles;
    }

    public SemanticRules getSemanticRules() {
        return this.semanticRules;
    }

    public ImportedMlModels getImportedModels() {
        return this.importedModels;
    }

    public Version getWantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public Instant now() {
        return this.now;
    }

    public static class Builder {
        private ApplicationPackage applicationPackage = MockApplicationPackage.createEmpty();
        private FileRegistry fileRegistry = new MockFileRegistry();
        private DeployLogger logger = new BaseDeployLogger();
        private Optional<HostProvisioner> hostProvisioner = Optional.empty();
        private Optional<ApplicationPackage> permanentApplicationPackage = Optional.empty();
        private ModelContext.Properties properties = new TestProperties();
        private Version version = new Version(1, 0, 0);
        private Optional<ConfigDefinitionRepo> configDefinitionRepo = Optional.empty();
        private Optional<Model> previousModel = Optional.empty();
        private Set<Rotation> rotations = new HashSet<Rotation>();
        private Collection<MlModelImporter> modelImporters = Collections.emptyList();
        private Zone zone = Zone.defaultZone();
        private Instant now = Instant.now();
        private Version wantedNodeVespaVersion = Vtag.currentVersion;

        public Builder applicationPackage(ApplicationPackage applicationPackage) {
            this.applicationPackage = applicationPackage;
            return this;
        }

        public Builder fileRegistry(FileRegistry fileRegistry) {
            this.fileRegistry = fileRegistry;
            return this;
        }

        public Builder deployLogger(DeployLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder modelHostProvisioner(HostProvisioner modelProvisioner) {
            this.hostProvisioner = Optional.of(modelProvisioner);
            return this;
        }

        public Builder permanentApplicationPackage(Optional<ApplicationPackage> permanentApplicationPackage) {
            this.permanentApplicationPackage = permanentApplicationPackage;
            return this;
        }

        public Builder properties(ModelContext.Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder vespaVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder configDefinitionRepo(ConfigDefinitionRepo configDefinitionRepo) {
            this.configDefinitionRepo = Optional.of(configDefinitionRepo);
            return this;
        }

        public Builder previousModel(Model previousModel) {
            this.previousModel = Optional.of(previousModel);
            return this;
        }

        public Builder rotations(Set<Rotation> rotations) {
            this.rotations = rotations;
            return this;
        }

        public Builder modelImporters(Collection<MlModelImporter> modelImporters) {
            this.modelImporters = modelImporters;
            return this;
        }

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public Builder now(Instant now) {
            this.now = now;
            return this;
        }

        public Builder wantedNodeVespaVersion(Version version) {
            this.wantedNodeVespaVersion = version;
            return this;
        }

        public DeployState build() {
            return this.build(new ValidationParameters());
        }

        public DeployState build(ValidationParameters validationParameters) {
            RankProfileRegistry rankProfileRegistry = new RankProfileRegistry();
            QueryProfiles queryProfiles = new QueryProfilesBuilder().build(this.applicationPackage, this.logger);
            SemanticRules semanticRules = new SemanticRuleBuilder().build(this.applicationPackage);
            SearchDocumentModel searchDocumentModel = this.createSearchDocumentModel(rankProfileRegistry, this.logger, queryProfiles, validationParameters);
            return new DeployState(this.applicationPackage, searchDocumentModel, rankProfileRegistry, this.fileRegistry, this.logger, this.hostProvisioner, this.properties, this.version, this.permanentApplicationPackage, this.configDefinitionRepo, this.previousModel, this.rotations, this.modelImporters, this.zone, queryProfiles, semanticRules, this.now, this.wantedNodeVespaVersion);
        }

        private SearchDocumentModel createSearchDocumentModel(RankProfileRegistry rankProfileRegistry, DeployLogger logger, QueryProfiles queryProfiles, ValidationParameters validationParameters) {
            Collection readers = this.applicationPackage.getSearchDefinitions();
            LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
            SearchBuilder builder = new SearchBuilder(this.applicationPackage, rankProfileRegistry, queryProfiles.getRegistry());
            for (NamedReader reader : readers) {
                try {
                    String readerName = reader.getName();
                    String searchName = builder.importReader(reader, readerName, logger);
                    String sdName = Builder.stripSuffix(readerName, ".sd");
                    names.put(searchName, sdName);
                    if (sdName.equals(searchName)) continue;
                    throw new IllegalArgumentException("Search definition file name ('" + sdName + "') and name of search element ('" + searchName + "') are not equal for file '" + readerName + "'");
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Could not parse search definition file '" + this.getSearchDefinitionRelativePath(reader.getName()) + "': " + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read search definition file '" + this.getSearchDefinitionRelativePath(reader.getName()) + "': " + e.getMessage(), e);
                }
                finally {
                    Builder.closeIgnoreException(reader.getReader());
                }
            }
            builder.build(!validationParameters.ignoreValidationErrors(), logger);
            return SearchDocumentModel.fromBuilderAndNames(builder, names);
        }

        private String getSearchDefinitionRelativePath(String name) {
            return ApplicationPackage.SEARCH_DEFINITIONS_DIR + File.separator + name;
        }

        private static String stripSuffix(String nodeName, String postfix) {
            assert (nodeName.endsWith(postfix));
            return nodeName.substring(0, nodeName.length() - postfix.length());
        }

        private static void closeIgnoreException(Reader reader) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

