/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.FieldSets;
import com.yahoo.searchdefinition.ImmutableSearch;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankingConstants;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.ImportedFields;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.document.TemporaryImportedFields;
import com.yahoo.searchdefinition.document.annotation.SDAnnotationType;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class Search
implements Serializable,
ImmutableSearch {
    private static final Logger log = Logger.getLogger(Search.class.getName());
    private static final String SD_DOC_FIELD_NAME = "sddocname";
    private static final List<String> RESERVED_NAMES = Arrays.asList("index", "index_url", "summary", "attribute", "select_input", "host", "documentid", "position", "split_foreach", "tokenize", "if", "else", "switch", "case", "sddocname", "relevancy");
    private FieldSets fieldSets = new FieldSets();
    private String name;
    private boolean documentsOnly = false;
    private Stemming stemming = Stemming.BEST;
    private SDDocumentType docType;
    private Map<String, SDField> fields = new LinkedHashMap<String, SDField>();
    private Map<String, Index> indices = new LinkedHashMap<String, Index>();
    private Map<String, DocumentSummary> summaries = new LinkedHashMap<String, DocumentSummary>();
    private RankingConstants rankingConstants = new RankingConstants();
    private Optional<TemporaryImportedFields> temporaryImportedFields = Optional.of(new TemporaryImportedFields());
    private Optional<ImportedFields> importedFields = Optional.empty();
    private ApplicationPackage applicationPackage;

    public static boolean isReservedName(String name) {
        return RESERVED_NAMES.contains(name);
    }

    protected Search() {
        this.documentsOnly = true;
    }

    public Search(String name, ApplicationPackage applicationPackage) {
        this.applicationPackage = applicationPackage;
        this.name = name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDocumentsOnly() {
        return this.documentsOnly;
    }

    public void setStemming(Stemming stemming) {
        if (stemming == null) {
            throw new NullPointerException("The stemming setting of a search definition can not be null");
        }
        this.stemming = stemming;
    }

    public Stemming getStemming() {
        return this.stemming;
    }

    public void addDocument(SDDocumentType document) {
        if (this.docType != null) {
            throw new IllegalArgumentException("Searchdefinition cannot have more than one document");
        }
        this.docType = document;
    }

    public RankingConstants rankingConstants() {
        return this.rankingConstants;
    }

    public Optional<TemporaryImportedFields> temporaryImportedFields() {
        return this.temporaryImportedFields;
    }

    public Optional<ImportedFields> importedFields() {
        return this.importedFields;
    }

    public void setImportedFields(ImportedFields importedFields) {
        this.temporaryImportedFields = Optional.empty();
        this.importedFields = Optional.of(importedFields);
    }

    @Override
    public Stream<ImmutableSDField> allImportedFields() {
        return this.importedFields.map(fields -> fields.fields().values().stream()).orElse(Stream.empty()).map(field -> field.asImmutableSDField());
    }

    @Override
    public ImmutableSDField getField(String name) {
        SDField field = this.getConcreteField(name);
        if (field != null) {
            return field;
        }
        return this.allImportedFields().filter(f -> f.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public Stream<ImmutableSDField> allFields() {
        Stream<ImmutableSDField> extraFields = this.extraFieldList().stream().map(ImmutableSDField.class::cast);
        Stream<ImmutableSDField> documentFields = this.docType.fieldSet().stream().map(ImmutableSDField.class::cast);
        return Stream.concat(extraFields, Stream.concat(documentFields, this.allImportedFields()));
    }

    public SDDocumentType getDocument(String name) {
        if (this.docType != null && name.equals(this.docType.getName())) {
            return this.docType;
        }
        return null;
    }

    public boolean hasDocument() {
        return this.docType != null;
    }

    public SDDocumentType getDocument() {
        return this.docType;
    }

    public List<SDField> allConcreteFields() {
        ArrayList<SDField> allFields = new ArrayList<SDField>();
        allFields.addAll(this.extraFieldList());
        for (Field field : this.docType.fieldSet()) {
            allFields.add((SDField)field);
        }
        return allFields;
    }

    public Reader getRankingExpression(String fileName) {
        return this.applicationPackage.getRankingExpression(fileName);
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public SDField getConcreteField(String name) {
        SDField field = this.getExtraField(name);
        if (field != null) {
            return field;
        }
        return (SDField)this.docType.getField(name);
    }

    public SDField getDocumentField(String name) {
        return (SDField)this.docType.getField(name);
    }

    public void addExtraField(SDField field) {
        if (this.fields.containsKey(field.getName())) {
            log.warning("Duplicate field " + field.getName() + " in search definition " + this.getName());
        } else {
            field.setIsExtraField(true);
            this.fields.put(field.getName(), field);
        }
    }

    public Collection<SDField> extraFieldList() {
        return this.fields.values();
    }

    public Collection<SDField> allExtraFields() {
        TreeMap<String, SDField> extraFields = new TreeMap<String, SDField>();
        for (Field field : this.docType.fieldSet()) {
            SDField sdField = (SDField)field;
            if (!sdField.isExtraField()) continue;
            extraFields.put(sdField.getName(), sdField);
        }
        for (SDField sDField : this.extraFieldList()) {
            extraFields.put(sDField.getName(), sDField);
        }
        return extraFields.values();
    }

    public SDField getExtraField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public void addIndex(Index index) {
        this.indices.put(index.getName(), index);
    }

    public Index getIndex(String name) {
        ArrayList<Index> sameIndices = new ArrayList<Index>(1);
        Index searchIndex = this.indices.get(name);
        if (searchIndex != null) {
            sameIndices.add(searchIndex);
        }
        for (SDField field : this.allConcreteFields()) {
            Index index = field.getIndex(name);
            if (index == null) continue;
            sameIndices.add(index);
        }
        if (sameIndices.size() == 0) {
            return null;
        }
        if (sameIndices.size() == 1) {
            return (Index)sameIndices.get(0);
        }
        return this.consolidateIndices(sameIndices);
    }

    public boolean existsIndex(String name) {
        if (this.indices.get(name) != null) {
            return true;
        }
        for (SDField field : this.allConcreteFields()) {
            if (!field.existsIndex(name)) continue;
            return true;
        }
        return false;
    }

    private Index consolidateIndices(List<Index> indices) {
        Index first = indices.get(0);
        Index consolidated = new Index(first.getName());
        consolidated.setRankType(first.getRankType());
        consolidated.setType(first.getType());
        for (Index current : indices) {
            if (current.isPrefix()) {
                consolidated.setPrefix(true);
            }
            if (consolidated.getRankType() == null) {
                consolidated.setRankType(current.getRankType());
            } else if (current.getRankType() != null && !consolidated.getRankType().equals((Object)current.getRankType())) {
                log.warning("Conflicting rank type settings for " + first.getName() + " in " + this + ", using " + consolidated.getRankType());
            }
            Iterator<String> j = current.aliasIterator();
            while (j.hasNext()) {
                consolidated.addAlias(j.next());
            }
        }
        return consolidated;
    }

    public List<Index> getExplicitIndices() {
        ArrayList<Index> allIndices = new ArrayList<Index>(this.indices.values());
        for (SDField field : this.allConcreteFields()) {
            for (Index index : field.getIndices().values()) {
                allIndices.add(index);
            }
        }
        return Collections.unmodifiableList(allIndices);
    }

    public void addSummary(DocumentSummary summary) {
        this.summaries.put(summary.getName(), summary);
    }

    public DocumentSummary getSummary(String name) {
        return this.summaries.get(name);
    }

    public SummaryField getSummaryField(String name) {
        for (DocumentSummary summary : this.summaries.values()) {
            SummaryField summaryField = summary.getSummaryField(name);
            if (summaryField == null) continue;
            return summaryField;
        }
        return null;
    }

    public SummaryField getExplicitSummaryField(String name) {
        for (DocumentSummary summary : this.summaries.values()) {
            SummaryField summaryField = summary.getSummaryField(name);
            if (summaryField == null || summaryField.isImplicit()) continue;
            return summaryField;
        }
        return null;
    }

    public Map<String, DocumentSummary> getSummaries() {
        return this.summaries;
    }

    @Override
    public Map<String, SummaryField> getSummaryFields(ImmutableSDField field) {
        LinkedHashMap<String, SummaryField> summaryFields = new LinkedHashMap<String, SummaryField>();
        for (DocumentSummary documentSummary : this.summaries.values()) {
            for (SummaryField summaryField : documentSummary.getSummaryFields()) {
                if (!summaryField.hasSource(field.getName())) continue;
                summaryFields.put(summaryField.getName(), summaryField);
            }
        }
        return summaryFields;
    }

    public Map<String, SummaryField> getUniqueNamedSummaryFields() {
        LinkedHashMap<String, SummaryField> summaryFields = new LinkedHashMap<String, SummaryField>();
        for (DocumentSummary documentSummary : this.summaries.values()) {
            for (SummaryField summaryField : documentSummary.getSummaryFields()) {
                summaryFields.put(summaryField.getName(), summaryField);
            }
        }
        return summaryFields;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Attribute getAttribute(String name) {
        for (SDField field : this.allConcreteFields()) {
            Attribute attribute = field.getAttributes().get(name);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Search)) {
            return false;
        }
        Search other = (Search)o;
        return this.getName().equals(other.getName());
    }

    public String toString() {
        return "search definition '" + this.getName() + "'";
    }

    public boolean isAccessingDiskSummary(SummaryField field) {
        if (!field.getTransform().isInMemory()) {
            return true;
        }
        if (field.getSources().size() == 0) {
            return this.isAccessingDiskSummary(this.getName());
        }
        for (SummaryField.Source source : field.getSources()) {
            if (!this.isAccessingDiskSummary(source.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isAccessingDiskSummary(String source) {
        SDField field = this.getConcreteField(source);
        if (field == null) {
            return false;
        }
        return field.doesSummarying() && !field.doesAttributing();
    }

    public FieldSets fieldSets() {
        return this.fieldSets;
    }

    public Search addType(SDDocumentType dt) {
        this.docType.addType(dt);
        return this;
    }

    public Search addAnnotation(SDAnnotationType dt) {
        this.docType.addAnnotation(dt);
        return this;
    }
}

