/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.derived.SummaryMap;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.SummarymapConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class SearchCluster
extends AbstractConfigProducer<SearchCluster>
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
SchemaInfoConfig.Producer {
    private final String clusterName;
    private int index;
    private Double queryTimeout;
    private Double visibilityDelay = 0.0;
    private final Map<String, SchemaInfo> schemas = new LinkedHashMap<String, SchemaInfo>();

    public SearchCluster(AbstractConfigProducer<?> parent, String clusterName, int index) {
        super(parent, "cluster." + clusterName);
        this.clusterName = clusterName;
        this.index = index;
    }

    public void add(SchemaInfo schema) {
        this.schemas.put(schema.name(), schema);
    }

    public Map<String, SchemaInfo> schemas() {
        return Collections.unmodifiableMap(this.schemas);
    }

    public abstract void deriveFromSchemas(DeployState var1);

    protected void convertSummaryConfig(SummaryConfig.Producer summaryConfigProducer, SummarymapConfig.Producer summarymapConfigProducer, DocumentdbInfoConfig.Documentdb.Builder docDb) {
        SummaryConfig.Builder summaryConfigBuilder = new SummaryConfig.Builder();
        summaryConfigProducer.getConfig(summaryConfigBuilder);
        SummaryConfig summaryConfig = summaryConfigBuilder.build();
        SummarymapConfig summarymapConfig = null;
        if (summarymapConfigProducer != null) {
            SummarymapConfig.Builder summarymapConfigBuilder = new SummarymapConfig.Builder();
            summarymapConfigProducer.getConfig(summarymapConfigBuilder);
            summarymapConfig = summarymapConfigBuilder.build();
        }
        for (SummaryConfig.Classes sclass : summaryConfig.classes()) {
            DocumentdbInfoConfig.Documentdb.Summaryclass.Builder sumClassBuilder = new DocumentdbInfoConfig.Documentdb.Summaryclass.Builder();
            sumClassBuilder.id(sclass.id()).name(sclass.name());
            for (SummaryConfig.Classes.Fields field : sclass.fields()) {
                DocumentdbInfoConfig.Documentdb.Summaryclass.Fields.Builder fieldsBuilder = new DocumentdbInfoConfig.Documentdb.Summaryclass.Fields.Builder();
                fieldsBuilder.name(field.name()).type(field.type()).dynamic(this.isDynamic(field.name(), summarymapConfig));
                sumClassBuilder.fields(fieldsBuilder);
            }
            docDb.summaryclass(sumClassBuilder);
        }
    }

    private boolean isDynamic(String fieldName, SummarymapConfig summarymapConfig) {
        if (summarymapConfig == null) {
            return false;
        }
        for (SummarymapConfig.Override override : summarymapConfig.override()) {
            if (!fieldName.equals(override.field()) || !SummaryMap.isDynamicCommand(override.command())) continue;
            return true;
        }
        return false;
    }

    protected void addRankProfilesConfig(String schemaName, DocumentdbInfoConfig.Documentdb.Builder docDbBuilder) {
        for (SchemaInfo.RankProfileInfo rankProfile : this.schemas().get(schemaName).rankProfiles().values()) {
            DocumentdbInfoConfig.Documentdb.Rankprofile.Builder rankProfileConfig = new DocumentdbInfoConfig.Documentdb.Rankprofile.Builder();
            rankProfileConfig.name(rankProfile.name());
            rankProfileConfig.hasSummaryFeatures(rankProfile.hasSummaryFeatures());
            rankProfileConfig.hasRankFeatures(rankProfile.hasRankFeatures());
            for (Map.Entry<Reference, RankProfile.Input> input : rankProfile.inputs().entrySet()) {
                DocumentdbInfoConfig.Documentdb.Rankprofile.Input.Builder inputConfig = new DocumentdbInfoConfig.Documentdb.Rankprofile.Input.Builder();
                inputConfig.name(input.getKey().toString());
                inputConfig.type(input.getValue().type().toString());
                rankProfileConfig.input(inputConfig);
            }
            docDbBuilder.rankprofile(rankProfileConfig);
        }
    }

    public List<String> getDocumentNames() {
        return this.schemas.values().stream().map(schema -> schema.fullSchema().getDocument().getDocumentName().getName()).collect(Collectors.toList());
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public final String getIndexingModeName() {
        return this.getIndexingMode().getName();
    }

    public final boolean isStreaming() {
        return this.getIndexingMode() == IndexingMode.STREAMING;
    }

    public final void setQueryTimeout(Double to) {
        this.queryTimeout = to;
    }

    public final void setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
    }

    protected abstract IndexingMode getIndexingMode();

    public final Double getVisibilityDelay() {
        return this.visibilityDelay;
    }

    public final Double getQueryTimeout() {
        return this.queryTimeout;
    }

    public abstract int getRowBits();

    public final void setClusterIndex(int index) {
        this.index = index;
    }

    public final int getClusterIndex() {
        return this.index;
    }

    public abstract void defaultDocumentsConfig();

    public abstract void getConfig(AttributesConfig.Builder var1);

    public abstract void getConfig(RankProfilesConfig.Builder var1);

    public String toString() {
        return "search-capable cluster '" + this.clusterName + "'";
    }

    public static final class IndexingMode {
        public static final IndexingMode REALTIME = new IndexingMode("REALTIME");
        public static final IndexingMode STREAMING = new IndexingMode("STREAMING");
        private final String name;

        private IndexingMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "indexingmode: " + this.name;
        }
    }
}

