/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolImpl;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.Optional;
import org.w3c.dom.Element;

public class ContainerThreadpool
extends SimpleComponent
implements ContainerThreadpoolConfig.Producer {
    private final String name;
    private final UserOptions userOptions;

    public ContainerThreadpool(String name, UserOptions userOptions) {
        super(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)("threadpool@" + name), (String)ContainerThreadpoolImpl.class.getName(), null)));
        this.name = name;
        this.userOptions = userOptions;
    }

    public void getConfig(ContainerThreadpoolConfig.Builder builder) {
        builder.name(this.name);
        if (this.userOptions != null) {
            builder.maxThreads(this.userOptions.maxThreads);
            builder.minThreads(this.userOptions.minThreads);
            builder.queueSize(this.userOptions.queueSize);
        }
    }

    protected Optional<UserOptions> userOptions() {
        return Optional.ofNullable(this.userOptions);
    }

    protected boolean hasUserOptions() {
        return this.userOptions().isPresent();
    }

    public static class UserOptions {
        private final int maxThreads;
        private final int minThreads;
        private final int queueSize;

        private UserOptions(int maxThreads, int minThreads, int queueSize) {
            this.maxThreads = maxThreads;
            this.minThreads = minThreads;
            this.queueSize = queueSize;
        }

        public static Optional<UserOptions> fromXml(Element xml) {
            Element element = XML.getChild((Element)xml, (String)"threadpool");
            if (element == null) {
                return Optional.empty();
            }
            return Optional.of(new UserOptions(UserOptions.intOption(element, "max-threads"), UserOptions.intOption(element, "min-threads"), UserOptions.intOption(element, "queue-size")));
        }

        private static int intOption(Element element, String name) {
            return Integer.parseInt(XML.getChild((Element)element, (String)name).getTextContent());
        }
    }
}

