/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.collections.Pair;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodesSpecification {
    private final ClusterResources min;
    private final ClusterResources max;
    private final boolean dedicated;
    private final Version version;
    private final boolean required;
    private final boolean canFail;
    private final boolean exclusive;
    private final Optional<DockerImage> dockerImageRepo;
    private final Optional<String> combinedId;
    private final Optional<CloudAccount> cloudAccount;

    private NodesSpecification(ClusterResources min, ClusterResources max, boolean dedicated, Version version, boolean required, boolean canFail, boolean exclusive, Optional<DockerImage> dockerImageRepo, Optional<String> combinedId, Optional<CloudAccount> cloudAccount) {
        if (max.smallerThan(min)) {
            throw new IllegalArgumentException("Min resources must be larger or equal to max resources, but " + max + " is smaller than " + min);
        }
        if (!min.nodeResources().justNonNumbers().equals((Object)max.nodeResources().justNonNumbers())) {
            throw new IllegalArgumentException("Min and max resources must have the same non-numeric settings, but min is " + min + " and max " + max);
        }
        if (min.nodeResources().bandwidthGbps() != max.nodeResources().bandwidthGbps()) {
            throw new IllegalArgumentException("Min and max resources must have the same bandwidth, but min is " + min + " and max " + max);
        }
        this.min = min;
        this.max = max;
        this.dedicated = dedicated;
        this.version = version;
        this.required = required;
        this.canFail = canFail;
        this.exclusive = exclusive;
        this.dockerImageRepo = dockerImageRepo;
        this.combinedId = combinedId;
        this.cloudAccount = cloudAccount;
    }

    private static NodesSpecification create(boolean dedicated, boolean canFail, Version version, ModelElement nodesElement, Optional<DockerImage> dockerImageRepo, Optional<CloudAccount> cloudAccount) {
        ModelElement resolvedElement = NodesSpecification.resolveElement(nodesElement);
        Optional<String> combinedId = NodesSpecification.findCombinedId(nodesElement, resolvedElement);
        Pair<ClusterResources, ClusterResources> resources = NodesSpecification.toResources(resolvedElement);
        return new NodesSpecification((ClusterResources)resources.getFirst(), (ClusterResources)resources.getSecond(), dedicated, version, resolvedElement.booleanAttribute("required", false), canFail, resolvedElement.booleanAttribute("exclusive", false), NodesSpecification.dockerImageToUse(resolvedElement, dockerImageRepo), combinedId, cloudAccount);
    }

    private static Pair<ClusterResources, ClusterResources> toResources(ModelElement nodesElement) {
        Pair<Integer, Integer> nodes = NodesSpecification.toRange(nodesElement.stringAttribute("count"), 1, Integer::parseInt);
        Pair<Integer, Integer> groups = NodesSpecification.toRange(nodesElement.stringAttribute("groups"), 1, Integer::parseInt);
        ClusterResources min = new ClusterResources(((Integer)nodes.getFirst()).intValue(), ((Integer)groups.getFirst()).intValue(), (NodeResources)NodesSpecification.nodeResources(nodesElement).getFirst());
        ClusterResources max = new ClusterResources(((Integer)nodes.getSecond()).intValue(), ((Integer)groups.getSecond()).intValue(), (NodeResources)NodesSpecification.nodeResources(nodesElement).getSecond());
        return new Pair((Object)min, (Object)max);
    }

    private static Optional<String> findCombinedId(ModelElement nodesElement, ModelElement resolvedElement) {
        if (resolvedElement != nodesElement) {
            return NodesSpecification.containerIdOf(nodesElement);
        }
        return NodesSpecification.containerIdReferencing(nodesElement);
    }

    public static NodesSpecification from(ModelElement nodesElement, ConfigModelContext context) {
        return NodesSpecification.create(true, !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement, context.getDeployState().getWantedDockerImageRepo(), context.getDeployState().getProperties().cloudAccount());
    }

    public static Optional<NodesSpecification> fromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.child("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(NodesSpecification.from(nodesElement, context));
    }

    public static Optional<NodesSpecification> optionalDedicatedFromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.child("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(NodesSpecification.create(nodesElement.booleanAttribute("dedicated", false), !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement, context.getDeployState().getWantedDockerImageRepo(), context.getDeployState().getProperties().cloudAccount()));
    }

    public static NodesSpecification nonDedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(new ClusterResources(count, 1, NodeResources.unspecified()), new ClusterResources(count, 1, NodeResources.unspecified()), false, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, context.getDeployState().getWantedDockerImageRepo(), Optional.empty(), context.getDeployState().getProperties().cloudAccount());
    }

    public static NodesSpecification dedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(new ClusterResources(count, 1, NodeResources.unspecified()), new ClusterResources(count, 1, NodeResources.unspecified()), true, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, context.getDeployState().getWantedDockerImageRepo(), Optional.empty(), context.getDeployState().getProperties().cloudAccount());
    }

    public static NodesSpecification requiredFromSharedParents(int count, NodeResources resources, ModelElement element, ConfigModelContext context) {
        List allContent = NodesSpecification.findParentByTag("services", element.getXml()).map(services -> XML.getChildren((Element)services, (String)"content")).orElse(List.of()).stream().map(content -> new ModelElement((Element)content).child("nodes")).filter(nodes -> nodes != null && nodes.stringAttribute("count") != null).map(nodes -> NodesSpecification.from(nodes, context)).collect(Collectors.toList());
        return new NodesSpecification(new ClusterResources(count, 1, resources), new ClusterResources(count, 1, resources), true, context.getDeployState().getWantedNodeVespaVersion(), allContent.stream().anyMatch(content -> content.required), !context.getDeployState().getProperties().isBootstrap(), false, context.getDeployState().getWantedDockerImageRepo(), Optional.empty(), context.getDeployState().getProperties().cloudAccount());
    }

    public ClusterResources minResources() {
        return this.min;
    }

    public ClusterResources maxResources() {
        return this.max;
    }

    public boolean isDedicated() {
        return this.dedicated;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public Map<HostResource, ClusterMembership> provision(HostSystem hostSystem, ClusterSpec.Type clusterType, ClusterSpec.Id clusterId, DeployLogger logger, boolean stateful) {
        if (this.combinedId.isPresent()) {
            clusterType = ClusterSpec.Type.combined;
        }
        ClusterSpec cluster = ClusterSpec.request((ClusterSpec.Type)clusterType, (ClusterSpec.Id)clusterId).vespaVersion(this.version).exclusive(this.exclusive).combinedId(this.combinedId.map(ClusterSpec.Id::from)).dockerImageRepository(this.dockerImageRepo).stateful(stateful).build();
        return hostSystem.allocateHosts(cluster, Capacity.from((ClusterResources)this.min, (ClusterResources)this.max, (boolean)this.required, (boolean)this.canFail, this.cloudAccount), logger);
    }

    private static Pair<NodeResources, NodeResources> nodeResources(ModelElement nodesElement) {
        ModelElement resources = nodesElement.child("resources");
        if (resources != null) {
            return NodesSpecification.nodeResourcesFromResourcesElement(resources);
        }
        if (nodesElement.stringAttribute("flavor") != null) {
            NodeResources flavorResources = NodeResources.fromLegacyName((String)nodesElement.stringAttribute("flavor"));
            return new Pair((Object)flavorResources, (Object)flavorResources);
        }
        return new Pair((Object)NodeResources.unspecified(), (Object)NodeResources.unspecified());
    }

    private static Pair<NodeResources, NodeResources> nodeResourcesFromResourcesElement(ModelElement element) {
        Pair<Double, Double> vcpu = NodesSpecification.toRange(element.requiredStringAttribute("vcpu"), 0.0, Double::parseDouble);
        Pair<Double, Double> memory = NodesSpecification.toRange(element.requiredStringAttribute("memory"), 0.0, s -> NodesSpecification.parseGbAmount(s, "B"));
        Pair<Double, Double> disk = NodesSpecification.toRange(element.requiredStringAttribute("disk"), 0.0, s -> NodesSpecification.parseGbAmount(s, "B"));
        Pair<Double, Double> bandwith = NodesSpecification.toRange(element.stringAttribute("bandwidth"), 0.3, s -> NodesSpecification.parseGbAmount(s, "BPS"));
        NodeResources.DiskSpeed diskSpeed = NodesSpecification.parseOptionalDiskSpeed(element.stringAttribute("disk-speed"));
        NodeResources.StorageType storageType = NodesSpecification.parseOptionalStorageType(element.stringAttribute("storage-type"));
        NodeResources.Architecture architecture = NodesSpecification.parseOptionalArchitecture(element.stringAttribute("architecture"));
        NodeResources min = new NodeResources(((Double)vcpu.getFirst()).doubleValue(), ((Double)memory.getFirst()).doubleValue(), ((Double)disk.getFirst()).doubleValue(), ((Double)bandwith.getFirst()).doubleValue(), diskSpeed, storageType, architecture);
        NodeResources max = new NodeResources(((Double)vcpu.getSecond()).doubleValue(), ((Double)memory.getSecond()).doubleValue(), ((Double)disk.getSecond()).doubleValue(), ((Double)bandwith.getSecond()).doubleValue(), diskSpeed, storageType, architecture);
        return new Pair((Object)min, (Object)max);
    }

    private static double parseGbAmount(String byteAmount, String unit) {
        byteAmount = byteAmount.strip();
        if ((byteAmount = byteAmount.toUpperCase()).endsWith(unit)) {
            byteAmount = byteAmount.substring(0, byteAmount.length() - unit.length());
        }
        double multiplier = Math.pow(1000.0, -3.0);
        if (byteAmount.endsWith("K")) {
            multiplier = Math.pow(1000.0, -2.0);
        } else if (byteAmount.endsWith("M")) {
            multiplier = Math.pow(1000.0, -1.0);
        } else if (byteAmount.endsWith("G")) {
            multiplier = 1.0;
        } else if (byteAmount.endsWith("T")) {
            multiplier = 1000.0;
        } else if (byteAmount.endsWith("P")) {
            multiplier = Math.pow(1000.0, 2.0);
        } else if (byteAmount.endsWith("E")) {
            multiplier = Math.pow(1000.0, 3.0);
        } else if (byteAmount.endsWith("Z")) {
            multiplier = Math.pow(1000.0, 4.0);
        } else if (byteAmount.endsWith("Y")) {
            multiplier = Math.pow(1000.0, 5.0);
        }
        byteAmount = byteAmount.substring(0, byteAmount.length() - 1).strip();
        try {
            return Double.parseDouble(byteAmount) * multiplier;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid byte amount '" + byteAmount + "': Must be a floating point number optionally followed by k, M, G, T, P, E, Z or Y");
        }
    }

    private static NodeResources.DiskSpeed parseOptionalDiskSpeed(String diskSpeedString) {
        if (diskSpeedString == null) {
            return NodeResources.DiskSpeed.getDefault();
        }
        switch (diskSpeedString) {
            case "fast": {
                return NodeResources.DiskSpeed.fast;
            }
            case "slow": {
                return NodeResources.DiskSpeed.slow;
            }
            case "any": {
                return NodeResources.DiskSpeed.any;
            }
        }
        throw new IllegalArgumentException("Illegal disk-speed value '" + diskSpeedString + "': Legal values are 'fast', 'slow' and 'any')");
    }

    private static NodeResources.StorageType parseOptionalStorageType(String storageTypeString) {
        if (storageTypeString == null) {
            return NodeResources.StorageType.getDefault();
        }
        switch (storageTypeString) {
            case "remote": {
                return NodeResources.StorageType.remote;
            }
            case "local": {
                return NodeResources.StorageType.local;
            }
            case "any": {
                return NodeResources.StorageType.any;
            }
        }
        throw new IllegalArgumentException("Illegal storage-type value '" + storageTypeString + "': Legal values are 'remote', 'local' and 'any')");
    }

    private static NodeResources.Architecture parseOptionalArchitecture(String architecture) {
        if (architecture == null) {
            return NodeResources.Architecture.getDefault();
        }
        switch (architecture) {
            case "x86_64": {
                return NodeResources.Architecture.x86_64;
            }
            case "arm64": {
                return NodeResources.Architecture.arm64;
            }
            case "any": {
                return NodeResources.Architecture.any;
            }
        }
        throw new IllegalArgumentException("Illegal architecture value '" + architecture + "': Legal values are 'x86_64', 'arm64' and 'any')");
    }

    private static ModelElement resolveElement(ModelElement nodesElement) {
        Element element = nodesElement.getXml();
        String referenceId = element.getAttribute("of");
        if (referenceId.isEmpty()) {
            return nodesElement;
        }
        Element services = NodesSpecification.findParentByTag("services", element).orElseThrow(() -> NodesSpecification.clusterReferenceNotFoundException(referenceId));
        Element referencedService = NodesSpecification.findChildById(services, referenceId).orElseThrow(() -> NodesSpecification.clusterReferenceNotFoundException(referenceId));
        if (!referencedService.getTagName().equals("content")) {
            throw new IllegalArgumentException("service '" + referenceId + "' is not a content service");
        }
        Element referencedNodesElement = XML.getChild((Element)referencedService, (String)"nodes");
        if (referencedNodesElement == null) {
            throw new IllegalArgumentException("expected reference to service '" + referenceId + "' to supply nodes, but that service has no <nodes> element");
        }
        return new ModelElement(referencedNodesElement);
    }

    private static Optional<String> containerIdOf(ModelElement nodesElement) {
        Element element = nodesElement.getXml();
        for (String containerTag : List.of("container", "jdisc")) {
            Optional<Element> container = NodesSpecification.findParentByTag(containerTag, element);
            if (container.isEmpty()) continue;
            return container.map(el -> el.getAttribute("id"));
        }
        return Optional.empty();
    }

    private static Optional<String> containerIdReferencing(ModelElement nodesElement) {
        Element element = nodesElement.getXml();
        Optional<Element> services = NodesSpecification.findParentByTag("services", element);
        if (services.isEmpty()) {
            return Optional.empty();
        }
        Optional<Element> content = NodesSpecification.findParentByTag("content", element);
        if (content.isEmpty()) {
            return Optional.empty();
        }
        String contentClusterId = content.get().getAttribute("id");
        if (contentClusterId.isEmpty()) {
            return Optional.empty();
        }
        for (Element rootChild : XML.getChildren((Element)services.get())) {
            Element nodes;
            if (!ContainerModelBuilder.isContainerTag(rootChild) || (nodes = XML.getChild((Element)rootChild, (String)"nodes")) == null || !contentClusterId.equals(nodes.getAttribute("of"))) continue;
            return Optional.of(rootChild.getAttribute("id"));
        }
        return Optional.empty();
    }

    private static Optional<Element> findChildById(Element parent, String id) {
        for (Element child : XML.getChildren((Element)parent)) {
            if (!id.equals(child.getAttribute("id"))) continue;
            return Optional.of(child);
        }
        return Optional.empty();
    }

    private static Optional<Element> findParentByTag(String tag, Element element) {
        Node parent = element.getParentNode();
        if (parent == null) {
            return Optional.empty();
        }
        if (!(parent instanceof Element)) {
            return Optional.empty();
        }
        Element parentElement = (Element)parent;
        if (parentElement.getTagName().equals(tag)) {
            return Optional.of(parentElement);
        }
        return NodesSpecification.findParentByTag(tag, parentElement);
    }

    private static IllegalArgumentException clusterReferenceNotFoundException(String referenceId) {
        return new IllegalArgumentException("referenced service '" + referenceId + "' is not defined");
    }

    private static Optional<DockerImage> dockerImageToUse(ModelElement nodesElement, Optional<DockerImage> dockerImage) {
        String dockerImageFromElement = nodesElement.stringAttribute("docker-image");
        return dockerImageFromElement == null ? dockerImage : Optional.of(DockerImage.fromString((String)dockerImageFromElement));
    }

    private static <T> Pair<T, T> toRange(String s, T defaultValue, Function<String, T> valueParser) {
        try {
            if (s == null) {
                return new Pair(defaultValue, defaultValue);
            }
            if ((s = s.trim()).startsWith("[") && s.endsWith("]")) {
                String[] numbers = s.substring(1, s.length() - 1).split(",");
                if (numbers.length != 2) {
                    throw new IllegalArgumentException();
                }
                return new Pair(valueParser.apply(numbers[0].trim()), valueParser.apply(numbers[1].trim()));
            }
            return new Pair(valueParser.apply(s), valueParser.apply(s));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Expected a number or range on the form [min, max], but got '" + s + "'", e);
        }
    }

    public String toString() {
        return "specification of " + (this.dedicated ? "dedicated " : "") + (this.min.equals((Object)this.max) ? this.min : "min " + this.min + " max " + this.max);
    }
}

