/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configmodel.producers;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.config.DocumenttypesConfig;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.OwnedTemporaryType;
import com.yahoo.documentmodel.TemporaryUnknownType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.schema.document.FieldSet;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.documentmodel.DocumentModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocumentTypes {
    private boolean useV8GeoPositions = false;

    public DocumentTypes useV8GeoPositions(boolean value) {
        this.useV8GeoPositions = value;
        return this;
    }

    public DocumenttypesConfig.Builder produce(DocumentModel model, DocumenttypesConfig.Builder builder) {
        builder.usev8geopositions(this.useV8GeoPositions);
        HashMap<NewDocumentType.Name, NewDocumentType> produced = new HashMap<NewDocumentType.Name, NewDocumentType>();
        IdxMap indexMap = new IdxMap();
        for (NewDocumentType documentType : model.getDocumentManager().getTypes()) {
            this.docTypeInheritOrder(documentType, builder, produced, indexMap);
        }
        indexMap.verifyAllDone();
        return builder;
    }

    private static <T> List<T> sortedList(Collection<T> unsorted, Comparator<T> cmp) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(unsorted);
        list.sort(cmp);
        return list;
    }

    private void docTypeInheritOrder(NewDocumentType documentType, DocumenttypesConfig.Builder builder, Map<NewDocumentType.Name, NewDocumentType> produced, IdxMap indexMap) {
        if (!produced.containsKey(documentType.getFullName())) {
            for (NewDocumentType inherited : documentType.getInherited()) {
                this.docTypeInheritOrder(inherited, builder, produced, indexMap);
            }
            this.docTypeBuild(documentType, builder, indexMap);
            produced.put(documentType.getFullName(), documentType);
        }
    }

    private void docTypeBuild(NewDocumentType documentType, DocumenttypesConfig.Builder builder, IdxMap indexMap) {
        DocumenttypesConfig.Doctype.Builder db = new DocumenttypesConfig.Doctype.Builder();
        db.idx(indexMap.idxOf(documentType)).name(documentType.getName()).internalid(documentType.getId()).contentstruct(indexMap.idxOf(documentType.getContentStruct()));
        this.docTypeBuildFieldSets(documentType.getFieldSets(), db);
        this.docTypeBuildImportedFields(documentType.getImportedFieldNames(), db);
        for (NewDocumentType inherited : documentType.getInherited()) {
            db.inherits(b -> b.idx(indexMap.idxOf(inherited)));
        }
        this.docTypeBuildAnyType(documentType.getContentStruct(), db, indexMap);
        for (DataType dt : DocumentTypes.sortedList(documentType.getAllTypes().getTypes(), (a, b) -> a.getName().compareTo(b.getName()))) {
            this.docTypeBuildAnyType(dt, db, indexMap);
        }
        for (AnnotationType ann : DocumentTypes.sortedList(documentType.getAnnotations(), (a, b) -> a.getName().compareTo(b.getName()))) {
            this.docTypeBuildAnnotationType(ann, db, indexMap);
        }
        builder.doctype(db);
        indexMap.setDone(documentType);
    }

    private void docTypeBuildFieldSets(Set<FieldSet> fieldSets, DocumenttypesConfig.Doctype.Builder db) {
        for (FieldSet fs : fieldSets) {
            this.docTypeBuildOneFieldSet(fs, db);
        }
    }

    private void docTypeBuildOneFieldSet(FieldSet fs, DocumenttypesConfig.Doctype.Builder db) {
        db.fieldsets(fs.getName(), new DocumenttypesConfig.Doctype.Fieldsets.Builder().fields(fs.getFieldNames()));
    }

    private void docTypeBuildAnnotationType(AnnotationType annotation, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        if (indexMap.isDone(annotation)) {
            return;
        }
        indexMap.setDone(annotation);
        DocumenttypesConfig.Doctype.Annotationtype.Builder annBuilder = new DocumenttypesConfig.Doctype.Annotationtype.Builder();
        annBuilder.idx(indexMap.idxOf(annotation)).name(annotation.getName()).internalid(annotation.getId());
        DataType nested = annotation.getDataType();
        if (nested != null) {
            annBuilder.datatype(indexMap.idxOf(nested));
            this.docTypeBuildAnyType(nested, builder, indexMap);
        }
        for (AnnotationType inherited : annotation.getInheritedTypes()) {
            annBuilder.inherits(inhBuilder -> inhBuilder.idx(indexMap.idxOf(inherited)));
        }
        builder.annotationtype(annBuilder);
    }

    private void docTypeBuildAnyType(DataType type, DocumenttypesConfig.Doctype.Builder documentBuilder, IdxMap indexMap) {
        if (indexMap.isDone(type)) {
            return;
        }
        if (type instanceof NewDocumentType) {
            return;
        }
        if (type instanceof DocumentType && type.getId() == 8) {
            return;
        }
        indexMap.setDone(type);
        if (type instanceof TemporaryStructuredDataType) {
            throw new IllegalArgumentException("Can not create config for temporary data type: " + type.getName());
        }
        if (type instanceof TemporaryUnknownType) {
            throw new IllegalArgumentException("Can not create config for temporary data type: " + type.getName());
        }
        if (type instanceof OwnedTemporaryType) {
            throw new IllegalArgumentException("Can not create config for temporary data type: " + type.getName());
        }
        if (type instanceof StructDataType) {
            this.docTypeBuildOneType((StructDataType)type, documentBuilder, indexMap);
        } else if (type instanceof ArrayDataType) {
            this.docTypeBuildOneType((ArrayDataType)type, documentBuilder, indexMap);
        } else if (type instanceof WeightedSetDataType) {
            this.docTypeBuildOneType((WeightedSetDataType)type, documentBuilder, indexMap);
        } else if (type instanceof MapDataType) {
            this.docTypeBuildOneType((MapDataType)type, documentBuilder, indexMap);
        } else if (type instanceof AnnotationReferenceDataType) {
            this.docTypeBuildOneType((AnnotationReferenceDataType)type, documentBuilder, indexMap);
        } else if (type instanceof TensorDataType) {
            this.docTypeBuildOneType((TensorDataType)type, documentBuilder, indexMap);
        } else if (type instanceof NewDocumentReferenceDataType) {
            NewDocumentReferenceDataType refType = (NewDocumentReferenceDataType)type;
            if (refType.isTemporary()) {
                throw new IllegalArgumentException("Still temporary: " + refType);
            }
            this.docTypeBuildOneType(refType, documentBuilder, indexMap);
        } else if (type instanceof PrimitiveDataType) {
            this.docTypeBuildOneType((PrimitiveDataType)type, documentBuilder, indexMap);
        } else {
            if (type instanceof DocumentType) {
                throw new IllegalArgumentException("Can not create config for unadorned document type: " + type.getName() + " id " + type.getId());
            }
            throw new IllegalArgumentException("Can not create config for data type " + type + " of class " + type.getClass());
        }
    }

    private void docTypeBuildImportedFields(Collection<String> fieldNames, DocumenttypesConfig.Doctype.Builder builder) {
        for (String fieldName : fieldNames) {
            builder.importedfield(ib -> ib.name(fieldName));
        }
    }

    private void docTypeBuildOneType(StructDataType type, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        DocumenttypesConfig.Doctype.Structtype.Builder structBuilder = new DocumenttypesConfig.Doctype.Structtype.Builder();
        structBuilder.idx(indexMap.idxOf(type)).name(type.getName()).internalid(type.getId());
        for (DataType inherited : type.getInheritedTypes()) {
            structBuilder.inherits(inheritBuilder -> inheritBuilder.type(indexMap.idxOf(inherited)));
            this.docTypeBuildAnyType(inherited, builder, indexMap);
        }
        for (Field field : type.getFieldsThisTypeOnly()) {
            DataType fieldType = field.getDataType();
            structBuilder.field(fieldBuilder -> fieldBuilder.name(field.getName()).internalid(field.getId()).type(indexMap.idxOf(fieldType)));
            this.docTypeBuildAnyType(fieldType, builder, indexMap);
        }
        builder.structtype(structBuilder);
    }

    private void docTypeBuildOneType(PrimitiveDataType type, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.primitivetype(primBuilder -> primBuilder.idx(indexMap.idxOf(type)).name(type.getName()));
    }

    private void docTypeBuildOneType(TensorDataType type, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        TensorType tt = type.getTensorType();
        String detailed = tt != null ? tt.toString() : "tensor";
        builder.tensortype(tensorBuilder -> tensorBuilder.idx(indexMap.idxOf(type)).detailedtype(detailed));
    }

    private void docTypeBuildOneType(ArrayDataType type, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType nested = type.getNestedType();
        builder.arraytype(arrayBuilder -> arrayBuilder.idx(indexMap.idxOf(type)).elementtype(indexMap.idxOf(nested)).internalid(type.getId()));
        this.docTypeBuildAnyType(nested, builder, indexMap);
    }

    private void docTypeBuildOneType(WeightedSetDataType type, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType nested = type.getNestedType();
        builder.wsettype(wsetBuilder -> wsetBuilder.idx(indexMap.idxOf(type)).elementtype(indexMap.idxOf(nested)).createifnonexistent(type.createIfNonExistent()).removeifzero(type.removeIfZero()).internalid(type.getId()));
        this.docTypeBuildAnyType(nested, builder, indexMap);
    }

    private void docTypeBuildOneType(MapDataType type, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        DataType keytype = type.getKeyType();
        DataType valtype = type.getValueType();
        builder.maptype(mapBuilder -> mapBuilder.idx(indexMap.idxOf(type)).keytype(indexMap.idxOf(keytype)).valuetype(indexMap.idxOf(valtype)).internalid(type.getId()));
        this.docTypeBuildAnyType(keytype, builder, indexMap);
        this.docTypeBuildAnyType(valtype, builder, indexMap);
    }

    private void docTypeBuildOneType(AnnotationReferenceDataType type, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.annotationref(arefBuilder -> arefBuilder.idx(indexMap.idxOf(type)).annotationtype(indexMap.idxOf(type.getAnnotationType())).internalid(type.getId()));
    }

    private void docTypeBuildOneType(NewDocumentReferenceDataType type, DocumenttypesConfig.Doctype.Builder builder, IdxMap indexMap) {
        builder.documentref(docrefBuilder -> docrefBuilder.idx(indexMap.idxOf((Object)type)).targettype(indexMap.idxOf(type.getTargetType())).internalid(type.getId()));
    }

    private static class IdxMap {
        private Map<Integer, Boolean> doneMap = new HashMap<Integer, Boolean>();
        private Map<Object, Integer> map = new IdentityHashMap<Object, Integer>();

        private IdxMap() {
        }

        void add(Object someType) {
            assert (someType != null);
            int nextIdx = 10000 + this.map.size();
            this.map.computeIfAbsent(someType, k -> nextIdx);
        }

        int idxOf(Object someType) {
            DocumentType dt;
            if (someType instanceof DocumentType && (dt = (DocumentType)someType).getId() == 8) {
                return this.idxOf(VespaDocumentType.INSTANCE);
            }
            this.add(someType);
            return this.map.get(someType);
        }

        boolean isDone(Object someType) {
            return this.doneMap.computeIfAbsent(this.idxOf(someType), k -> false);
        }

        void setDone(Object someType) {
            assert (!this.isDone(someType));
            this.doneMap.put(this.idxOf(someType), true);
        }

        void verifyAllDone() {
            for (Map.Entry<Object, Integer> entry : this.map.entrySet()) {
                Object needed = entry.getKey();
                if (this.isDone(needed)) continue;
                throw new IllegalArgumentException("Could not generate config for all needed types, missing: " + needed + " of class " + needed.getClass());
            }
        }
    }
}

