/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.PositionDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ComplexAttributeFieldUtils;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.logging.Level;

public class ImplicitSummaries
extends Processor {
    public ImplicitSummaries(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        DocumentSummary defaultSummary = this.schema.getSummariesInThis().get("default");
        if (defaultSummary == null) {
            defaultSummary = new DocumentSummary("default", this.schema);
            defaultSummary.setFromDisk(true);
            this.schema.addSummary(defaultSummary);
        }
        for (SDField field : this.schema.allConcreteFields()) {
            this.collectSummaries(field, this.schema, validate);
        }
        for (DocumentSummary documentSummary : this.schema.getSummaries().values()) {
            documentSummary.purgeImplicits();
        }
    }

    private void addSummaryFieldSources(SummaryField summaryField, SDField sdField) {
        sdField.addSummaryFieldSources(summaryField);
    }

    private void collectSummaries(SDField field, Schema schema, boolean validate) {
        SummaryField addedSummaryField = null;
        String fieldName = field.getName();
        SummaryField fieldSummaryField = field.getSummaryField(fieldName);
        if (fieldSummaryField == null && field.doesSummarying()) {
            fieldSummaryField = new SummaryField(fieldName, field.getDataType());
            fieldSummaryField.setImplicit(true);
            this.addSummaryFieldSources(fieldSummaryField, field);
            fieldSummaryField.addDestination("default");
            field.addSummaryField(fieldSummaryField);
            addedSummaryField = fieldSummaryField;
        }
        if (fieldSummaryField != null) {
            for (String dest : fieldSummaryField.getDestinations()) {
                DocumentSummary summary = schema.getSummariesInThis().get(dest);
                if (summary == null) continue;
                summary.add(fieldSummaryField);
            }
        }
        for (Attribute attribute : field.getAttributes().values()) {
            if (!attribute.getName().equals(fieldName)) continue;
            if (addedSummaryField != null) {
                addedSummaryField.setTransform(SummaryTransform.ATTRIBUTE);
            }
            if (!attribute.isPrefetch()) continue;
            this.addPrefetchAttribute(attribute, field, schema);
        }
        if (addedSummaryField != null && ComplexAttributeFieldUtils.isComplexFieldWithOnlyStructFieldAttributes(field)) {
            addedSummaryField.setTransform(SummaryTransform.ATTRIBUTECOMBINER);
        }
        if (field.doesSummarying()) {
            for (Attribute attribute : field.getAttributes().values()) {
                SummaryField posField;
                if (!attribute.isPosition()) continue;
                SummaryField distField = field.getSummaryField(PositionDataType.getDistanceSummaryFieldName((String)fieldName));
                if (distField != null) {
                    DocumentSummary attributePrefetchSummary = this.getOrCreateAttributePrefetchSummary(schema);
                    attributePrefetchSummary.add(distField);
                }
                if ((posField = field.getSummaryField(PositionDataType.getPositionSummaryFieldName((String)fieldName))) == null) continue;
                DocumentSummary attributePrefetchSummary = this.getOrCreateAttributePrefetchSummary(schema);
                attributePrefetchSummary.add(posField);
            }
        }
        for (SummaryField summaryField : field.getSummaryFields().values()) {
            Attribute attribute = field.getAttributes().get(fieldName);
            if (attribute != null && summaryField.getTransform() == SummaryTransform.NONE) {
                summaryField.setTransform(SummaryTransform.ATTRIBUTE);
            }
            if (!this.isValid(summaryField, schema, validate)) continue;
            this.addToDestinations(summaryField, schema);
        }
    }

    private DocumentSummary getOrCreateAttributePrefetchSummary(Schema schema) {
        DocumentSummary summary = schema.getSummariesInThis().get("attributeprefetch");
        if (summary == null) {
            summary = new DocumentSummary("attributeprefetch", schema);
            schema.addSummary(summary);
        }
        return summary;
    }

    private void addPrefetchAttribute(Attribute attribute, SDField field, Schema schema) {
        if (attribute.getPrefetchValue() == null) {
            SummaryField fieldSummaryField = field.getSummaryField(attribute.getName());
            if (fieldSummaryField != null && fieldSummaryField.getTransform().isDynamic()) {
                return;
            }
            SummaryField explicitSummaryField = schema.getExplicitSummaryField(attribute.getName());
            if (explicitSummaryField != null && explicitSummaryField.getTransform().isDynamic()) {
                return;
            }
        }
        DocumentSummary summary = this.getOrCreateAttributePrefetchSummary(schema);
        SummaryField attributeSummaryField = new SummaryField(attribute.getName(), attribute.getDataType());
        attributeSummaryField.addSource(attribute.getName());
        attributeSummaryField.addDestination("attributeprefetch");
        attributeSummaryField.setTransform(SummaryTransform.ATTRIBUTE);
        summary.add(attributeSummaryField);
    }

    private boolean isValid(SummaryField summaryField, Schema schema, boolean validate) {
        Attribute attribute;
        if (summaryField.getTransform() == SummaryTransform.DISTANCE || summaryField.getTransform() == SummaryTransform.POSITIONS) {
            int sourceCount = summaryField.getSourceCount();
            if (validate && sourceCount != 1) {
                throw this.newProcessException(schema.getName(), summaryField.getName(), "Expected 1 source field, got " + sourceCount + ".");
            }
            String sourceName = summaryField.getSingleSource();
            if (validate && schema.getAttribute(sourceName) == null) {
                throw this.newProcessException(schema.getName(), summaryField.getName(), "Summary source attribute '" + sourceName + "' not found.");
            }
            return true;
        }
        String fieldName = summaryField.getSourceField();
        SDField sourceField = schema.getConcreteField(fieldName);
        if (validate && sourceField == null) {
            throw this.newProcessException(schema, summaryField, "Source field '" + fieldName + "' does not exist.");
        }
        if (!sourceField.doesSummarying() && summaryField.getTransform() != SummaryTransform.ATTRIBUTE && summaryField.getTransform() != SummaryTransform.GEOPOS) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Ignoring " + summaryField + ": " + sourceField + " is not creating a summary value in its indexing statement");
            return false;
        }
        if (summaryField.getTransform().isDynamic() && summaryField.getName().equals(sourceField.getName()) && sourceField.doesAttributing() && (attribute = sourceField.getAttributes().get(sourceField.getName())) != null) {
            Object destinations = "document summary 'default'";
            if (summaryField.getDestinations().size() > 0) {
                destinations = "document summaries " + summaryField.getDestinations();
            }
            this.deployLogger.logApplicationPackage(Level.WARNING, "Will fetch the disk summary value of " + sourceField + " in " + (String)destinations + " since this summary field uses a dynamic summary value (snippet/bolding): Dynamic summaries and bolding is not supported with summary values fetched from in-memory attributes yet. If you want to see partial updates to this attribute, remove any bolding and dynamic snippeting from this field");
        }
        return true;
    }

    private void addToDestinations(SummaryField summaryField, Schema schema) {
        if (summaryField.getDestinations().size() == 0) {
            this.addToDestination("default", summaryField, schema);
        } else {
            for (String destinationName : summaryField.getDestinations()) {
                this.addToDestination(destinationName, summaryField, schema);
            }
        }
    }

    private void addToDestination(String destinationName, SummaryField summaryField, Schema schema) {
        DocumentSummary destination = schema.getSummariesInThis().get(destinationName);
        if (destination == null) {
            destination = new DocumentSummary(destinationName, schema);
            schema.addSummary(destination);
            destination.add(summaryField);
        } else {
            SummaryField existingField = destination.getSummaryField(summaryField.getName());
            SummaryField merged = summaryField.mergeWith(existingField);
            destination.add(merged);
        }
    }
}

