/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.GeoPos;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AdjustPositionSummaryFields
extends Processor {
    private boolean useV8GeoPositions = false;

    public AdjustPositionSummaryFields(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly, ModelContext.Properties properties) {
        this.useV8GeoPositions = properties.featureFlags().useV8GeoPositions();
        this.process(validate, documentsOnly);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (DocumentSummary summary : this.schema.getSummaries().values()) {
            this.scanSummary(summary);
        }
    }

    private void scanSummary(DocumentSummary summary) {
        for (SummaryField summaryField : summary.getSummaryFields().values()) {
            ImmutableSDField sourceField;
            String originalSource;
            if (!GeoPos.isAnyPos(summaryField.getDataType()) || (originalSource = summaryField.getSingleSource()).indexOf(46) != -1 || (sourceField = this.schema.getField(originalSource)) == null) continue;
            String zCurve = null;
            if (sourceField.getDataType().equals((Object)summaryField.getDataType())) {
                zCurve = PositionDataType.getZCurveFieldName((String)originalSource);
            } else if (sourceField.getDataType().equals((Object)AdjustPositionSummaryFields.makeZCurveDataType(summaryField.getDataType())) && AdjustPositionSummaryFields.hasZCurveSuffix(originalSource)) {
                zCurve = originalSource;
            }
            if (zCurve == null) continue;
            if (this.hasPositionAttribute(zCurve)) {
                SummaryField.Source source = new SummaryField.Source(zCurve);
                this.adjustPositionField(summary, summaryField, source);
                continue;
            }
            if (!sourceField.isImportedField() && summaryField.getName().equals(originalSource)) continue;
            this.fail(summaryField, "No position attribute '" + zCurve + "'");
        }
    }

    private void adjustPositionField(DocumentSummary summary, SummaryField summaryField, SummaryField.Source source) {
        summaryField.setTransform(SummaryTransform.GEOPOS);
        summaryField.getSources().clear();
        summaryField.addSource(source);
        this.ensureSummaryField(summary, PositionDataType.getPositionSummaryFieldName((String)summaryField.getName()), (DataType)DataType.getArray((DataType)DataType.STRING), source, SummaryTransform.POSITIONS);
        this.ensureSummaryField(summary, PositionDataType.getDistanceSummaryFieldName((String)summaryField.getName()), (DataType)DataType.INT, source, SummaryTransform.DISTANCE);
    }

    private void ensureSummaryField(DocumentSummary summary, String fieldName, DataType dataType, SummaryField.Source source, SummaryTransform transform) {
        SummaryField oldField = this.schema.getSummaryField(fieldName);
        if (oldField == null) {
            if (this.useV8GeoPositions) {
                return;
            }
            SummaryField newField = new SummaryField(fieldName, dataType, transform);
            newField.addSource(source);
            summary.add(newField);
            return;
        }
        if (!oldField.getDataType().equals((Object)dataType)) {
            this.fail(oldField, "exists with type '" + oldField.getDataType().toString() + "', should be of type '" + dataType.toString() + "'");
        }
        if (oldField.getTransform() != transform) {
            this.fail(oldField, "has summary transform '" + oldField.getTransform().toString() + "', should have transform '" + transform.toString() + "'");
        }
        if (oldField.getSourceCount() != 1 || !oldField.getSingleSource().equals(source.getName())) {
            this.fail(oldField, "has source '" + oldField.getSources().toString() + "', should have source '" + source + "'");
        }
        if (this.useV8GeoPositions) {
            return;
        }
        summary.add(oldField);
    }

    private boolean hasPositionAttribute(String name) {
        ImmutableSDField field;
        Attribute attribute = this.schema.getAttribute(name);
        if (attribute == null && (field = this.schema.getField(name)) != null && field.isImportedField()) {
            attribute = field.getAttribute();
        }
        return attribute != null && attribute.isPosition();
    }

    private static boolean hasZCurveSuffix(String name) {
        String suffix = PositionDataType.getZCurveFieldName((String)"");
        return name.length() > suffix.length() && name.substring(name.length() - suffix.length()).equals(suffix);
    }

    private static DataType makeZCurveDataType(DataType dataType) {
        return dataType instanceof ArrayDataType ? DataType.getArray((DataType)DataType.LONG) : DataType.LONG;
    }

    private void fail(SummaryField summaryField, String msg) {
        throw this.newProcessException(this.schema.getName(), summaryField.getName(), msg);
    }
}

