/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.document;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Float16FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.Dictionary;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.schema.document.Sorting;
import com.yahoo.tensor.TensorType;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class Attribute
implements Cloneable,
Serializable {
    private String name;
    private Type type;
    private CollectionType collectionType;
    private boolean removeIfZero = false;
    private boolean createIfNonExistent = false;
    private boolean enableBitVectors = false;
    private boolean enableOnlyBitVector = false;
    private boolean fastRank = false;
    private boolean fastSearch = false;
    private boolean fastAccess = false;
    private boolean huge = false;
    private boolean mutable = false;
    private boolean paged = false;
    private int arity = 8;
    private long lowerBound = Long.MIN_VALUE;
    private long upperBound = Long.MAX_VALUE;
    private double densePostingListThreshold = 0.4;
    private Optional<TensorType> tensorType = Optional.empty();
    private final Optional<StructuredDataType> referenceDocumentType;
    private Optional<DistanceMetric> distanceMetric = Optional.empty();
    private Optional<HnswIndexParams> hnswIndexParams = Optional.empty();
    private boolean isPosition = false;
    private final Sorting sorting = new Sorting();
    private final Set<String> aliases = new LinkedHashSet<String>();
    private Dictionary dictionary = null;
    private Case casing = Case.UNCASED;
    private Boolean prefetch = null;
    public static final DistanceMetric DEFAULT_DISTANCE_METRIC = DistanceMetric.EUCLIDEAN;

    public Attribute(String name, DataType fieldType) {
        this(name, Attribute.convertDataType(fieldType), Attribute.convertCollectionType(fieldType), Attribute.convertTensorType(fieldType), Attribute.convertTargetType(fieldType));
        this.setRemoveIfZero(fieldType instanceof WeightedSetDataType ? ((WeightedSetDataType)fieldType).removeIfZero() : false);
        this.setCreateIfNonExistent(fieldType instanceof WeightedSetDataType ? ((WeightedSetDataType)fieldType).createIfNonExistent() : false);
    }

    public Attribute(String name, Type type, CollectionType collectionType) {
        this(name, type, collectionType, Optional.empty(), Optional.empty());
    }

    public Attribute(String name, Type type, CollectionType collectionType, Optional<TensorType> tensorType, Optional<StructuredDataType> referenceDocumentType) {
        this.name = name;
        this.setType(type);
        this.setCollectionType(collectionType);
        this.tensorType = tensorType;
        this.referenceDocumentType = referenceDocumentType;
    }

    public Attribute convertToArray() {
        Attribute result = this.clone();
        result.collectionType = CollectionType.ARRAY;
        return result;
    }

    public boolean isPrefetch() {
        if (this.prefetch != null) {
            return this.prefetch;
        }
        return CollectionType.SINGLE.equals((Object)this.collectionType);
    }

    public Boolean getPrefetchValue() {
        return this.prefetch;
    }

    public boolean isRemoveIfZero() {
        return this.removeIfZero;
    }

    public boolean isCreateIfNonExistent() {
        return this.createIfNonExistent;
    }

    public boolean isEnabledBitVectors() {
        return this.enableBitVectors;
    }

    public boolean isEnabledOnlyBitVector() {
        return this.enableOnlyBitVector;
    }

    public boolean isFastSearch() {
        return this.fastSearch;
    }

    public boolean isFastRank() {
        return this.fastRank;
    }

    public boolean isFastAccess() {
        return this.fastAccess;
    }

    public boolean isHuge() {
        return this.huge;
    }

    public boolean isPaged() {
        return this.paged;
    }

    public boolean isPosition() {
        return this.isPosition;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public int arity() {
        return this.arity;
    }

    public long lowerBound() {
        return this.lowerBound;
    }

    public long upperBound() {
        return this.upperBound;
    }

    public double densePostingListThreshold() {
        return this.densePostingListThreshold;
    }

    public Optional<TensorType> tensorType() {
        return this.tensorType;
    }

    public Optional<StructuredDataType> referenceDocumentType() {
        return this.referenceDocumentType;
    }

    public DistanceMetric distanceMetric() {
        return this.distanceMetric.orElse(DEFAULT_DISTANCE_METRIC);
    }

    public Optional<HnswIndexParams> hnswIndexParams() {
        return this.hnswIndexParams;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public Case getCase() {
        return this.casing;
    }

    public void setRemoveIfZero(boolean remove) {
        this.removeIfZero = remove;
    }

    public void setCreateIfNonExistent(boolean create) {
        this.createIfNonExistent = create;
    }

    public void setPrefetch(Boolean prefetch) {
        this.prefetch = prefetch;
    }

    public void setEnableBitVectors(boolean enableBitVectors) {
        this.enableBitVectors = enableBitVectors;
    }

    public void setEnableOnlyBitVector(boolean enableOnlyBitVector) {
        this.enableOnlyBitVector = enableOnlyBitVector;
    }

    public void setFastRank(boolean value) {
        Supplier<IllegalArgumentException> badGen = () -> new IllegalArgumentException("The " + this.toString() + " does not support 'fast-rank'. Only supported for tensor types with at least one mapped dimension");
        TensorType tt = this.tensorType.orElseThrow(badGen);
        for (TensorType.Dimension dim : tt.dimensions()) {
            if (!dim.isMapped()) continue;
            this.fastRank = value;
            return;
        }
        throw badGen.get();
    }

    public void setFastSearch(boolean fastSearch) {
        this.fastSearch = fastSearch;
    }

    public void setHuge(boolean huge) {
        this.huge = huge;
    }

    public void setPaged(boolean paged) {
        this.paged = paged;
    }

    public void setFastAccess(boolean fastAccess) {
        this.fastAccess = fastAccess;
    }

    public void setPosition(boolean position) {
        this.isPosition = position;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }

    public void setLowerBound(long lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(long upperBound) {
        this.upperBound = upperBound;
    }

    public void setDensePostingListThreshold(double threshold) {
        this.densePostingListThreshold = threshold;
    }

    public void setTensorType(TensorType tensorType) {
        this.tensorType = Optional.of(tensorType);
    }

    public void setDistanceMetric(DistanceMetric metric) {
        this.distanceMetric = Optional.of(metric);
    }

    public void setHnswIndexParams(HnswIndexParams params) {
        this.hnswIndexParams = Optional.of(params);
    }

    public void setDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void setCase(Case casing) {
        this.casing = casing;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void setType(Type type) {
        this.type = type;
    }

    public void setCollectionType(CollectionType type) {
        this.collectionType = type;
    }

    public static Type convertDataType(DataType fieldType) {
        if (fieldType instanceof NewDocumentReferenceDataType) {
            return Type.REFERENCE;
        }
        if (fieldType instanceof CollectionDataType) {
            return Attribute.convertDataType(((CollectionDataType)fieldType).getNestedType());
        }
        FieldValue fval = fieldType.createFieldValue();
        if (fval instanceof StringFieldValue) {
            return Type.STRING;
        }
        if (fval instanceof IntegerFieldValue) {
            return Type.INTEGER;
        }
        if (fval instanceof LongFieldValue) {
            return Type.LONG;
        }
        if (fval instanceof FloatFieldValue) {
            return Type.FLOAT;
        }
        if (fval instanceof DoubleFieldValue) {
            return Type.DOUBLE;
        }
        if (fval instanceof BoolFieldValue) {
            return Type.BOOL;
        }
        if (fval instanceof Float16FieldValue) {
            return Type.FLOAT16;
        }
        if (fval instanceof ByteFieldValue) {
            return Type.BYTE;
        }
        if (fval instanceof Raw) {
            return Type.BYTE;
        }
        if (fval instanceof PredicateFieldValue) {
            return Type.PREDICATE;
        }
        if (fval instanceof TensorFieldValue) {
            return Type.TENSOR;
        }
        throw new IllegalArgumentException("Don't know which attribute type to convert " + fieldType + " [" + fieldType.getClass() + "] to");
    }

    private static CollectionType convertCollectionType(DataType fieldType) {
        if (fieldType instanceof ArrayDataType) {
            return CollectionType.ARRAY;
        }
        if (fieldType instanceof WeightedSetDataType) {
            return CollectionType.WEIGHTEDSET;
        }
        if (fieldType instanceof TensorDataType) {
            return CollectionType.SINGLE;
        }
        if (fieldType instanceof PrimitiveDataType) {
            return CollectionType.SINGLE;
        }
        if (fieldType instanceof NewDocumentReferenceDataType) {
            return CollectionType.SINGLE;
        }
        throw new IllegalArgumentException("Field " + fieldType + " not supported in convertCollectionType");
    }

    private static Optional<TensorType> convertTensorType(DataType fieldType) {
        if (!(fieldType instanceof TensorDataType)) {
            return Optional.empty();
        }
        return Optional.of(((TensorDataType)fieldType).getTensorType());
    }

    private static Optional<StructuredDataType> convertTargetType(DataType fieldType) {
        return Optional.of(fieldType).filter(NewDocumentReferenceDataType.class::isInstance).map(NewDocumentReferenceDataType.class::cast).map(NewDocumentReferenceDataType::getTargetType);
    }

    private DataType toDataType(Type attributeType) {
        switch (attributeType) {
            case STRING: {
                return DataType.STRING;
            }
            case INTEGER: {
                return DataType.INT;
            }
            case LONG: {
                return DataType.LONG;
            }
            case FLOAT16: {
                return DataType.FLOAT16;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            case BOOL: {
                return DataType.BOOL;
            }
            case BYTE: {
                return DataType.BYTE;
            }
            case PREDICATE: {
                return DataType.PREDICATE;
            }
            case TENSOR: {
                return DataType.getTensor((TensorType)this.tensorType.orElseThrow(IllegalStateException::new));
            }
            case REFERENCE: {
                return this.createReferenceDataType();
            }
        }
        throw new IllegalArgumentException("Unknown attribute type " + attributeType);
    }

    private DataType createReferenceDataType() {
        if (this.referenceDocumentType.isEmpty()) {
            throw new IllegalStateException("Referenced document type is not set");
        }
        StructuredDataType type = this.referenceDocumentType.get();
        if (type instanceof DocumentType) {
            return new NewDocumentReferenceDataType((DocumentType)type);
        }
        return NewDocumentReferenceDataType.forDocumentName(type.getName());
    }

    public DataType getDataType() {
        DataType dataType = this.toDataType(this.type);
        if (this.collectionType == CollectionType.ARRAY) {
            return DataType.getArray((DataType)dataType);
        }
        if (this.collectionType == CollectionType.WEIGHTEDSET) {
            return DataType.getWeightedSet((DataType)dataType, (boolean)this.createIfNonExistent, (boolean)this.removeIfZero);
        }
        return dataType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.collectionType, this.sorting, this.dictionary, this.isPrefetch(), this.fastAccess, this.removeIfZero, this.createIfNonExistent, this.isPosition, this.huge, this.mutable, this.paged, this.enableBitVectors, this.enableOnlyBitVector, this.tensorType, this.referenceDocumentType, this.distanceMetric, this.hnswIndexParams});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)object;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.isCompatible(other);
    }

    public boolean isCompatible(Attribute other) {
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        if (!this.collectionType.equals((Object)other.collectionType)) {
            return false;
        }
        if (this.isPrefetch() != other.isPrefetch()) {
            return false;
        }
        if (this.removeIfZero != other.removeIfZero) {
            return false;
        }
        if (this.createIfNonExistent != other.createIfNonExistent) {
            return false;
        }
        if (this.enableBitVectors != other.enableBitVectors) {
            return false;
        }
        if (this.enableOnlyBitVector != other.enableOnlyBitVector) {
            return false;
        }
        if (this.fastSearch != other.fastSearch) {
            return false;
        }
        if (this.huge != other.huge) {
            return false;
        }
        if (this.mutable != other.mutable) {
            return false;
        }
        if (this.paged != other.paged) {
            return false;
        }
        if (!this.sorting.equals(other.sorting)) {
            return false;
        }
        if (!Objects.equals(this.dictionary, other.dictionary)) {
            return false;
        }
        if (!Objects.equals(this.tensorType, other.tensorType)) {
            return false;
        }
        if (!Objects.equals(this.referenceDocumentType, other.referenceDocumentType)) {
            return false;
        }
        if (!Objects.equals(this.distanceMetric, other.distanceMetric)) {
            return false;
        }
        return Objects.equals(this.hnswIndexParams, other.hnswIndexParams);
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    public String toString() {
        return "attribute '" + this.name + "' (" + (this.tensorType.isPresent() ? this.tensorType.get() : this.type) + ")";
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public static enum Type {
        BYTE("byte", "INT8"),
        SHORT("short", "INT16"),
        INTEGER("integer", "INT32"),
        LONG("long", "INT64"),
        FLOAT16("float16", "FLOAT16"),
        FLOAT("float", "FLOAT"),
        DOUBLE("double", "DOUBLE"),
        STRING("string", "STRING"),
        BOOL("bool", "BOOL"),
        PREDICATE("predicate", "PREDICATE"),
        TENSOR("tensor", "TENSOR"),
        REFERENCE("reference", "REFERENCE");

        private final String myName;
        private final String exportAttributeTypeName;

        private Type(String name, String exportAttributeTypeName) {
            this.myName = name;
            this.exportAttributeTypeName = exportAttributeTypeName;
        }

        public String getName() {
            return this.myName;
        }

        public String getExportAttributeTypeName() {
            return this.exportAttributeTypeName;
        }

        public String toString() {
            return "type: " + this.myName;
        }
    }

    public static enum CollectionType {
        SINGLE("SINGLE"),
        ARRAY("ARRAY"),
        WEIGHTEDSET("WEIGHTEDSET");

        private final String name;

        private CollectionType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "collectiontype: " + this.name;
        }
    }

    public static enum DistanceMetric {
        EUCLIDEAN,
        ANGULAR,
        GEODEGREES,
        INNERPRODUCT,
        HAMMING;

    }
}

